/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanforderung.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter, die das Verhalten der Applikation
					KEx-WSDL-Programm steuern.
<p>
Insbesondere wird hier beschrieben, welche Programme
					die externe Stelle überhaupt anfordern kann.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class PdParameterKExWSDLProgramm extends AbstractParameterDatensatz<PdParameterKExWSDLProgramm.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				> _verfuegbareProgramme = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				>(0, true);
				@Defaultwert(wert = "0.0.0.0")
				private String
				 _schnittstelle
				= new String
				()
				;
				@Defaultwert(wert = "80")
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
				 _port
				;
				@Defaultwert(wert = "kexwsdlprogramm")
				private String
				 _pfad
				= new String
				()
				;
				@Defaultwert(wert = "Keine weiteren Informationen verfügbar")
				private String
				 _standardErrorText
				= new String
				()
				;
				@Defaultwert(wert = "15 Minuten")
				private 	RelativerZeitstempel
				 _schaltanforderungsTimeout
				;
				@Defaultwert(wert = "NULLPROGRAMM")
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 _programmBeiTimeout
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _beiTimeoutVerkehrsautomatikDeaktivieren
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Die Liste von Schaltprogrammen, die der WSDL-Client
									sieht. Diese Liste ist das Ergebnis der WSDL-Schnittstellenmethode
									getAvailablePrograms().
			<p>
			
			</p>
			
			@return der Wert von VerfuegbareProgramme.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				> getVerfuegbareProgramme() {
				return _verfuegbareProgramme;
			}
		
		
			/**
			Die lokale Netzwerkschnittstelle, an der Verbindungen
									akzeptiert werden. Kann ein symbolischer Hostname oder eine IP-
									Adresse in DOT-Notation sein (z.B. 192.168.0.1). Der spezielle
									Wert 0.0.0.0 bedeutet: Alle lokalen Schnittstellen.
			<p>
			
			</p>
			
			@return der Wert von Schnittstelle.
			*/
				public String
				 getSchnittstelle() {
				return _schnittstelle;
			}
		
			/**
			Die lokale Netzwerkschnittstelle, an der Verbindungen
									akzeptiert werden. Kann ein symbolischer Hostname oder eine IP-
									Adresse in DOT-Notation sein (z.B. 192.168.0.1). Der spezielle
									Wert 0.0.0.0 bedeutet: Alle lokalen Schnittstellen.
			<p>
			
			</p>
			
			@param _schnittstelle der neue Wert von Schnittstelle.
			*/
			public void setSchnittstelle(String
			 _schnittstelle) {
				if (_schnittstelle.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._schnittstelle = _schnittstelle;
			}
		
			/**
			Der TCP-Port, an dem der WSDL-Server Verbindungen
									akzeptiert.
			<p>
			
			</p>
			
			@return der Wert von Port.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
				 getPort() {
				return _port;
			}
		
			/**
			Der TCP-Port, an dem der WSDL-Server Verbindungen
									akzeptiert.
			<p>
			
			</p>
			
			@param _port der neue Wert von Port.
			*/
			public void setPort(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
			 _port) {
				this._port = _port;
			}
		
			/**
			Der Teil der URL, der zwischen der Adressspezifikation
									und dem Slash-Fragezeichen steht.
			<p>
			
			</p>
			
			@return der Wert von Pfad.
			*/
				public String
				 getPfad() {
				return _pfad;
			}
		
			/**
			Der Teil der URL, der zwischen der Adressspezifikation
									und dem Slash-Fragezeichen steht.
			<p>
			
			</p>
			
			@param _pfad der neue Wert von Pfad.
			*/
			public void setPfad(String
			 _pfad) {
				if (_pfad.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._pfad = _pfad;
			}
		
			/**
			Wird in ein Objekt vom Typ ProgramState eingetragen, wenn
									aus dem API-Aufruf kein Fehlertext zu bestimmen ist.
			<p>
			
			</p>
			
			@return der Wert von StandardErrorText.
			*/
				public String
				 getStandardErrorText() {
				return _standardErrorText;
			}
		
			/**
			Wird in ein Objekt vom Typ ProgramState eingetragen, wenn
									aus dem API-Aufruf kein Fehlertext zu bestimmen ist.
			<p>
			
			</p>
			
			@param _standardErrorText der neue Wert von StandardErrorText.
			*/
			public void setStandardErrorText(String
			 _standardErrorText) {
				if (_standardErrorText.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._standardErrorText = _standardErrorText;
			}
		
			/**
			Schaltanforderungs-Timeout (in Minuten).
			<p>
			Diese Zeitspanne ist die Karenzzeit, innerhalb derer von INES eine neue Schaltanforderung erwartet wird, ganz gleich, ob dasselbe oder ein anderes Szenario angefordert wird.
			</p>
			
			@return der Wert von SchaltanforderungsTimeout.
			*/
				public 	RelativerZeitstempel
				 getSchaltanforderungsTimeout() {
				return _schaltanforderungsTimeout;
			}
		
			/**
			Schaltanforderungs-Timeout (in Minuten).
			<p>
			Diese Zeitspanne ist die Karenzzeit, innerhalb derer von INES eine neue Schaltanforderung erwartet wird, ganz gleich, ob dasselbe oder ein anderes Szenario angefordert wird.
			</p>
			
			@param _schaltanforderungsTimeout der neue Wert von SchaltanforderungsTimeout.
			*/
			public void setSchaltanforderungsTimeout(	RelativerZeitstempel
			 _schaltanforderungsTimeout) {
				this._schaltanforderungsTimeout = _schaltanforderungsTimeout;
			}
		
			/**
			Wenn innerhalb dieser Zeitspanne keine weitere Anforderung von INES eintrifft, wird dieses Programm angefordert.
			<p>
			
			</p>
			
			@return der Wert von ProgrammBeiTimeout.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 getProgrammBeiTimeout() {
				return _programmBeiTimeout;
			}
		
			/**
			Wenn innerhalb dieser Zeitspanne keine weitere Anforderung von INES eintrifft, wird dieses Programm angefordert.
			<p>
			
			</p>
			
			@param _programmBeiTimeout der neue Wert von ProgrammBeiTimeout.
			*/
			public void setProgrammBeiTimeout(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _programmBeiTimeout) {
				this._programmBeiTimeout = _programmBeiTimeout;
			}
		
			/**
			Wenn dieser Parameter true gesetzt ist, so würden nach einem Timeout und der Anforderung des ProgrammBeiTimeout auch neue Anforderungen durch INES nicht zu einer Schaltung führen, bevor nicht durch den Operator eine Wiederfreigabe der Verkehrsautomatik erfolgt ist.
			<p>
			
			</p>
			
			@return der Wert von BeiTimeoutVerkehrsautomatikDeaktivieren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getBeiTimeoutVerkehrsautomatikDeaktivieren() {
				return _beiTimeoutVerkehrsautomatikDeaktivieren;
			}
		
			/**
			Wenn dieser Parameter true gesetzt ist, so würden nach einem Timeout und der Anforderung des ProgrammBeiTimeout auch neue Anforderungen durch INES nicht zu einer Schaltung führen, bevor nicht durch den Operator eine Wiederfreigabe der Verkehrsautomatik erfolgt ist.
			<p>
			
			</p>
			
			@param _beiTimeoutVerkehrsautomatikDeaktivieren der neue Wert von BeiTimeoutVerkehrsautomatikDeaktivieren.
			*/
			public void setBeiTimeoutVerkehrsautomatikDeaktivieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _beiTimeoutVerkehrsautomatikDeaktivieren) {
				this._beiTimeoutVerkehrsautomatikDeaktivieren = _beiTimeoutVerkehrsautomatikDeaktivieren;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayVerfuegbareProgramme = datum.getReferenceArray("VerfügbareProgramme");
						arrayVerfuegbareProgramme.setLength(getVerfuegbareProgramme().size());
						for (int i = 0; i < arrayVerfuegbareProgramme.getLength(); ++i) {
							final Object soVerfuegbareProgramme = getVerfuegbareProgramme().get(i);
							final SystemObject tmpVerfuegbareProgramme;
							if (soVerfuegbareProgramme instanceof SystemObject) {
								tmpVerfuegbareProgramme = (SystemObject)soVerfuegbareProgramme;
							} else if(soVerfuegbareProgramme instanceof SystemObjekt){
								tmpVerfuegbareProgramme = ((SystemObjekt)soVerfuegbareProgramme).getSystemObject();
							} else{
								tmpVerfuegbareProgramme = null;
							}
							arrayVerfuegbareProgramme.getReferenceValue(i).setSystemObject(tmpVerfuegbareProgramme);
						}
					// ZeichenkettenAttributTyp
					if (getSchnittstelle() != null) {
						datum.getTextValue("Schnittstelle").setText(getSchnittstelle());
					}
					// GanzzahlAttributTyp
					if (getPort() != null) {
		                if (getPort().isZustand()) {
		                    datum.getUnscaledValue("Port").setText(getPort().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Port").set(getPort().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getPfad() != null) {
						datum.getTextValue("Pfad").setText(getPfad());
					}
					// ZeichenkettenAttributTyp
					if (getStandardErrorText() != null) {
						datum.getTextValue("StandardErrorText").setText(getStandardErrorText());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("SchaltanforderungsTimeout").setMillis(getSchaltanforderungsTimeout().getTime());
					// ObjektReferenzAttributTyp
						final Object soProgrammBeiTimeout = getProgrammBeiTimeout();
						final SystemObject tmpProgrammBeiTimeout;
							if (soProgrammBeiTimeout instanceof SystemObject) {
								tmpProgrammBeiTimeout = (SystemObject)soProgrammBeiTimeout;
							} else if(soProgrammBeiTimeout instanceof SystemObjekt){
								tmpProgrammBeiTimeout = ((SystemObjekt)soProgrammBeiTimeout).getSystemObject();
							} else{
								tmpProgrammBeiTimeout = null;
							}
						datum.getReferenceValue("ProgrammBeiTimeout").setSystemObject(tmpProgrammBeiTimeout);
					// GanzzahlAttributTyp
					if (getBeiTimeoutVerkehrsautomatikDeaktivieren() != null) {
		                if (getBeiTimeoutVerkehrsautomatikDeaktivieren().isZustand()) {
		                    datum.getUnscaledValue("BeiTimeoutVerkehrsautomatikDeaktivieren").setText(getBeiTimeoutVerkehrsautomatikDeaktivieren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BeiTimeoutVerkehrsautomatikDeaktivieren").set(getBeiTimeoutVerkehrsautomatikDeaktivieren().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayVerfuegbareProgramme = daten.getReferenceArray("VerfügbareProgramme");
						for (int i = 0; i < arrayVerfuegbareProgramme.getLength(); ++i) {
							final long idVerfuegbareProgramme = daten.getReferenceArray("VerfügbareProgramme").getReferenceValue(i).getId();
							final SystemObjekt tmpVerfuegbareProgramme;
							if (idVerfuegbareProgramme == 0) {
								tmpVerfuegbareProgramme = null;
							} else {
								final SystemObject soVerfuegbareProgramme = factory.getDav().getDataModel().getObject(idVerfuegbareProgramme);
								if (soVerfuegbareProgramme == null) {
										tmpVerfuegbareProgramme = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idVerfuegbareProgramme);
								} else {
									tmpVerfuegbareProgramme = factory.getModellobjekt(soVerfuegbareProgramme);
								}
							}
								getVerfuegbareProgramme().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
								) tmpVerfuegbareProgramme);
						}
					// ZeichenkettenAttributTyp
						setSchnittstelle(daten.getTextValue("Schnittstelle").getText());
					// GanzzahlAttributTyp
							setPort(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
							(daten.
								getUnscaledValue
							("Port").
									intValue
							()));
					// ZeichenkettenAttributTyp
						setPfad(daten.getTextValue("Pfad").getText());
					// ZeichenkettenAttributTyp
						setStandardErrorText(daten.getTextValue("StandardErrorText").getText());
					// ZeitstempelAttributTyp
						setSchaltanforderungsTimeout(new
							RelativerZeitstempel
							(daten.getTimeValue("SchaltanforderungsTimeout").getMillis()));
					// ObjektReferenzAttributTyp
						final long idProgrammBeiTimeout = daten.getReferenceValue("ProgrammBeiTimeout").getId();
						final SystemObjekt tmpProgrammBeiTimeout;
						if (idProgrammBeiTimeout == 0) {
							tmpProgrammBeiTimeout = null;
						} else {
							final SystemObject soProgrammBeiTimeout = factory.getDav().getDataModel().getObject(idProgrammBeiTimeout);
							if (soProgrammBeiTimeout == null) {
									tmpProgrammBeiTimeout = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idProgrammBeiTimeout);
							} else {
								tmpProgrammBeiTimeout = factory.getModellobjekt(soProgrammBeiTimeout);
							}
						}
						setProgrammBeiTimeout((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
						) tmpProgrammBeiTimeout);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BeiTimeoutVerkehrsautomatikDeaktivieren").isState()) {
								setBeiTimeoutVerkehrsautomatikDeaktivieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("BeiTimeoutVerkehrsautomatikDeaktivieren").getText()));
							} else {
							setBeiTimeoutVerkehrsautomatikDeaktivieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("BeiTimeoutVerkehrsautomatikDeaktivieren").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._verfuegbareProgramme = getVerfuegbareProgramme().clone();
							klon.setSchnittstelle(getSchnittstelle());
							klon.setPort(getPort());
							klon.setPfad(getPfad());
							klon.setStandardErrorText(getStandardErrorText());
							klon.setSchaltanforderungsTimeout(getSchaltanforderungsTimeout());
							klon.setProgrammBeiTimeout(getProgrammBeiTimeout());
							klon.setBeiTimeoutVerkehrsautomatikDeaktivieren(getBeiTimeoutVerkehrsautomatikDeaktivieren());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parameterKExWSDLProgramm";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdParameterKExWSDLProgramm(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
