/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert ein Vorkommen eines Symbols an einer konkreten Position auf der FTA (Grafikcontainer).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlGrafikSymbolDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 _positionX
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 _positionY
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.GrafikSymbol
			 _grafikSymbolReferenz
			;
	
		/**
		Attribut für Grafikeinheit (Pixel).
		<p>
		
		</p>
		
		@return der Wert von PositionX.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 getPositionX() {
			return _positionX;
		}
	
		/**
		Attribut für Grafikeinheit (Pixel).
		<p>
		
		</p>
		
		@param _positionX der neue Wert von PositionX.
		*/
		public void setPositionX(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
		 _positionX) {
			this._positionX = _positionX;
		}
	
		/**
		Attribut für Grafikeinheit (Pixel).
		<p>
		
		</p>
		
		@return der Wert von PositionY.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 getPositionY() {
			return _positionY;
		}
	
		/**
		Attribut für Grafikeinheit (Pixel).
		<p>
		
		</p>
		
		@param _positionY der neue Wert von PositionY.
		*/
		public void setPositionY(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
		 _positionY) {
			this._positionY = _positionY;
		}
	
		/**
		Referenze auf ein Objekt vom Typ typ.grafikSymbol.
		<p>
		
		</p>
		
		@return der Wert von GrafikSymbolReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.GrafikSymbol
			 getGrafikSymbolReferenz() {
			return _grafikSymbolReferenz;
		}
	
		/**
		Referenze auf ein Objekt vom Typ typ.grafikSymbol.
		<p>
		
		</p>
		
		@param _grafikSymbolReferenz der neue Wert von GrafikSymbolReferenz.
		*/
		public void setGrafikSymbolReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.GrafikSymbol
		 _grafikSymbolReferenz) {
			this._grafikSymbolReferenz = _grafikSymbolReferenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getPositionX() != null) {
	                if (getPositionX().isZustand()) {
	                    datum.getUnscaledValue("PositionX").setText(getPositionX().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("PositionX").set(getPositionX().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPositionY() != null) {
	                if (getPositionY().isZustand()) {
	                    datum.getUnscaledValue("PositionY").setText(getPositionY().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("PositionY").set(getPositionY().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soGrafikSymbolReferenz = getGrafikSymbolReferenz();
					final SystemObject tmpGrafikSymbolReferenz;
						if (soGrafikSymbolReferenz instanceof SystemObject) {
							tmpGrafikSymbolReferenz = (SystemObject)soGrafikSymbolReferenz;
						} else if(soGrafikSymbolReferenz instanceof SystemObjekt){
							tmpGrafikSymbolReferenz = ((SystemObjekt)soGrafikSymbolReferenz).getSystemObject();
						} else{
							tmpGrafikSymbolReferenz = null;
						}
					datum.getReferenceValue("GrafikSymbolReferenz").setSystemObject(tmpGrafikSymbolReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setPositionX(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
						(daten.
							getUnscaledValue
						("PositionX").
								intValue
						()));
				// GanzzahlAttributTyp
						setPositionY(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
						(daten.
							getUnscaledValue
						("PositionY").
								intValue
						()));
				// ObjektReferenzAttributTyp
					final long idGrafikSymbolReferenz = daten.getReferenceValue("GrafikSymbolReferenz").getId();
					final SystemObjekt tmpGrafikSymbolReferenz;
					if (idGrafikSymbolReferenz == 0) {
						tmpGrafikSymbolReferenz = null;
					} else {
						final SystemObject soGrafikSymbolReferenz = factory.getDav().getDataModel().getObject(idGrafikSymbolReferenz);
						if (soGrafikSymbolReferenz == null) {
								tmpGrafikSymbolReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.impl.GrafikSymbolUngueltig(idGrafikSymbolReferenz);
						} else {
							tmpGrafikSymbolReferenz = factory.getModellobjekt(soGrafikSymbolReferenz);
						}
					}
					setGrafikSymbolReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.GrafikSymbol
					) tmpGrafikSymbolReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGrafikSymbolDaten clone() {
		AtlGrafikSymbolDaten klon = new AtlGrafikSymbolDaten();
		
						klon.setPositionX(getPositionX());
						klon.setPositionY(getPositionY());
						klon.setGrafikSymbolReferenz(getGrafikSymbolReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
