/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Logische Eigenschaften der Anzeige für die
					Verriegelung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAnzeigeEigenschaften extends AbstractKonfigurationsDatensatz<KdAnzeigeEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 _zeigtInRichtung
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
				 _liegtAufFahrSpur
				;
				private Feld<	Object
				> _deList = new Feld<	Object
				>(0, true);
		
			/**
			Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
			<p>
			
			</p>
			
			@return der Wert von ZeigtInRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 getZeigtInRichtung() {
				return _zeigtInRichtung;
			}
		
			/**
			Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
			<p>
			
			</p>
			
			@param _zeigtInRichtung der neue Wert von ZeigtInRichtung.
			*/
			public void setZeigtInRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
			 _zeigtInRichtung) {
				this._zeigtInRichtung = _zeigtInRichtung;
			}
		
			/**
			Verweis auf ein Objekt vom Typ typ.fahrSpur, welche auch null sein darf.
			<p>
			
			</p>
			
			@return der Wert von LiegtAufFahrSpur.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
				 getLiegtAufFahrSpur() {
				return _liegtAufFahrSpur;
			}
		
			/**
			Verweis auf ein Objekt vom Typ typ.fahrSpur, welche auch null sein darf.
			<p>
			
			</p>
			
			@param _liegtAufFahrSpur der neue Wert von LiegtAufFahrSpur.
			*/
			public void setLiegtAufFahrSpur(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
			 _liegtAufFahrSpur) {
				this._liegtAufFahrSpur = _liegtAufFahrSpur;
			}
		
			/**
			Attribut zur Referenzierung von beliebigen Objekten.
			<p>
			
			</p>
			
			@return der Wert von DeList.
			*/
				public Feld<	Object
				> getDeList() {
				return _deList;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getZeigtInRichtung() != null) {
		                if (getZeigtInRichtung().isZustand()) {
		                    datum.getUnscaledValue("ZeigtInRichtung").setText(getZeigtInRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZeigtInRichtung").set(getZeigtInRichtung().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soLiegtAufFahrSpur = getLiegtAufFahrSpur();
						final SystemObject tmpLiegtAufFahrSpur;
							if (soLiegtAufFahrSpur instanceof SystemObject) {
								tmpLiegtAufFahrSpur = (SystemObject)soLiegtAufFahrSpur;
							} else if(soLiegtAufFahrSpur instanceof SystemObjekt){
								tmpLiegtAufFahrSpur = ((SystemObjekt)soLiegtAufFahrSpur).getSystemObject();
							} else{
								tmpLiegtAufFahrSpur = null;
							}
						datum.getReferenceValue("LiegtAufFahrSpur").setSystemObject(tmpLiegtAufFahrSpur);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayDeList = datum.getReferenceArray("DeList");
						arrayDeList.setLength(getDeList().size());
						for (int i = 0; i < arrayDeList.getLength(); ++i) {
							final Object soDeList = getDeList().get(i);
							final SystemObject tmpDeList;
							if (soDeList instanceof SystemObject) {
								tmpDeList = (SystemObject)soDeList;
							} else if(soDeList instanceof SystemObjekt){
								tmpDeList = ((SystemObjekt)soDeList).getSystemObject();
							} else{
								tmpDeList = null;
							}
							arrayDeList.getReferenceValue(i).setSystemObject(tmpDeList);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZeigtInRichtung").isState()) {
								setZeigtInRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
								.getZustand(daten.getScaledValue("ZeigtInRichtung").getText()));
							} else {
							setZeigtInRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
							(daten.
								getUnscaledValue
							("ZeigtInRichtung").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idLiegtAufFahrSpur = daten.getReferenceValue("LiegtAufFahrSpur").getId();
						final SystemObjekt tmpLiegtAufFahrSpur;
						if (idLiegtAufFahrSpur == 0) {
							tmpLiegtAufFahrSpur = null;
						} else {
							final SystemObject soLiegtAufFahrSpur = factory.getDav().getDataModel().getObject(idLiegtAufFahrSpur);
							if (soLiegtAufFahrSpur == null) {
									tmpLiegtAufFahrSpur = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.impl.FahrSpurUngueltig(idLiegtAufFahrSpur);
							} else {
								tmpLiegtAufFahrSpur = factory.getModellobjekt(soLiegtAufFahrSpur);
							}
						}
						setLiegtAufFahrSpur((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
						) tmpLiegtAufFahrSpur);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayDeList = daten.getReferenceArray("DeList");
						for (int i = 0; i < arrayDeList.getLength(); ++i) {
							final long idDeList = daten.getReferenceArray("DeList").getReferenceValue(i).getId();
							final SystemObjekt tmpDeList;
							if (idDeList == 0) {
								tmpDeList = null;
							} else {
								final SystemObject soDeList = factory.getDav().getDataModel().getObject(idDeList);
								if (soDeList == null) {
										tmpDeList = new BaseUngueltigesSystemObjekt(idDeList);
								} else {
									tmpDeList = factory.getModellobjekt(soDeList);
								}
							}
								getDeList().add((	Object
								) tmpDeList);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setZeigtInRichtung(getZeigtInRichtung());
							klon.setLiegtAufFahrSpur(getLiegtAufFahrSpur());
						klon._deList = getDeList().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAnzeigeEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
