/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein Kommando des
					Bedienerkommunikationsservers.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBedienerAnfrage implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _applikationsID
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anfrageID
			;
			private String
			 _frage
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
			> _moeglicheAntworten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
			>(0, true);
			private 	Zeitstempel
			 _timeout
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 _nutzer
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageErgebnis
			 _ergebnis
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageStatus
			 _zustand
			;
			private String
			 _kommentar
			= new String
			()
			;
			private 	Zeitstempel
			 _wiedervorlage
			;
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von ApplikationsID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getApplikationsID() {
			return _applikationsID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _applikationsID der neue Wert von ApplikationsID.
		*/
		public void setApplikationsID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _applikationsID) {
			this._applikationsID = _applikationsID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von AnfrageID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getAnfrageID() {
			return _anfrageID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _anfrageID der neue Wert von AnfrageID.
		*/
		public void setAnfrageID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _anfrageID) {
			this._anfrageID = _anfrageID;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Frage.
		*/
			public String
			 getFrage() {
			return _frage;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _frage der neue Wert von Frage.
		*/
		public void setFrage(String
		 _frage) {
			if (_frage.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._frage = _frage;
		}
	
		/**
		Beschreibt eine Antwort eines Bedieners auf eine
							Frage.
		<p>
		
		</p>
		
		@return der Wert von MoeglicheAntworten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
			> getMoeglicheAntworten() {
			return _moeglicheAntworten;
		}
	
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Timeout.
		*/
			public 	Zeitstempel
			 getTimeout() {
			return _timeout;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _timeout der neue Wert von Timeout.
		*/
		public void setTimeout(	Zeitstempel
		 _timeout) {
			this._timeout = _timeout;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.benutzer.
		<p>
		
		</p>
		
		@return der Wert von Nutzer.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 getNutzer() {
			return _nutzer;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.benutzer.
		<p>
		
		</p>
		
		@param _nutzer der neue Wert von Nutzer.
		*/
		public void setNutzer(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
		 _nutzer) {
			this._nutzer = _nutzer;
		}
	
		/**
		Ergebnis einer Bedieneranfrage, kann von Server
							oder Visualisierung
							verändert werden.
		<p>
		
		</p>
		
		@return der Wert von Ergebnis.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageErgebnis
			 getErgebnis() {
			return _ergebnis;
		}
	
		/**
		Ergebnis einer Bedieneranfrage, kann von Server
							oder Visualisierung
							verändert werden.
		<p>
		
		</p>
		
		@param _ergebnis der neue Wert von Ergebnis.
		*/
		public void setErgebnis(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageErgebnis
		 _ergebnis) {
			this._ergebnis = _ergebnis;
		}
	
		/**
		Zustandsvariable einer Bedieneranfrage,
							kann von allen beteiligten Applikationen
							verändert werden.
		<p>
		
		</p>
		
		@return der Wert von Zustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageStatus
			 getZustand() {
			return _zustand;
		}
	
		/**
		Zustandsvariable einer Bedieneranfrage,
							kann von allen beteiligten Applikationen
							verändert werden.
		<p>
		
		</p>
		
		@param _zustand der neue Wert von Zustand.
		*/
		public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageStatus
		 _zustand) {
			this._zustand = _zustand;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Kommentar.
		*/
			public String
			 getKommentar() {
			return _kommentar;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _kommentar der neue Wert von Kommentar.
		*/
		public void setKommentar(String
		 _kommentar) {
			if (_kommentar.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._kommentar = _kommentar;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Wiedervorlage.
		*/
			public 	Zeitstempel
			 getWiedervorlage() {
			return _wiedervorlage;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _wiedervorlage der neue Wert von Wiedervorlage.
		*/
		public void setWiedervorlage(	Zeitstempel
		 _wiedervorlage) {
			this._wiedervorlage = _wiedervorlage;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getApplikationsID() != null) {
	                if (getApplikationsID().isZustand()) {
	                    datum.getUnscaledValue("ApplikationsID").setText(getApplikationsID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ApplikationsID").set(getApplikationsID().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnfrageID() != null) {
	                if (getAnfrageID().isZustand()) {
	                    datum.getUnscaledValue("AnfrageID").setText(getAnfrageID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnfrageID").set(getAnfrageID().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getFrage() != null) {
					datum.getTextValue("Frage").setText(getFrage());
				}
				// AttributListenDefinition
					final Data.Array arrayMoeglicheAntworten = datum.getArray("MoeglicheAntworten");
					arrayMoeglicheAntworten.setLength(getMoeglicheAntworten().size());
					for (int i = 0; i < arrayMoeglicheAntworten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
						 atl = getMoeglicheAntworten().get(i);
						atl.bean2Atl(arrayMoeglicheAntworten.getItem(i), factory);
	
					}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Timeout").setMillis(getTimeout().getTime());
				// ObjektReferenzAttributTyp
					final Object soNutzer = getNutzer();
					final SystemObject tmpNutzer;
						if (soNutzer instanceof SystemObject) {
							tmpNutzer = (SystemObject)soNutzer;
						} else if(soNutzer instanceof SystemObjekt){
							tmpNutzer = ((SystemObjekt)soNutzer).getSystemObject();
						} else{
							tmpNutzer = null;
						}
					datum.getReferenceValue("Nutzer").setSystemObject(tmpNutzer);
				// GanzzahlAttributTyp
				if (getErgebnis() != null) {
	                if (getErgebnis().isZustand()) {
	                    datum.getUnscaledValue("Ergebnis").setText(getErgebnis().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Ergebnis").set(getErgebnis().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZustand() != null) {
	                if (getZustand().isZustand()) {
	                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zustand").set(getZustand().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getKommentar() != null) {
					datum.getTextValue("Kommentar").setText(getKommentar());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Wiedervorlage").setMillis(getWiedervorlage().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setApplikationsID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("ApplikationsID").
								longValue
						()));
				// GanzzahlAttributTyp
						setAnfrageID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("AnfrageID").
								longValue
						()));
				// ZeichenkettenAttributTyp
					setFrage(daten.getTextValue("Frage").getText());
				// AttributListenDefinition
					final Data.Array arrayMoeglicheAntworten = daten.getArray("MoeglicheAntworten");
					for (int i = 0; i < arrayMoeglicheAntworten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlBedienerAntwort
						 ();
						atl.atl2Bean(arrayMoeglicheAntworten.getItem(i), factory);
						getMoeglicheAntworten().add(atl);
					}
				// ZeitstempelAttributTyp
					setTimeout(new
						Zeitstempel
						(daten.getTimeValue("Timeout").getMillis()));
				// ObjektReferenzAttributTyp
					final long idNutzer = daten.getReferenceValue("Nutzer").getId();
					final SystemObjekt tmpNutzer;
					if (idNutzer == 0) {
						tmpNutzer = null;
					} else {
						final SystemObject soNutzer = factory.getDav().getDataModel().getObject(idNutzer);
						if (soNutzer == null) {
								tmpNutzer = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.BenutzerUngueltig(idNutzer);
						} else {
							tmpNutzer = factory.getModellobjekt(soNutzer);
						}
					}
					setNutzer((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
					) tmpNutzer);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Ergebnis").isState()) {
							setErgebnis(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageErgebnis
							.getZustand(daten.getScaledValue("Ergebnis").getText()));
						} else {
						setErgebnis(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageErgebnis
						(daten.
							getUnscaledValue
						("Ergebnis").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zustand").isState()) {
							setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageStatus
							.getZustand(daten.getScaledValue("Zustand").getText()));
						} else {
						setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AttAnfrageStatus
						(daten.
							getUnscaledValue
						("Zustand").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setKommentar(daten.getTextValue("Kommentar").getText());
				// ZeitstempelAttributTyp
					setWiedervorlage(new
						Zeitstempel
						(daten.getTimeValue("Wiedervorlage").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBedienerAnfrage clone() {
		AtlBedienerAnfrage klon = new AtlBedienerAnfrage();
		
						klon.setApplikationsID(getApplikationsID());
						klon.setAnfrageID(getAnfrageID());
						klon.setFrage(getFrage());
					klon._moeglicheAntworten = getMoeglicheAntworten().clone();
						klon.setTimeout(getTimeout());
						klon.setNutzer(getNutzer());
						klon.setErgebnis(getErgebnis());
						klon.setZustand(getZustand());
						klon.setKommentar(getKommentar());
						klon.setWiedervorlage(getWiedervorlage());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
