/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Diese Datenstruktur wird zwischen Bedienoberfläche bzw. auch
				anderen Serverprogrammen und dem Bildverwaltungs-Server ausgetauscht.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdBildVerwaltungsServerKommando extends AbstractOnlineDatensatz<OdBildVerwaltungsServerKommando.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _applikationsID
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _anfrageID
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _progressObjektID
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerKommandotyp
				 _kommandoTyp
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlInhaltGrafikFreiBilddaten
				> _bildUndMetadaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlInhaltGrafikFreiBilddaten
				>(1, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerAntworttyp
				 _antwortTyp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von ApplikationsID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getApplikationsID() {
				return _applikationsID;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _applikationsID der neue Wert von ApplikationsID.
			*/
			public void setApplikationsID(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _applikationsID) {
				this._applikationsID = _applikationsID;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von AnfrageID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getAnfrageID() {
				return _anfrageID;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _anfrageID der neue Wert von AnfrageID.
			*/
			public void setAnfrageID(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _anfrageID) {
				this._anfrageID = _anfrageID;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von ProgressObjektID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getProgressObjektID() {
				return _progressObjektID;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _progressObjektID der neue Wert von ProgressObjektID.
			*/
			public void setProgressObjektID(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _progressObjektID) {
				this._progressObjektID = _progressObjektID;
			}
		
			/**
			Die Menge der möglichen Kommandos an den Bildverwaltungs-Server.
			<p>
			
			</p>
			
			@return der Wert von KommandoTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerKommandotyp
				 getKommandoTyp() {
				return _kommandoTyp;
			}
		
			/**
			Die Menge der möglichen Kommandos an den Bildverwaltungs-Server.
			<p>
			
			</p>
			
			@param _kommandoTyp der neue Wert von KommandoTyp.
			*/
			public void setKommandoTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerKommandotyp
			 _kommandoTyp) {
				this._kommandoTyp = _kommandoTyp;
			}
		
			/**
			Beschreibt die Struktur von Bilddaten zur Verwendung bei der Kommunikation
							zwischen Bedienoberfläche und Bildverwaltungs-Server sowie zur Verwaltung
							der auf die SSTs heruntergeladenen Bitmaps.
			<p>
			&lt;absatz&gt;Die Attributliste verwaltet zum einen die semantischen Daten in den
							Attributen GrafikTextDaten und GrafikSymbolDaten, diese dienen dazu, die Informationen
							in den Editor zum Bearbeiten zu laden und zur Suche im Archiv.&lt;&#47;absatz&gt;
							&lt;absatz&gt;Zum anderen wird die vom Editor aus diesen sematischen Inhalten erstellte
							Bitmap im Attribut Bild mit transportiert, inkl. Header. Die Farbtiefe der Bitmap
							muss mit der Farbtiefe unseres übergeordneten Anzeigetyps übereinstimmen.
							Der Name der Bitmap wird aus dem Attribut URL entnommen, er wird u.a.
							beim Download auf die SST benötigt.&lt;&#47;absatz&gt;
							&lt;absatz&gt;Schlussendlich wird noch eine variabel lange Liste von anzeigen transportiert.
							Auf der Strecke Bedienoberfläche --&gt; Bildverwaltungs-Server dient sie als
							Kommando, auf welche Anzeigen, sprich DEs, das Bild heruntergeladen werden soll. Auf Seite
							des Bildverwaltungs-Servers wird hier dynamisch gespeichert, auf welchen Anzeigen, sprich DEs,
							das Bild wirklich vorhanden und mit unserem Stellcode belegt, also mithin
							schaltbar ist.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von BildUndMetadaten.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlInhaltGrafikFreiBilddaten
				> getBildUndMetadaten() {
				return _bildUndMetadaten;
			}
		
		
			/**
			Die Menge der möglichen Antworten des Bildverwaltungs-Servers.
			<p>
			
			</p>
			
			@return der Wert von AntwortTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerAntworttyp
				 getAntwortTyp() {
				return _antwortTyp;
			}
		
			/**
			Die Menge der möglichen Antworten des Bildverwaltungs-Servers.
			<p>
			
			</p>
			
			@param _antwortTyp der neue Wert von AntwortTyp.
			*/
			public void setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerAntworttyp
			 _antwortTyp) {
				this._antwortTyp = _antwortTyp;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getApplikationsID() != null) {
		                if (getApplikationsID().isZustand()) {
		                    datum.getUnscaledValue("ApplikationsID").setText(getApplikationsID().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ApplikationsID").set(getApplikationsID().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnfrageID() != null) {
		                if (getAnfrageID().isZustand()) {
		                    datum.getUnscaledValue("AnfrageID").setText(getAnfrageID().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnfrageID").set(getAnfrageID().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getProgressObjektID() != null) {
		                if (getProgressObjektID().isZustand()) {
		                    datum.getUnscaledValue("ProgressObjektID").setText(getProgressObjektID().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ProgressObjektID").set(getProgressObjektID().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKommandoTyp() != null) {
		                if (getKommandoTyp().isZustand()) {
		                    datum.getUnscaledValue("KommandoTyp").setText(getKommandoTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KommandoTyp").set(getKommandoTyp().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayBildUndMetadaten = datum.getArray("BildUndMetadaten");
						arrayBildUndMetadaten.setLength(getBildUndMetadaten().size());
						for (int i = 0; i < arrayBildUndMetadaten.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlInhaltGrafikFreiBilddaten
							 atl = getBildUndMetadaten().get(i);
							atl.bean2Atl(arrayBildUndMetadaten.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getAntwortTyp() != null) {
		                if (getAntwortTyp().isZustand()) {
		                    datum.getUnscaledValue("AntwortTyp").setText(getAntwortTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AntwortTyp").set(getAntwortTyp().getValue());
		                }
					}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setApplikationsID(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("ApplikationsID").
									longValue
							()));
					// GanzzahlAttributTyp
							setAnfrageID(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("AnfrageID").
									longValue
							()));
					// GanzzahlAttributTyp
							setProgressObjektID(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("ProgressObjektID").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KommandoTyp").isState()) {
								setKommandoTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerKommandotyp
								.getZustand(daten.getScaledValue("KommandoTyp").getText()));
							} else {
							setKommandoTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerKommandotyp
							(daten.
								getUnscaledValue
							("KommandoTyp").
									byteValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayBildUndMetadaten = daten.getArray("BildUndMetadaten");
						for (int i = 0; i < arrayBildUndMetadaten.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlInhaltGrafikFreiBilddaten
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlInhaltGrafikFreiBilddaten
							 ();
							atl.atl2Bean(arrayBildUndMetadaten.getItem(i), factory);
							getBildUndMetadaten().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AntwortTyp").isState()) {
								setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerAntworttyp
								.getZustand(daten.getScaledValue("AntwortTyp").getText()));
							} else {
							setAntwortTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbildverwaltungsmodell.attribute.AttBildVerwaltungsServerAntworttyp
							(daten.
								getUnscaledValue
							("AntwortTyp").
									byteValue
							()));
							}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setApplikationsID(getApplikationsID());
							klon.setAnfrageID(getAnfrageID());
							klon.setProgressObjektID(getProgressObjektID());
							klon.setKommandoTyp(getKommandoTyp());
						klon._bildUndMetadaten = getBildUndMetadaten().clone();
							klon.setAntwortTyp(getAntwortTyp());
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bildVerwaltungsServerKommando";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBildVerwaltungsServerKommando(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
