/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein Eintrag in einer Tabelle, der aus einem Wertebereich
					des
					Gefahrenpotenzials eine Empfehlung ableitet.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _gefahrenpotenzialMin
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _gefahrenpotenzialMax
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _empfehlung
			;
			@Defaultwert(wert = "0 Minuten")
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
			 _mindestStandzeitNachOben
			;
			@Defaultwert(wert = "10 Minuten")
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
			 _mindestStandzeitNachUnten
			;
			@Defaultwert(wert = "Nein")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _standzeitVerlaengerung
			;
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@return der Wert von GefahrenpotenzialMin.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 getGefahrenpotenzialMin() {
			return _gefahrenpotenzialMin;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@param _gefahrenpotenzialMin der neue Wert von GefahrenpotenzialMin.
		*/
		public void setGefahrenpotenzialMin(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
		 _gefahrenpotenzialMin) {
			this._gefahrenpotenzialMin = _gefahrenpotenzialMin;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@return der Wert von GefahrenpotenzialMax.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 getGefahrenpotenzialMax() {
			return _gefahrenpotenzialMax;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@param _gefahrenpotenzialMax der neue Wert von GefahrenpotenzialMax.
		*/
		public void setGefahrenpotenzialMax(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
		 _gefahrenpotenzialMax) {
			this._gefahrenpotenzialMax = _gefahrenpotenzialMax;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Empfehlung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getEmpfehlung() {
			return _empfehlung;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _empfehlung der neue Wert von Empfehlung.
		*/
		public void setEmpfehlung(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _empfehlung) {
			this._empfehlung = _empfehlung;
		}
	
		/**
		Angabe einer Zeitdauer in Minuten.
		<p>
		
		</p>
		
		@return der Wert von MindestStandzeitNachOben.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
			 getMindestStandzeitNachOben() {
			return _mindestStandzeitNachOben;
		}
	
		/**
		Angabe einer Zeitdauer in Minuten.
		<p>
		
		</p>
		
		@param _mindestStandzeitNachOben der neue Wert von MindestStandzeitNachOben.
		*/
		public void setMindestStandzeitNachOben(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
		 _mindestStandzeitNachOben) {
			this._mindestStandzeitNachOben = _mindestStandzeitNachOben;
		}
	
		/**
		Angabe einer Zeitdauer in Minuten.
		<p>
		
		</p>
		
		@return der Wert von MindestStandzeitNachUnten.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
			 getMindestStandzeitNachUnten() {
			return _mindestStandzeitNachUnten;
		}
	
		/**
		Angabe einer Zeitdauer in Minuten.
		<p>
		
		</p>
		
		@param _mindestStandzeitNachUnten der neue Wert von MindestStandzeitNachUnten.
		*/
		public void setMindestStandzeitNachUnten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
		 _mindestStandzeitNachUnten) {
			this._mindestStandzeitNachUnten = _mindestStandzeitNachUnten;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von StandzeitVerlaengerung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getStandzeitVerlaengerung() {
			return _standzeitVerlaengerung;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _standzeitVerlaengerung der neue Wert von StandzeitVerlaengerung.
		*/
		public void setStandzeitVerlaengerung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _standzeitVerlaengerung) {
			this._standzeitVerlaengerung = _standzeitVerlaengerung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getGefahrenpotenzialMin() != null) {
	                if (getGefahrenpotenzialMin().isZustand()) {
	                    datum.getUnscaledValue("GefahrenpotenzialMin").setText(getGefahrenpotenzialMin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GefahrenpotenzialMin").set(getGefahrenpotenzialMin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGefahrenpotenzialMax() != null) {
	                if (getGefahrenpotenzialMax().isZustand()) {
	                    datum.getUnscaledValue("GefahrenpotenzialMax").setText(getGefahrenpotenzialMax().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GefahrenpotenzialMax").set(getGefahrenpotenzialMax().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soEmpfehlung = getEmpfehlung();
					final SystemObject tmpEmpfehlung;
						if (soEmpfehlung instanceof SystemObject) {
							tmpEmpfehlung = (SystemObject)soEmpfehlung;
						} else if(soEmpfehlung instanceof SystemObjekt){
							tmpEmpfehlung = ((SystemObjekt)soEmpfehlung).getSystemObject();
						} else{
							tmpEmpfehlung = null;
						}
					datum.getReferenceValue("Empfehlung").setSystemObject(tmpEmpfehlung);
				// GanzzahlAttributTyp
				if (getMindestStandzeitNachOben() != null) {
	                if (getMindestStandzeitNachOben().isZustand()) {
	                    datum.getUnscaledValue("MindestStandzeitNachOben").setText(getMindestStandzeitNachOben().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MindestStandzeitNachOben").set(getMindestStandzeitNachOben().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMindestStandzeitNachUnten() != null) {
	                if (getMindestStandzeitNachUnten().isZustand()) {
	                    datum.getUnscaledValue("MindestStandzeitNachUnten").setText(getMindestStandzeitNachUnten().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MindestStandzeitNachUnten").set(getMindestStandzeitNachUnten().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStandzeitVerlaengerung() != null) {
	                if (getStandzeitVerlaengerung().isZustand()) {
	                    datum.getUnscaledValue("StandzeitVerlaengerung").setText(getStandzeitVerlaengerung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StandzeitVerlaengerung").set(getStandzeitVerlaengerung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GefahrenpotenzialMin").isState()) {
							setGefahrenpotenzialMin(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							.getZustand(daten.getScaledValue("GefahrenpotenzialMin").getText()));
						} else {
						setGefahrenpotenzialMin(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
						(daten.
							getUnscaledValue
						("GefahrenpotenzialMin").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GefahrenpotenzialMax").isState()) {
							setGefahrenpotenzialMax(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							.getZustand(daten.getScaledValue("GefahrenpotenzialMax").getText()));
						} else {
						setGefahrenpotenzialMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
						(daten.
							getUnscaledValue
						("GefahrenpotenzialMax").
								shortValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idEmpfehlung = daten.getReferenceValue("Empfehlung").getId();
					final SystemObjekt tmpEmpfehlung;
					if (idEmpfehlung == 0) {
						tmpEmpfehlung = null;
					} else {
						final SystemObject soEmpfehlung = factory.getDav().getDataModel().getObject(idEmpfehlung);
						if (soEmpfehlung == null) {
								tmpEmpfehlung = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idEmpfehlung);
						} else {
							tmpEmpfehlung = factory.getModellobjekt(soEmpfehlung);
						}
					}
					setEmpfehlung((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpEmpfehlung);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MindestStandzeitNachOben").isState()) {
							setMindestStandzeitNachOben(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
							.getZustand(daten.getScaledValue("MindestStandzeitNachOben").getText()));
						} else {
						setMindestStandzeitNachOben(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
						(daten.
							getUnscaledValue
						("MindestStandzeitNachOben").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MindestStandzeitNachUnten").isState()) {
							setMindestStandzeitNachUnten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
							.getZustand(daten.getScaledValue("MindestStandzeitNachUnten").getText()));
						} else {
						setMindestStandzeitNachUnten(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
						(daten.
							getUnscaledValue
						("MindestStandzeitNachUnten").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StandzeitVerlaengerung").isState()) {
							setStandzeitVerlaengerung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("StandzeitVerlaengerung").getText()));
						} else {
						setStandzeitVerlaengerung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("StandzeitVerlaengerung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung clone() {
		AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung klon = new AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung();
		
						klon.setGefahrenpotenzialMin(getGefahrenpotenzialMin());
						klon.setGefahrenpotenzialMax(getGefahrenpotenzialMax());
						klon.setEmpfehlung(getEmpfehlung());
						klon.setMindestStandzeitNachOben(getMindestStandzeitNachOben());
						klon.setMindestStandzeitNachUnten(getMindestStandzeitNachUnten());
						klon.setStandzeitVerlaengerung(getStandzeitVerlaengerung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
