/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein Eintrag in einer Tabelle, der aus einem aktuell
					anliegenden
					Schaltprogramm eine Tabelle
					GefahrenPotenzialband-&gt;Empfehlung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlVbaEventEintragZustandGefahrenpotenzialListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			> _aktuellesSchaltprogramm = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung
			> _gefahrenpotenzialListe = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung
			>(0, true);
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von AktuellesSchaltprogramm.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			> getAktuellesSchaltprogramm() {
			return _aktuellesSchaltprogramm;
		}
	
	
		/**
		Ein Eintrag in einer Tabelle, der aus einem Wertebereich
							des
							Gefahrenpotenzials eine Empfehlung ableitet.
		<p>
		
		</p>
		
		@return der Wert von GefahrenpotenzialListe.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung
			> getGefahrenpotenzialListe() {
			return _gefahrenpotenzialListe;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAktuellesSchaltprogramm = datum.getReferenceArray("AktuellesSchaltprogramm");
					arrayAktuellesSchaltprogramm.setLength(getAktuellesSchaltprogramm().size());
					for (int i = 0; i < arrayAktuellesSchaltprogramm.getLength(); ++i) {
						final Object soAktuellesSchaltprogramm = getAktuellesSchaltprogramm().get(i);
						final SystemObject tmpAktuellesSchaltprogramm;
						if (soAktuellesSchaltprogramm instanceof SystemObject) {
							tmpAktuellesSchaltprogramm = (SystemObject)soAktuellesSchaltprogramm;
						} else if(soAktuellesSchaltprogramm instanceof SystemObjekt){
							tmpAktuellesSchaltprogramm = ((SystemObjekt)soAktuellesSchaltprogramm).getSystemObject();
						} else{
							tmpAktuellesSchaltprogramm = null;
						}
						arrayAktuellesSchaltprogramm.getReferenceValue(i).setSystemObject(tmpAktuellesSchaltprogramm);
					}
				// AttributListenDefinition
					final Data.Array arrayGefahrenpotenzialListe = datum.getArray("GefahrenpotenzialListe");
					arrayGefahrenpotenzialListe.setLength(getGefahrenpotenzialListe().size());
					for (int i = 0; i < arrayGefahrenpotenzialListe.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung
						 atl = getGefahrenpotenzialListe().get(i);
						atl.bean2Atl(arrayGefahrenpotenzialListe.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAktuellesSchaltprogramm = daten.getReferenceArray("AktuellesSchaltprogramm");
					for (int i = 0; i < arrayAktuellesSchaltprogramm.getLength(); ++i) {
						final long idAktuellesSchaltprogramm = daten.getReferenceArray("AktuellesSchaltprogramm").getReferenceValue(i).getId();
						final SystemObjekt tmpAktuellesSchaltprogramm;
						if (idAktuellesSchaltprogramm == 0) {
							tmpAktuellesSchaltprogramm = null;
						} else {
							final SystemObject soAktuellesSchaltprogramm = factory.getDav().getDataModel().getObject(idAktuellesSchaltprogramm);
							if (soAktuellesSchaltprogramm == null) {
									tmpAktuellesSchaltprogramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idAktuellesSchaltprogramm);
							} else {
								tmpAktuellesSchaltprogramm = factory.getModellobjekt(soAktuellesSchaltprogramm);
							}
						}
							getAktuellesSchaltprogramm().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
							) tmpAktuellesSchaltprogramm);
					}
				// AttributListenDefinition
					final Data.Array arrayGefahrenpotenzialListe = daten.getArray("GefahrenpotenzialListe");
					for (int i = 0; i < arrayGefahrenpotenzialListe.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragGefahrenpotenzialBandEmpfehlung
						 ();
						atl.atl2Bean(arrayGefahrenpotenzialListe.getItem(i), factory);
						getGefahrenpotenzialListe().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaEventEintragZustandGefahrenpotenzialListe clone() {
		AtlVbaEventEintragZustandGefahrenpotenzialListe klon = new AtlVbaEventEintragZustandGefahrenpotenzialListe();
		
					klon._aktuellesSchaltprogramm = getAktuellesSchaltprogramm().clone();
					klon._gefahrenpotenzialListe = getGefahrenpotenzialListe().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
