/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Die Beschreibung enthält den oberen Grenzwert des
					Gefahrenpotenzials für den eine Klassendefinition gültig ist.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlVbaEventKlassenEintrag implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _bisPotenzial
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _farbe
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@return der Wert von BisPotenzial.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 getBisPotenzial() {
			return _bisPotenzial;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@param _bisPotenzial der neue Wert von BisPotenzial.
		*/
		public void setBisPotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
		 _bisPotenzial) {
			this._bisPotenzial = _bisPotenzial;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von Farbe.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getFarbe() {
			return _farbe;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _farbe der neue Wert von Farbe.
		*/
		public void setFarbe(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _farbe) {
			this._farbe = _farbe;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// GanzzahlAttributTyp
				if (getBisPotenzial() != null) {
	                if (getBisPotenzial().isZustand()) {
	                    datum.getUnscaledValue("BisPotenzial").setText(getBisPotenzial().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("BisPotenzial").set(getBisPotenzial().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFarbe() != null) {
	                if (getFarbe().isZustand()) {
	                    datum.getUnscaledValue("Farbe").setText(getFarbe().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Farbe").set(getFarbe().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("BisPotenzial").isState()) {
							setBisPotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							.getZustand(daten.getScaledValue("BisPotenzial").getText()));
						} else {
						setBisPotenzial(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
						(daten.
							getUnscaledValue
						("BisPotenzial").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						setFarbe(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Farbe").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaEventKlassenEintrag clone() {
		AtlVbaEventKlassenEintrag klon = new AtlVbaEventKlassenEintrag();
		
						klon.setName(getName());
						klon.setBisPotenzial(getBisPotenzial());
						klon.setFarbe(getFarbe());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
