/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition eines Sektors.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlVbaEventUfdWindSektorBewertung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttWinkel
			 _bisWinkel
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorEintrag
			> _potenziale = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorEintrag
			>(0, true);
	
		/**
		Ein Winkel zwischen 0 bis 360° und einer Nachkommastelle.
		<p>
		
		</p>
		
		@return der Wert von BisWinkel.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttWinkel
			 getBisWinkel() {
			return _bisWinkel;
		}
	
		/**
		Ein Winkel zwischen 0 bis 360° und einer Nachkommastelle.
		<p>
		
		</p>
		
		@param _bisWinkel der neue Wert von BisWinkel.
		*/
		public void setBisWinkel(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttWinkel
		 _bisWinkel) {
			this._bisWinkel = _bisWinkel;
		}
	
		/**
		Eintrag in der Zuordnungsmatrix für die Bewertung der
							Windgeschwindigkeit in Sektoren.
		<p>
		
		</p>
		
		@return der Wert von Potenziale.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorEintrag
			> getPotenziale() {
			return _potenziale;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getBisWinkel() != null) {
	                if (getBisWinkel().isZustand()) {
	                    datum.getUnscaledValue("BisWinkel").setText(getBisWinkel().toString());
	                } else {
						datum.
						getScaledValue
	                	("BisWinkel").set(getBisWinkel().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayPotenziale = datum.getArray("Potenziale");
					arrayPotenziale.setLength(getPotenziale().size());
					for (int i = 0; i < arrayPotenziale.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorEintrag
						 atl = getPotenziale().get(i);
						atl.bean2Atl(arrayPotenziale.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setBisWinkel(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttWinkel
						(daten.
							getScaledValue
						("BisWinkel").
							doubleValue
						()));
				// AttributListenDefinition
					final Data.Array arrayPotenziale = daten.getArray("Potenziale");
					for (int i = 0; i < arrayPotenziale.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorEintrag
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorEintrag
						 ();
						atl.atl2Bean(arrayPotenziale.getItem(i), factory);
						getPotenziale().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaEventUfdWindSektorBewertung clone() {
		AtlVbaEventUfdWindSektorBewertung klon = new AtlVbaEventUfdWindSektorBewertung();
		
						klon.setBisWinkel(getBisWinkel());
					klon._potenziale = getPotenziale().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
