/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt einen Tabelleneintrag, der einem Schaltprogramm
					ein Wiedervorlage-Datum zuweist.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlWiederVorlageEintrag implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _programm
			;
			private 	Zeitstempel
			 _wiedervorlage
			;
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Programm.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getProgramm() {
			return _programm;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _programm der neue Wert von Programm.
		*/
		public void setProgramm(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _programm) {
			this._programm = _programm;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Wiedervorlage.
		*/
			public 	Zeitstempel
			 getWiedervorlage() {
			return _wiedervorlage;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _wiedervorlage der neue Wert von Wiedervorlage.
		*/
		public void setWiedervorlage(	Zeitstempel
		 _wiedervorlage) {
			this._wiedervorlage = _wiedervorlage;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soProgramm = getProgramm();
					final SystemObject tmpProgramm;
						if (soProgramm instanceof SystemObject) {
							tmpProgramm = (SystemObject)soProgramm;
						} else if(soProgramm instanceof SystemObjekt){
							tmpProgramm = ((SystemObjekt)soProgramm).getSystemObject();
						} else{
							tmpProgramm = null;
						}
					datum.getReferenceValue("Programm").setSystemObject(tmpProgramm);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Wiedervorlage").setMillis(getWiedervorlage().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idProgramm = daten.getReferenceValue("Programm").getId();
					final SystemObjekt tmpProgramm;
					if (idProgramm == 0) {
						tmpProgramm = null;
					} else {
						final SystemObject soProgramm = factory.getDav().getDataModel().getObject(idProgramm);
						if (soProgramm == null) {
								tmpProgramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idProgramm);
						} else {
							tmpProgramm = factory.getModellobjekt(soProgramm);
						}
					}
					setProgramm((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpProgramm);
				// ZeitstempelAttributTyp
					setWiedervorlage(new
						Zeitstempel
						(daten.getTimeValue("Wiedervorlage").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlWiederVorlageEintrag clone() {
		AtlWiederVorlageEintrag klon = new AtlWiederVorlageEintrag();
		
						klon.setProgramm(getProgramm());
						klon.setWiedervorlage(getWiedervorlage());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
