/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kennzeichnet Parameter des Events.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class PdVbaEventParameter extends AbstractParameterDatensatz<PdVbaEventParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _inhibiert
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
				 _gefahrenpotenzial
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _sicherheitsgrad
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventAutoResetTyp
				 _autoResetTyp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventZeitkonstante
				 _zeitkonstante
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 _defaultEmpfehlung
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragZustandGefahrenpotenzialListe
				> _empfehlungsTabelle = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragZustandGefahrenpotenzialListe
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Inhibiert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getInhibiert() {
				return _inhibiert;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _inhibiert der neue Wert von Inhibiert.
			*/
			public void setInhibiert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _inhibiert) {
				this._inhibiert = _inhibiert;
			}
		
			/**
			Beschreibt ein Gefahrenpotential durch
								ein Ereignis vom Typ
								typ.vbaEvent wie z.B. "Stehen gebliebenes
								Fahrzeug" oder "Wind von
								NO".
			<p>
			
			</p>
			
			@return der Wert von Gefahrenpotenzial.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
				 getGefahrenpotenzial() {
				return _gefahrenpotenzial;
			}
		
			/**
			Beschreibt ein Gefahrenpotential durch
								ein Ereignis vom Typ
								typ.vbaEvent wie z.B. "Stehen gebliebenes
								Fahrzeug" oder "Wind von
								NO".
			<p>
			
			</p>
			
			@param _gefahrenpotenzial der neue Wert von Gefahrenpotenzial.
			*/
			public void setGefahrenpotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _gefahrenpotenzial) {
				this._gefahrenpotenzial = _gefahrenpotenzial;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@return der Wert von Sicherheitsgrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getSicherheitsgrad() {
				return _sicherheitsgrad;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@param _sicherheitsgrad der neue Wert von Sicherheitsgrad.
			*/
			public void setSicherheitsgrad(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _sicherheitsgrad) {
				this._sicherheitsgrad = _sicherheitsgrad;
			}
		
			/**
			Beschreibt die Art, wann ein Ereignis ohne
								Zutun des
								Bedieners zurück gesetzt werden kann, wenn das
								verursachende
								VBA-Event inaktiv wird.
			<p>
			
			</p>
			
			@return der Wert von AutoResetTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventAutoResetTyp
				 getAutoResetTyp() {
				return _autoResetTyp;
			}
		
			/**
			Beschreibt die Art, wann ein Ereignis ohne
								Zutun des
								Bedieners zurück gesetzt werden kann, wenn das
								verursachende
								VBA-Event inaktiv wird.
			<p>
			
			</p>
			
			@param _autoResetTyp der neue Wert von AutoResetTyp.
			*/
			public void setAutoResetTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventAutoResetTyp
			 _autoResetTyp) {
				this._autoResetTyp = _autoResetTyp;
			}
		
			/**
			Angabe einer Zeitkonstanten in Sekunden.
			<p>
			Auf Zehntelsekunden genau. Mit dieser Zeitkonstanten
								wird das Ereignis
								unwichtiger, und zwar nach der ganz normalen
								e-Funktion z.B. einer
								Kondensatorentladung. D.h., nach der
								fünffachen Zeit ist das
								Ereignis
								praktisch verschwunden.
			</p>
			
			@return der Wert von Zeitkonstante.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventZeitkonstante
				 getZeitkonstante() {
				return _zeitkonstante;
			}
		
			/**
			Angabe einer Zeitkonstanten in Sekunden.
			<p>
			Auf Zehntelsekunden genau. Mit dieser Zeitkonstanten
								wird das Ereignis
								unwichtiger, und zwar nach der ganz normalen
								e-Funktion z.B. einer
								Kondensatorentladung. D.h., nach der
								fünffachen Zeit ist das
								Ereignis
								praktisch verschwunden.
			</p>
			
			@param _zeitkonstante der neue Wert von Zeitkonstante.
			*/
			public void setZeitkonstante(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventZeitkonstante
			 _zeitkonstante) {
				this._zeitkonstante = _zeitkonstante;
			}
		
			/**
			Info.
			<p>
			
			</p>
			
			@return der Wert von DefaultEmpfehlung.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 getDefaultEmpfehlung() {
				return _defaultEmpfehlung;
			}
		
			/**
			Info.
			<p>
			
			</p>
			
			@param _defaultEmpfehlung der neue Wert von DefaultEmpfehlung.
			*/
			public void setDefaultEmpfehlung(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _defaultEmpfehlung) {
				this._defaultEmpfehlung = _defaultEmpfehlung;
			}
		
			/**
			Ein Eintrag in einer Tabelle, der aus einem aktuell
								anliegenden
								Schaltprogramm eine Tabelle
								GefahrenPotenzialband-&gt;Empfehlung.
			<p>
			
			</p>
			
			@return der Wert von EmpfehlungsTabelle.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragZustandGefahrenpotenzialListe
				> getEmpfehlungsTabelle() {
				return _empfehlungsTabelle;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getInhibiert() != null) {
		                if (getInhibiert().isZustand()) {
		                    datum.getUnscaledValue("Inhibiert").setText(getInhibiert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Inhibiert").set(getInhibiert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGefahrenpotenzial() != null) {
		                if (getGefahrenpotenzial().isZustand()) {
		                    datum.getUnscaledValue("Gefahrenpotenzial").setText(getGefahrenpotenzial().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Gefahrenpotenzial").set(getGefahrenpotenzial().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSicherheitsgrad() != null) {
		                if (getSicherheitsgrad().isZustand()) {
		                    datum.getUnscaledValue("Sicherheitsgrad").setText(getSicherheitsgrad().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Sicherheitsgrad").set(getSicherheitsgrad().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAutoResetTyp() != null) {
		                if (getAutoResetTyp().isZustand()) {
		                    datum.getUnscaledValue("AutoResetTyp").setText(getAutoResetTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AutoResetTyp").set(getAutoResetTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZeitkonstante() != null) {
		                if (getZeitkonstante().isZustand()) {
		                    datum.getUnscaledValue("Zeitkonstante").setText(getZeitkonstante().toString());
		                } else {
							datum.
							getScaledValue
		                	("Zeitkonstante").set(getZeitkonstante().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soDefaultEmpfehlung = getDefaultEmpfehlung();
						final SystemObject tmpDefaultEmpfehlung;
							if (soDefaultEmpfehlung instanceof SystemObject) {
								tmpDefaultEmpfehlung = (SystemObject)soDefaultEmpfehlung;
							} else if(soDefaultEmpfehlung instanceof SystemObjekt){
								tmpDefaultEmpfehlung = ((SystemObjekt)soDefaultEmpfehlung).getSystemObject();
							} else{
								tmpDefaultEmpfehlung = null;
							}
						datum.getReferenceValue("DefaultEmpfehlung").setSystemObject(tmpDefaultEmpfehlung);
					// AttributListenDefinition
						final Data.Array arrayEmpfehlungsTabelle = datum.getArray("EmpfehlungsTabelle");
						arrayEmpfehlungsTabelle.setLength(getEmpfehlungsTabelle().size());
						for (int i = 0; i < arrayEmpfehlungsTabelle.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragZustandGefahrenpotenzialListe
							 atl = getEmpfehlungsTabelle().get(i);
							atl.bean2Atl(arrayEmpfehlungsTabelle.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Inhibiert").isState()) {
								setInhibiert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Inhibiert").getText()));
							} else {
							setInhibiert(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Inhibiert").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Gefahrenpotenzial").isState()) {
								setGefahrenpotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
								.getZustand(daten.getScaledValue("Gefahrenpotenzial").getText()));
							} else {
							setGefahrenpotenzial(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							(daten.
								getUnscaledValue
							("Gefahrenpotenzial").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Sicherheitsgrad").isState()) {
								setSicherheitsgrad(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("Sicherheitsgrad").getText()));
							} else {
							setSicherheitsgrad(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("Sicherheitsgrad").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AutoResetTyp").isState()) {
								setAutoResetTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventAutoResetTyp
								.getZustand(daten.getScaledValue("AutoResetTyp").getText()));
							} else {
							setAutoResetTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventAutoResetTyp
							(daten.
								getUnscaledValue
							("AutoResetTyp").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setZeitkonstante(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVbaEventZeitkonstante
							(daten.
								getScaledValue
							("Zeitkonstante").
								doubleValue
							()));
					// ObjektReferenzAttributTyp
						final long idDefaultEmpfehlung = daten.getReferenceValue("DefaultEmpfehlung").getId();
						final SystemObjekt tmpDefaultEmpfehlung;
						if (idDefaultEmpfehlung == 0) {
							tmpDefaultEmpfehlung = null;
						} else {
							final SystemObject soDefaultEmpfehlung = factory.getDav().getDataModel().getObject(idDefaultEmpfehlung);
							if (soDefaultEmpfehlung == null) {
									tmpDefaultEmpfehlung = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idDefaultEmpfehlung);
							} else {
								tmpDefaultEmpfehlung = factory.getModellobjekt(soDefaultEmpfehlung);
							}
						}
						setDefaultEmpfehlung((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
						) tmpDefaultEmpfehlung);
					// AttributListenDefinition
						final Data.Array arrayEmpfehlungsTabelle = daten.getArray("EmpfehlungsTabelle");
						for (int i = 0; i < arrayEmpfehlungsTabelle.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragZustandGefahrenpotenzialListe
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventEintragZustandGefahrenpotenzialListe
							 ();
							atl.atl2Bean(arrayEmpfehlungsTabelle.getItem(i), factory);
							getEmpfehlungsTabelle().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setInhibiert(getInhibiert());
							klon.setGefahrenpotenzial(getGefahrenpotenzial());
							klon.setSicherheitsgrad(getSicherheitsgrad());
							klon.setAutoResetTyp(getAutoResetTyp());
							klon.setZeitkonstante(getZeitkonstante());
							klon.setDefaultEmpfehlung(getDefaultEmpfehlung());
						klon._empfehlungsTabelle = getEmpfehlungsTabelle().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.vbaEventParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVbaEventParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
