/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlprogrammscheduler.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenstruktur, die einen Eintrag in der Liste der
					zeitgesteuerten Verkehrsprogramme des Programm
					Schedulers beschreibt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlScheduledProgramme implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _startzeitpunkt
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _startprogramm
			;
			private 	Zeitstempel
			 _endzeitpunkt
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _endprogramm
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlprogrammscheduler.attribute.AttBcScheduledProgrammZustand
			 _zustand
			;
			private String
			 _verursacher
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _zyklisch
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _wochentage
			;
	
		/**
		Angabe eines Zeitpunktes.
		<p>
		
		</p>
		
		@return der Wert von Startzeitpunkt.
		*/
			public 	Zeitstempel
			 getStartzeitpunkt() {
			return _startzeitpunkt;
		}
	
		/**
		Angabe eines Zeitpunktes.
		<p>
		
		</p>
		
		@param _startzeitpunkt der neue Wert von Startzeitpunkt.
		*/
		public void setStartzeitpunkt(	Zeitstempel
		 _startzeitpunkt) {
			this._startzeitpunkt = _startzeitpunkt;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Startprogramm.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getStartprogramm() {
			return _startprogramm;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _startprogramm der neue Wert von Startprogramm.
		*/
		public void setStartprogramm(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _startprogramm) {
			this._startprogramm = _startprogramm;
		}
	
		/**
		Angabe eines Zeitpunktes.
		<p>
		
		</p>
		
		@return der Wert von Endzeitpunkt.
		*/
			public 	Zeitstempel
			 getEndzeitpunkt() {
			return _endzeitpunkt;
		}
	
		/**
		Angabe eines Zeitpunktes.
		<p>
		
		</p>
		
		@param _endzeitpunkt der neue Wert von Endzeitpunkt.
		*/
		public void setEndzeitpunkt(	Zeitstempel
		 _endzeitpunkt) {
			this._endzeitpunkt = _endzeitpunkt;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Endprogramm.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getEndprogramm() {
			return _endprogramm;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _endprogramm der neue Wert von Endprogramm.
		*/
		public void setEndprogramm(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _endprogramm) {
			this._endprogramm = _endprogramm;
		}
	
		/**
		Beschreibt den Zustand eines Programmes aus der Liste des Programmschedulers.
		<p>
		
		</p>
		
		@return der Wert von Zustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlprogrammscheduler.attribute.AttBcScheduledProgrammZustand
			 getZustand() {
			return _zustand;
		}
	
		/**
		Beschreibt den Zustand eines Programmes aus der Liste des Programmschedulers.
		<p>
		
		</p>
		
		@param _zustand der neue Wert von Zustand.
		*/
		public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlprogrammscheduler.attribute.AttBcScheduledProgrammZustand
		 _zustand) {
			this._zustand = _zustand;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Verursacher.
		*/
			public String
			 getVerursacher() {
			return _verursacher;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _verursacher der neue Wert von Verursacher.
		*/
		public void setVerursacher(String
		 _verursacher) {
			if (_verursacher.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._verursacher = _verursacher;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Zyklisch.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getZyklisch() {
			return _zyklisch;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _zyklisch der neue Wert von Zyklisch.
		*/
		public void setZyklisch(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _zyklisch) {
			this._zyklisch = _zyklisch;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von Wochentage.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getWochentage() {
			return _wochentage;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _wochentage der neue Wert von Wochentage.
		*/
		public void setWochentage(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _wochentage) {
			this._wochentage = _wochentage;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Startzeitpunkt").setMillis(getStartzeitpunkt().getTime());
				// ObjektReferenzAttributTyp
					final Object soStartprogramm = getStartprogramm();
					final SystemObject tmpStartprogramm;
						if (soStartprogramm instanceof SystemObject) {
							tmpStartprogramm = (SystemObject)soStartprogramm;
						} else if(soStartprogramm instanceof SystemObjekt){
							tmpStartprogramm = ((SystemObjekt)soStartprogramm).getSystemObject();
						} else{
							tmpStartprogramm = null;
						}
					datum.getReferenceValue("Startprogramm").setSystemObject(tmpStartprogramm);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Endzeitpunkt").setMillis(getEndzeitpunkt().getTime());
				// ObjektReferenzAttributTyp
					final Object soEndprogramm = getEndprogramm();
					final SystemObject tmpEndprogramm;
						if (soEndprogramm instanceof SystemObject) {
							tmpEndprogramm = (SystemObject)soEndprogramm;
						} else if(soEndprogramm instanceof SystemObjekt){
							tmpEndprogramm = ((SystemObjekt)soEndprogramm).getSystemObject();
						} else{
							tmpEndprogramm = null;
						}
					datum.getReferenceValue("Endprogramm").setSystemObject(tmpEndprogramm);
				// GanzzahlAttributTyp
				if (getZustand() != null) {
	                if (getZustand().isZustand()) {
	                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zustand").set(getZustand().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getVerursacher() != null) {
					datum.getTextValue("Verursacher").setText(getVerursacher());
				}
				// GanzzahlAttributTyp
				if (getZyklisch() != null) {
	                if (getZyklisch().isZustand()) {
	                    datum.getUnscaledValue("Zyklisch").setText(getZyklisch().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zyklisch").set(getZyklisch().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getWochentage() != null) {
	                if (getWochentage().isZustand()) {
	                    datum.getUnscaledValue("Wochentage").setText(getWochentage().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Wochentage").set(getWochentage().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setStartzeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Startzeitpunkt").getMillis()));
				// ObjektReferenzAttributTyp
					final long idStartprogramm = daten.getReferenceValue("Startprogramm").getId();
					final SystemObjekt tmpStartprogramm;
					if (idStartprogramm == 0) {
						tmpStartprogramm = null;
					} else {
						final SystemObject soStartprogramm = factory.getDav().getDataModel().getObject(idStartprogramm);
						if (soStartprogramm == null) {
								tmpStartprogramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idStartprogramm);
						} else {
							tmpStartprogramm = factory.getModellobjekt(soStartprogramm);
						}
					}
					setStartprogramm((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpStartprogramm);
				// ZeitstempelAttributTyp
					setEndzeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Endzeitpunkt").getMillis()));
				// ObjektReferenzAttributTyp
					final long idEndprogramm = daten.getReferenceValue("Endprogramm").getId();
					final SystemObjekt tmpEndprogramm;
					if (idEndprogramm == 0) {
						tmpEndprogramm = null;
					} else {
						final SystemObject soEndprogramm = factory.getDav().getDataModel().getObject(idEndprogramm);
						if (soEndprogramm == null) {
								tmpEndprogramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idEndprogramm);
						} else {
							tmpEndprogramm = factory.getModellobjekt(soEndprogramm);
						}
					}
					setEndprogramm((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpEndprogramm);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zustand").isState()) {
							setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlprogrammscheduler.attribute.AttBcScheduledProgrammZustand
							.getZustand(daten.getScaledValue("Zustand").getText()));
						} else {
						setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlprogrammscheduler.attribute.AttBcScheduledProgrammZustand
						(daten.
							getUnscaledValue
						("Zustand").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					setVerursacher(daten.getTextValue("Verursacher").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zyklisch").isState()) {
							setZyklisch(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Zyklisch").getText()));
						} else {
						setZyklisch(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Zyklisch").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setWochentage(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Wochentage").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlScheduledProgramme clone() {
		AtlScheduledProgramme klon = new AtlScheduledProgramme();
		
						klon.setStartzeitpunkt(getStartzeitpunkt());
						klon.setStartprogramm(getStartprogramm());
						klon.setEndzeitpunkt(getEndzeitpunkt());
						klon.setEndprogramm(getEndprogramm());
						klon.setZustand(getZustand());
						klon.setVerursacher(getVerursacher());
						klon.setZyklisch(getZyklisch());
						klon.setWochentage(getWochentage());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
