/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAnzeigenSchaltProgramm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			> _anzeige = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			> _quellprogramm = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
			 _eigenschaft
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
			()
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.anzeige.
		<p>
		
		</p>
		
		@return der Wert von Anzeige.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			> getAnzeige() {
			return _anzeige;
		}
	
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Quellprogramm.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			> getQuellprogramm() {
			return _quellprogramm;
		}
	
	
		/**
		Eigenschaften der Objekte des Typs.
		<p>
		
		</p>
		
		@return der Wert von Eigenschaft.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
			 getEigenschaft() {
			return _eigenschaft;
		}
	
		/**
		Eigenschaften der Objekte des Typs.
		<p>
		
		</p>
		
		@param _eigenschaft der neue Wert von Eigenschaft.
		*/
		public void setEigenschaft(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlAnzeigeEigenschaft
		 _eigenschaft) {
			this._eigenschaft = _eigenschaft;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAnzeige = datum.getReferenceArray("Anzeige");
					arrayAnzeige.setLength(getAnzeige().size());
					for (int i = 0; i < arrayAnzeige.getLength(); ++i) {
						final Object soAnzeige = getAnzeige().get(i);
						final SystemObject tmpAnzeige;
						if (soAnzeige instanceof SystemObject) {
							tmpAnzeige = (SystemObject)soAnzeige;
						} else if(soAnzeige instanceof SystemObjekt){
							tmpAnzeige = ((SystemObjekt)soAnzeige).getSystemObject();
						} else{
							tmpAnzeige = null;
						}
						arrayAnzeige.getReferenceValue(i).setSystemObject(tmpAnzeige);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayQuellprogramm = datum.getReferenceArray("Quellprogramm");
					arrayQuellprogramm.setLength(getQuellprogramm().size());
					for (int i = 0; i < arrayQuellprogramm.getLength(); ++i) {
						final Object soQuellprogramm = getQuellprogramm().get(i);
						final SystemObject tmpQuellprogramm;
						if (soQuellprogramm instanceof SystemObject) {
							tmpQuellprogramm = (SystemObject)soQuellprogramm;
						} else if(soQuellprogramm instanceof SystemObjekt){
							tmpQuellprogramm = ((SystemObjekt)soQuellprogramm).getSystemObject();
						} else{
							tmpQuellprogramm = null;
						}
						arrayQuellprogramm.getReferenceValue(i).setSystemObject(tmpQuellprogramm);
					}
				// AttributListenDefinition
					getEigenschaft().bean2Atl(datum.getItem("Eigenschaft"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAnzeige = daten.getReferenceArray("Anzeige");
					for (int i = 0; i < arrayAnzeige.getLength(); ++i) {
						final long idAnzeige = daten.getReferenceArray("Anzeige").getReferenceValue(i).getId();
						final SystemObjekt tmpAnzeige;
						if (idAnzeige == 0) {
							tmpAnzeige = null;
						} else {
							final SystemObject soAnzeige = factory.getDav().getDataModel().getObject(idAnzeige);
							if (soAnzeige == null) {
									tmpAnzeige = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeige);
							} else {
								tmpAnzeige = factory.getModellobjekt(soAnzeige);
							}
						}
							getAnzeige().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
							) tmpAnzeige);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayQuellprogramm = daten.getReferenceArray("Quellprogramm");
					for (int i = 0; i < arrayQuellprogramm.getLength(); ++i) {
						final long idQuellprogramm = daten.getReferenceArray("Quellprogramm").getReferenceValue(i).getId();
						final SystemObjekt tmpQuellprogramm;
						if (idQuellprogramm == 0) {
							tmpQuellprogramm = null;
						} else {
							final SystemObject soQuellprogramm = factory.getDav().getDataModel().getObject(idQuellprogramm);
							if (soQuellprogramm == null) {
									tmpQuellprogramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idQuellprogramm);
							} else {
								tmpQuellprogramm = factory.getModellobjekt(soQuellprogramm);
							}
						}
							getQuellprogramm().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
							) tmpQuellprogramm);
					}
				// AttributListenDefinition
					getEigenschaft().atl2Bean(daten.getItem("Eigenschaft"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAnzeigenSchaltProgramm clone() {
		AtlAnzeigenSchaltProgramm klon = new AtlAnzeigenSchaltProgramm();
		
					klon._anzeige = getAnzeige().clone();
					klon._quellprogramm = getQuellprogramm().clone();
						klon._eigenschaft = getEigenschaft().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
