/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt alle Fehler, die eine Anzeige haben
					kann und die potentiell
					dazu führen, dass sie für bestimmte
					Stellbefehle ignoriert wird.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSelektivesIgnorierenFehlerBeschreibung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _dEFehler
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNegativeQuittung
			> _negativeQuittungen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNegativeQuittung
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _timeout
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _programmFehler
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _nichtDarstellbareWvz
			;
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von DEFehler.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getDEFehler() {
			return _dEFehler;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _dEFehler der neue Wert von DEFehler.
		*/
		public void setDEFehler(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _dEFehler) {
			this._dEFehler = _dEFehler;
		}
	
		/**
		Anwort auf eine nicht auswertbares Telegramm.
		<p>
		
		</p>
		
		@return der Wert von NegativeQuittungen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNegativeQuittung
			> getNegativeQuittungen() {
			return _negativeQuittungen;
		}
	
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Timeout.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getTimeout() {
			return _timeout;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _timeout der neue Wert von Timeout.
		*/
		public void setTimeout(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _timeout) {
			this._timeout = _timeout;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von ProgrammFehler.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getProgrammFehler() {
			return _programmFehler;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _programmFehler der neue Wert von ProgrammFehler.
		*/
		public void setProgrammFehler(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _programmFehler) {
			this._programmFehler = _programmFehler;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von NichtDarstellbareWvz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNichtDarstellbareWvz() {
			return _nichtDarstellbareWvz;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _nichtDarstellbareWvz der neue Wert von NichtDarstellbareWvz.
		*/
		public void setNichtDarstellbareWvz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _nichtDarstellbareWvz) {
			this._nichtDarstellbareWvz = _nichtDarstellbareWvz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getDEFehler() != null) {
	                if (getDEFehler().isZustand()) {
	                    datum.getUnscaledValue("DEFehler").setText(getDEFehler().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("DEFehler").set(getDEFehler().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getNegativeQuittungen() != null) {
					final Data.NumberArray arrayNegativeQuittungen = datum.
						getUnscaledArray
						("NegativeQuittungen");
					arrayNegativeQuittungen.setLength(getNegativeQuittungen().size());
					for (int i = 0; i < arrayNegativeQuittungen.getLength(); ++i) {
						arrayNegativeQuittungen.getValue(i).set(getNegativeQuittungen().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getTimeout() != null) {
	                if (getTimeout().isZustand()) {
	                    datum.getUnscaledValue("Timeout").setText(getTimeout().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Timeout").set(getTimeout().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getProgrammFehler() != null) {
	                if (getProgrammFehler().isZustand()) {
	                    datum.getUnscaledValue("ProgrammFehler").setText(getProgrammFehler().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ProgrammFehler").set(getProgrammFehler().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getNichtDarstellbareWvz() != null) {
	                if (getNichtDarstellbareWvz().isZustand()) {
	                    datum.getUnscaledValue("NichtDarstellbareWvz").setText(getNichtDarstellbareWvz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NichtDarstellbareWvz").set(getNichtDarstellbareWvz().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("DEFehler").isState()) {
							setDEFehler(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("DEFehler").getText()));
						} else {
						setDEFehler(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("DEFehler").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
					final Data.NumberArray arrayNegativeQuittungen = daten.
						getUnscaledArray
					("NegativeQuittungen");
	
					for (int i = 0; i < arrayNegativeQuittungen.getLength(); ++i) {
	                    if (arrayNegativeQuittungen.getValue(i).isState()) {
	                        getNegativeQuittungen().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNegativeQuittung
	                        .getZustand(arrayNegativeQuittungen.getValue(i).getState().getName()));
	                    } else {
	                    getNegativeQuittungen().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNegativeQuittung
	                    (arrayNegativeQuittungen.
	                    		shortValue
	                    (i)));
	                    }
	                }
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Timeout").isState()) {
							setTimeout(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Timeout").getText()));
						} else {
						setTimeout(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Timeout").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ProgrammFehler").isState()) {
							setProgrammFehler(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("ProgrammFehler").getText()));
						} else {
						setProgrammFehler(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("ProgrammFehler").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NichtDarstellbareWvz").isState()) {
							setNichtDarstellbareWvz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("NichtDarstellbareWvz").getText()));
						} else {
						setNichtDarstellbareWvz(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("NichtDarstellbareWvz").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSelektivesIgnorierenFehlerBeschreibung clone() {
		AtlSelektivesIgnorierenFehlerBeschreibung klon = new AtlSelektivesIgnorierenFehlerBeschreibung();
		
						klon.setDEFehler(getDEFehler());
					klon._negativeQuittungen = getNegativeQuittungen().clone();
						klon.setTimeout(getTimeout());
						klon.setProgrammFehler(getProgrammFehler());
						klon.setNichtDarstellbareWvz(getNichtDarstellbareWvz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
