/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Tabelleneintrag, der einer Liste von
					Schaltprogrammgruppen eine
					Liste von Anzeigetypen zurodnet, die in
					keiner dieser
					Schaltprogrammgruppen
					versorgt werden dürfen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlVbaVerboteneAnzeigen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
			> _schaltprogrammgruppen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp
			> _verboteneAnzeigen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp
			>(0, true);
	
		/**
		Verweis auf ein Objekt vom Typ SchaltProgrammGruppe.
		<p>
		
		</p>
		
		@return der Wert von Schaltprogrammgruppen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
			> getSchaltprogrammgruppen() {
			return _schaltprogrammgruppen;
		}
	
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.anzeigeTyp.
		<p>
		
		</p>
		
		@return der Wert von VerboteneAnzeigen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp
			> getVerboteneAnzeigen() {
			return _verboteneAnzeigen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arraySchaltprogrammgruppen = datum.getReferenceArray("Schaltprogrammgruppen");
					arraySchaltprogrammgruppen.setLength(getSchaltprogrammgruppen().size());
					for (int i = 0; i < arraySchaltprogrammgruppen.getLength(); ++i) {
						final Object soSchaltprogrammgruppen = getSchaltprogrammgruppen().get(i);
						final SystemObject tmpSchaltprogrammgruppen;
						if (soSchaltprogrammgruppen instanceof SystemObject) {
							tmpSchaltprogrammgruppen = (SystemObject)soSchaltprogrammgruppen;
						} else if(soSchaltprogrammgruppen instanceof SystemObjekt){
							tmpSchaltprogrammgruppen = ((SystemObjekt)soSchaltprogrammgruppen).getSystemObject();
						} else{
							tmpSchaltprogrammgruppen = null;
						}
						arraySchaltprogrammgruppen.getReferenceValue(i).setSystemObject(tmpSchaltprogrammgruppen);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayVerboteneAnzeigen = datum.getReferenceArray("VerboteneAnzeigen");
					arrayVerboteneAnzeigen.setLength(getVerboteneAnzeigen().size());
					for (int i = 0; i < arrayVerboteneAnzeigen.getLength(); ++i) {
						final Object soVerboteneAnzeigen = getVerboteneAnzeigen().get(i);
						final SystemObject tmpVerboteneAnzeigen;
						if (soVerboteneAnzeigen instanceof SystemObject) {
							tmpVerboteneAnzeigen = (SystemObject)soVerboteneAnzeigen;
						} else if(soVerboteneAnzeigen instanceof SystemObjekt){
							tmpVerboteneAnzeigen = ((SystemObjekt)soVerboteneAnzeigen).getSystemObject();
						} else{
							tmpVerboteneAnzeigen = null;
						}
						arrayVerboteneAnzeigen.getReferenceValue(i).setSystemObject(tmpVerboteneAnzeigen);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arraySchaltprogrammgruppen = daten.getReferenceArray("Schaltprogrammgruppen");
					for (int i = 0; i < arraySchaltprogrammgruppen.getLength(); ++i) {
						final long idSchaltprogrammgruppen = daten.getReferenceArray("Schaltprogrammgruppen").getReferenceValue(i).getId();
						final SystemObjekt tmpSchaltprogrammgruppen;
						if (idSchaltprogrammgruppen == 0) {
							tmpSchaltprogrammgruppen = null;
						} else {
							final SystemObject soSchaltprogrammgruppen = factory.getDav().getDataModel().getObject(idSchaltprogrammgruppen);
							if (soSchaltprogrammgruppen == null) {
									tmpSchaltprogrammgruppen = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammGruppeUngueltig(idSchaltprogrammgruppen);
							} else {
								tmpSchaltprogrammgruppen = factory.getModellobjekt(soSchaltprogrammgruppen);
							}
						}
							getSchaltprogrammgruppen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
							) tmpSchaltprogrammgruppen);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayVerboteneAnzeigen = daten.getReferenceArray("VerboteneAnzeigen");
					for (int i = 0; i < arrayVerboteneAnzeigen.getLength(); ++i) {
						final long idVerboteneAnzeigen = daten.getReferenceArray("VerboteneAnzeigen").getReferenceValue(i).getId();
						final SystemObjekt tmpVerboteneAnzeigen;
						if (idVerboteneAnzeigen == 0) {
							tmpVerboteneAnzeigen = null;
						} else {
							final SystemObject soVerboteneAnzeigen = factory.getDav().getDataModel().getObject(idVerboteneAnzeigen);
							if (soVerboteneAnzeigen == null) {
									tmpVerboteneAnzeigen = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeTypUngueltig(idVerboteneAnzeigen);
							} else {
								tmpVerboteneAnzeigen = factory.getModellobjekt(soVerboteneAnzeigen);
							}
						}
							getVerboteneAnzeigen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp
							) tmpVerboteneAnzeigen);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaVerboteneAnzeigen clone() {
		AtlVbaVerboteneAnzeigen klon = new AtlVbaVerboteneAnzeigen();
		
					klon._schaltprogrammgruppen = getSchaltprogrammgruppen().clone();
					klon._verboteneAnzeigen = getVerboteneAnzeigen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
