/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Alle Informationen zu den verschiedenen
					Programmgruppen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdSchaltProgrammGruppe extends AbstractKonfigurationsDatensatz<KdSchaltProgrammGruppe.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _name
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSystemModus
				> _zugelasseneModi = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSystemModus
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltPrioritaet
				 _prioritaet
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
				> _verdraengt = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _schaltetAllein
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Enumerationstyp für die verschiedenen
								VBA-Systemmodi.
			<p>
			
			</p>
			
			@return der Wert von ZugelasseneModi.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSystemModus
				> getZugelasseneModi() {
				return _zugelasseneModi;
			}
		
		
			/**
			Die Priorität eines Programms innerhalb einer
								Programmgruppe.
			<p>
			
			</p>
			
			@return der Wert von Prioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltPrioritaet
				 getPrioritaet() {
				return _prioritaet;
			}
		
			/**
			Die Priorität eines Programms innerhalb einer
								Programmgruppe.
			<p>
			
			</p>
			
			@param _prioritaet der neue Wert von Prioritaet.
			*/
			public void setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltPrioritaet
			 _prioritaet) {
				this._prioritaet = _prioritaet;
			}
		
			/**
			Verweis auf ein Objekt vom Typ SchaltProgrammGruppe.
			<p>
			
			</p>
			
			@return der Wert von Verdraengt.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
				> getVerdraengt() {
				return _verdraengt;
			}
		
		
			/**
			Gibt an, ob Programme dieser Gruppe völlig allein
									Schalten.
									Allein heißt, dass das&#47;die aktuell geschaltete&#47;n
									Programm&#47;e in
									den Hintergrund treten und nicht weiterhin "partiell"
									geschaltet
									bleiben. Die Schaltprogrammliste enthält nach der
									Schaltung eines
									solchen Programms nur noch dieses Programm.
			<p>
			
			</p>
			
			@return der Wert von SchaltetAllein.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSchaltetAllein() {
				return _schaltetAllein;
			}
		
			/**
			Gibt an, ob Programme dieser Gruppe völlig allein
									Schalten.
									Allein heißt, dass das&#47;die aktuell geschaltete&#47;n
									Programm&#47;e in
									den Hintergrund treten und nicht weiterhin "partiell"
									geschaltet
									bleiben. Die Schaltprogrammliste enthält nach der
									Schaltung eines
									solchen Programms nur noch dieses Programm.
			<p>
			
			</p>
			
			@param _schaltetAllein der neue Wert von SchaltetAllein.
			*/
			public void setSchaltetAllein(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _schaltetAllein) {
				this._schaltetAllein = _schaltetAllein;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// GanzzahlAttributTyp
					if (getZugelasseneModi() != null) {
						final Data.NumberArray arrayZugelasseneModi = datum.
							getUnscaledArray
							("ZugelasseneModi");
						arrayZugelasseneModi.setLength(getZugelasseneModi().size());
						for (int i = 0; i < arrayZugelasseneModi.getLength(); ++i) {
							arrayZugelasseneModi.getValue(i).set(getZugelasseneModi().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getPrioritaet() != null) {
		                if (getPrioritaet().isZustand()) {
		                    datum.getUnscaledValue("Prioritaet").setText(getPrioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Prioritaet").set(getPrioritaet().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayVerdraengt = datum.getReferenceArray("Verdraengt");
						arrayVerdraengt.setLength(getVerdraengt().size());
						for (int i = 0; i < arrayVerdraengt.getLength(); ++i) {
							final Object soVerdraengt = getVerdraengt().get(i);
							final SystemObject tmpVerdraengt;
							if (soVerdraengt instanceof SystemObject) {
								tmpVerdraengt = (SystemObject)soVerdraengt;
							} else if(soVerdraengt instanceof SystemObjekt){
								tmpVerdraengt = ((SystemObjekt)soVerdraengt).getSystemObject();
							} else{
								tmpVerdraengt = null;
							}
							arrayVerdraengt.getReferenceValue(i).setSystemObject(tmpVerdraengt);
						}
					// GanzzahlAttributTyp
					if (getSchaltetAllein() != null) {
		                if (getSchaltetAllein().isZustand()) {
		                    datum.getUnscaledValue("SchaltetAllein").setText(getSchaltetAllein().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SchaltetAllein").set(getSchaltetAllein().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// GanzzahlAttributTyp
						final Data.NumberArray arrayZugelasseneModi = daten.
							getUnscaledArray
						("ZugelasseneModi");
		
						for (int i = 0; i < arrayZugelasseneModi.getLength(); ++i) {
		                    if (arrayZugelasseneModi.getValue(i).isState()) {
		                        getZugelasseneModi().add(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSystemModus
		                        .getZustand(arrayZugelasseneModi.getValue(i).getState().getName()));
		                    } else {
		                    getZugelasseneModi().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSystemModus
		                    (arrayZugelasseneModi.
		                    		byteValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Prioritaet").isState()) {
								setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltPrioritaet
								.getZustand(daten.getScaledValue("Prioritaet").getText()));
							} else {
							setPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltPrioritaet
							(daten.
								getUnscaledValue
							("Prioritaet").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayVerdraengt = daten.getReferenceArray("Verdraengt");
						for (int i = 0; i < arrayVerdraengt.getLength(); ++i) {
							final long idVerdraengt = daten.getReferenceArray("Verdraengt").getReferenceValue(i).getId();
							final SystemObjekt tmpVerdraengt;
							if (idVerdraengt == 0) {
								tmpVerdraengt = null;
							} else {
								final SystemObject soVerdraengt = factory.getDav().getDataModel().getObject(idVerdraengt);
								if (soVerdraengt == null) {
										tmpVerdraengt = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammGruppeUngueltig(idVerdraengt);
								} else {
									tmpVerdraengt = factory.getModellobjekt(soVerdraengt);
								}
							}
								getVerdraengt().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
								) tmpVerdraengt);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchaltetAllein").isState()) {
								setSchaltetAllein(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("SchaltetAllein").getText()));
							} else {
							setSchaltetAllein(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("SchaltetAllein").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setName(getName());
						klon._zugelasseneModi = getZugelasseneModi().clone();
							klon.setPrioritaet(getPrioritaet());
						klon._verdraengt = getVerdraengt().clone();
							klon.setSchaltetAllein(getSchaltetAllein());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.schaltProgrammGruppe";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdSchaltProgrammGruppe(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
