/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Globale Zustände des VBA-Systems.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface VbaSystemGlobal extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.vbaSystemGlobal"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Negative Quittungen (FG 4 &#47; Typ 16), die ein
						Zustandsfehler der UZ sind.
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Erläuterung&lt;&#47;titel&gt;
							&lt;absatz&gt;Diese Attributgruppe bestimmt, ob eine empfangene
								negative Quittung gesendet wurde,
								weil die UZ eine unzulässige
								Schaltung versucht hat (z.B.
								WZG-Stellzustand setzen in
								Betriebsart "HAND") oder ob eine echtes Problem auf der Hardware
								vorliegt.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Aus dem Ergebnis kann man dann bestimmen, ob es
								eventuell Sinn macht, die Schaltung
								nochmal zu versuchen oder
								lieber nicht.&lt;&#47;absatz&gt;
							&lt;absatz&gt;Siehe ITypVbaSystemGlobal#isNegQuitSoftwareError
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz NegativeQuittungSoftwareFehler.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter.PdNegativeQuittungSoftwareFehler getPdNegativeQuittungSoftwareFehler();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Tabelle, die Listen von Schaltprogrammgruppen
						Listen von Anzeigetypen zurodnet, die in keiner dieser
						Schaltprogrammgruppen
						versorgt werden dürfen.
	<p>
	
	</p>
	@return der Datensatz VbaVerboteneAnzeigen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter.PdVbaVerboteneAnzeigen getPdVbaVerboteneAnzeigen();
	
	/**
	Farben und Schriftarten für die Anzeige von
						Programmgruppen in der Visualisierung.
	<p>
	
	</p>
	@return der Datensatz BcProgrammgruppenDisplayFarbenUndSchriften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.parameter.PdBcProgrammgruppenDisplayFarbenUndSchriften getPdBcProgrammgruppenDisplayFarbenUndSchriften();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	AQ und Anzeigen, die beim Schalten ignoriert werden
						sollen.
	<p>
	
	</p>
	@return der Datensatz VbaAQIgnore.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter.PdVbaAQIgnore getPdVbaAQIgnore();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Aktueller Systemmodus als Parameter (kann nach
						Neustart des Systems wieder hergestellt werden).
	<p>
	
	</p>
	@return der Datensatz VbaSystemGlobal.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter.PdVbaSystemGlobal getPdVbaSystemGlobal();
	
	/**
	Der Konsistenzzustand betr. den tatsaechlich
						geschalteten Anzeigen der Aussenanlage und dem Schaltprogrammserver.
	<p>
	
	</p>
	@return der Datensatz VbaSollIstVergleich.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.onlinedaten.OdVbaSollIstVergleich getOdVbaSollIstVergleich();
	
	/**
	Liste von Schaltprogrammgruppen bzw. Programmen,
						die
						editierbar sein sollen.
	<p>
	
	</p>
	@return der Datensatz VbaEditierbareProgramme.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter.PdVbaEditierbareProgramme getPdVbaEditierbareProgramme();
	
	/**
	Aktueller Modus der Verkehrsautomatik als
						Parameter (kann nach Neustart des Systems wieder hergestellt
						werden).
	<p>
	
	</p>
	@return der Datensatz VbaSystemVerkehrsAutomatik.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter.PdVbaSystemVerkehrsAutomatik getPdVbaSystemVerkehrsAutomatik();
	
	/**
	Beschreibt eine Liste mit Anzeigen, deren
						Rückmeldungen vom Schaltprogrammserver ignoriert werden können.
	<p>
	
	</p>
	@return der Datensatz SelektivesIgnorieren.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter.PdSelektivesIgnorieren getPdSelektivesIgnorieren();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
