/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Wird vom Schaltprogramm-Server (Klasse BetriebszustandPublizierer) gefüllt mit genau einer Referenz
					auf dasjenige Schaltprogramm, was den aktuellen Betriebszustand (=Hauptprogramm)
					repräsentiert.
<p>
&lt;liste zeichen="punkt"&gt;
					&lt;listenPunkt&gt;Falls kein Hauptprogramm bestimmt werden konnte, wird das NULLPROGRAMM publiziert.&lt;&#47;listenPunkt&gt;
					&lt;listenPunkt&gt;Die Information über zusätzliche Programme, die online sind und daher
					den Betriebszustand überlagern, wird über Ja&#47;Nein Attribute publiziert,
					für jede der Standardschaltprogrammgruppen eins.&lt;&#47;listenPunkt&gt;
				&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class OdAktuellerBetriebsZustand extends AbstractOnlineDatensatz<OdAktuellerBetriebsZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				@Defaultwert(wert = "NULLPROGRAMM")
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 _betriebszustand
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _sonderprogrammAktiv
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _sBAProgrammAktiv
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _notprogrammAktiv
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _handprogrammAktiv
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _grundprogrammAktiv
				;
		
			/**
			Info.
			<p>
			
			</p>
			
			@return der Wert von Betriebszustand.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 getBetriebszustand() {
				return _betriebszustand;
			}
		
			/**
			Info.
			<p>
			
			</p>
			
			@param _betriebszustand der neue Wert von Betriebszustand.
			*/
			public void setBetriebszustand(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _betriebszustand) {
				this._betriebszustand = _betriebszustand;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von SonderprogrammAktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSonderprogrammAktiv() {
				return _sonderprogrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _sonderprogrammAktiv der neue Wert von SonderprogrammAktiv.
			*/
			public void setSonderprogrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _sonderprogrammAktiv) {
				this._sonderprogrammAktiv = _sonderprogrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von SBAProgrammAktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSBAProgrammAktiv() {
				return _sBAProgrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _sBAProgrammAktiv der neue Wert von SBAProgrammAktiv.
			*/
			public void setSBAProgrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _sBAProgrammAktiv) {
				this._sBAProgrammAktiv = _sBAProgrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von NotprogrammAktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getNotprogrammAktiv() {
				return _notprogrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _notprogrammAktiv der neue Wert von NotprogrammAktiv.
			*/
			public void setNotprogrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _notprogrammAktiv) {
				this._notprogrammAktiv = _notprogrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von HandprogrammAktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getHandprogrammAktiv() {
				return _handprogrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _handprogrammAktiv der neue Wert von HandprogrammAktiv.
			*/
			public void setHandprogrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _handprogrammAktiv) {
				this._handprogrammAktiv = _handprogrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von GrundprogrammAktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getGrundprogrammAktiv() {
				return _grundprogrammAktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _grundprogrammAktiv der neue Wert von GrundprogrammAktiv.
			*/
			public void setGrundprogrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _grundprogrammAktiv) {
				this._grundprogrammAktiv = _grundprogrammAktiv;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soBetriebszustand = getBetriebszustand();
						final SystemObject tmpBetriebszustand;
							if (soBetriebszustand instanceof SystemObject) {
								tmpBetriebszustand = (SystemObject)soBetriebszustand;
							} else if(soBetriebszustand instanceof SystemObjekt){
								tmpBetriebszustand = ((SystemObjekt)soBetriebszustand).getSystemObject();
							} else{
								tmpBetriebszustand = null;
							}
						datum.getReferenceValue("Betriebszustand").setSystemObject(tmpBetriebszustand);
					// GanzzahlAttributTyp
					if (getSonderprogrammAktiv() != null) {
		                if (getSonderprogrammAktiv().isZustand()) {
		                    datum.getUnscaledValue("SonderprogrammAktiv").setText(getSonderprogrammAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SonderprogrammAktiv").set(getSonderprogrammAktiv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSBAProgrammAktiv() != null) {
		                if (getSBAProgrammAktiv().isZustand()) {
		                    datum.getUnscaledValue("SBAProgrammAktiv").setText(getSBAProgrammAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SBAProgrammAktiv").set(getSBAProgrammAktiv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNotprogrammAktiv() != null) {
		                if (getNotprogrammAktiv().isZustand()) {
		                    datum.getUnscaledValue("NotprogrammAktiv").setText(getNotprogrammAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("NotprogrammAktiv").set(getNotprogrammAktiv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getHandprogrammAktiv() != null) {
		                if (getHandprogrammAktiv().isZustand()) {
		                    datum.getUnscaledValue("HandprogrammAktiv").setText(getHandprogrammAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("HandprogrammAktiv").set(getHandprogrammAktiv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGrundprogrammAktiv() != null) {
		                if (getGrundprogrammAktiv().isZustand()) {
		                    datum.getUnscaledValue("GrundprogrammAktiv").setText(getGrundprogrammAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("GrundprogrammAktiv").set(getGrundprogrammAktiv().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idBetriebszustand = daten.getReferenceValue("Betriebszustand").getId();
						final SystemObjekt tmpBetriebszustand;
						if (idBetriebszustand == 0) {
							tmpBetriebszustand = null;
						} else {
							final SystemObject soBetriebszustand = factory.getDav().getDataModel().getObject(idBetriebszustand);
							if (soBetriebszustand == null) {
									tmpBetriebszustand = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idBetriebszustand);
							} else {
								tmpBetriebszustand = factory.getModellobjekt(soBetriebszustand);
							}
						}
						setBetriebszustand((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
						) tmpBetriebszustand);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SonderprogrammAktiv").isState()) {
								setSonderprogrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("SonderprogrammAktiv").getText()));
							} else {
							setSonderprogrammAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("SonderprogrammAktiv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SBAProgrammAktiv").isState()) {
								setSBAProgrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("SBAProgrammAktiv").getText()));
							} else {
							setSBAProgrammAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("SBAProgrammAktiv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NotprogrammAktiv").isState()) {
								setNotprogrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("NotprogrammAktiv").getText()));
							} else {
							setNotprogrammAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("NotprogrammAktiv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("HandprogrammAktiv").isState()) {
								setHandprogrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("HandprogrammAktiv").getText()));
							} else {
							setHandprogrammAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("HandprogrammAktiv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("GrundprogrammAktiv").isState()) {
								setGrundprogrammAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("GrundprogrammAktiv").getText()));
							} else {
							setGrundprogrammAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("GrundprogrammAktiv").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBetriebszustand(getBetriebszustand());
							klon.setSonderprogrammAktiv(getSonderprogrammAktiv());
							klon.setSBAProgrammAktiv(getSBAProgrammAktiv());
							klon.setNotprogrammAktiv(getNotprogrammAktiv());
							klon.setHandprogrammAktiv(getHandprogrammAktiv());
							klon.setGrundprogrammAktiv(getGrundprogrammAktiv());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.aktuellerBetriebsZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdAktuellerBetriebsZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
