/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert den aktuellen Zustand eines
					Schaltprogramms sowie
					assoziierte Informationen (z.B. welcher Nutzer
					die aktion verursacht hat).
					Die Attributgruppe wird vom
					Nutzerprogramm-Server gespeist.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdSchaltProgrammZustand extends AbstractOnlineDatensatz<OdSchaltProgrammZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltProgrammZustand
				 _zustand
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
				 _nutzer
				;
				private String
				 _id
				= new String
				()
				;
		
			/**
			Definiert den aktuellen Zustand eines
								Schaltprogramms.
			<p>
			
			</p>
			
			@return der Wert von Zustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltProgrammZustand
				 getZustand() {
				return _zustand;
			}
		
			/**
			Definiert den aktuellen Zustand eines
								Schaltprogramms.
			<p>
			
			</p>
			
			@param _zustand der neue Wert von Zustand.
			*/
			public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltProgrammZustand
			 _zustand) {
				this._zustand = _zustand;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.benutzer.
			<p>
			
			</p>
			
			@return der Wert von Nutzer.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
				 getNutzer() {
				return _nutzer;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.benutzer.
			<p>
			
			</p>
			
			@param _nutzer der neue Wert von Nutzer.
			*/
			public void setNutzer(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 _nutzer) {
				this._nutzer = _nutzer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Id.
			*/
				public String
				 getId() {
				return _id;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _id der neue Wert von Id.
			*/
			public void setId(String
			 _id) {
				if (_id.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._id = _id;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getZustand() != null) {
		                if (getZustand().isZustand()) {
		                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Zustand").set(getZustand().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soNutzer = getNutzer();
						final SystemObject tmpNutzer;
							if (soNutzer instanceof SystemObject) {
								tmpNutzer = (SystemObject)soNutzer;
							} else if(soNutzer instanceof SystemObjekt){
								tmpNutzer = ((SystemObjekt)soNutzer).getSystemObject();
							} else{
								tmpNutzer = null;
							}
						datum.getReferenceValue("Nutzer").setSystemObject(tmpNutzer);
					// ZeichenkettenAttributTyp
					if (getId() != null) {
						datum.getTextValue("Id").setText(getId());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Zustand").isState()) {
								setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltProgrammZustand
								.getZustand(daten.getScaledValue("Zustand").getText()));
							} else {
							setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttSchaltProgrammZustand
							(daten.
								getUnscaledValue
							("Zustand").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idNutzer = daten.getReferenceValue("Nutzer").getId();
						final SystemObjekt tmpNutzer;
						if (idNutzer == 0) {
							tmpNutzer = null;
						} else {
							final SystemObject soNutzer = factory.getDav().getDataModel().getObject(idNutzer);
							if (soNutzer == null) {
									tmpNutzer = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.BenutzerUngueltig(idNutzer);
							} else {
								tmpNutzer = factory.getModellobjekt(soNutzer);
							}
						}
						setNutzer((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
						) tmpNutzer);
					// ZeichenkettenAttributTyp
						setId(daten.getTextValue("Id").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setZustand(getZustand());
							klon.setNutzer(getNutzer());
							klon.setId(getId());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.schaltProgrammZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdSchaltProgrammZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
