/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdSchaltProgramm extends AbstractParameterDatensatz<PdSchaltProgramm.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.SchaltVorgabe,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
					Aspekte.SchaltVorgabeIst,
				};
			}
	
			/**
			 * Für die Schaltung eines Programms.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt SchaltVorgabe = new Aspekte("SchaltVorgabe", "asp.schaltVorgabe");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			/**
			 * Für die Rückmeldung einer Vorgabeschaltung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt SchaltVorgabeIst = new Aspekte("SchaltVorgabeIst", "asp.schaltVorgabeIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _name
				= new String
				()
				;
				private String
				 _kommentar
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
				 _anleger
				;
				private 	Zeitstempel
				 _bereichsAnfang
				;
				private 	Zeitstempel
				 _bereichsEnde
				;
				private 	RelativerZeitstempel
				 _startZeit
				;
				private 	RelativerZeitstempel
				 _endeZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _wochentage
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
				 _gruppe
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlAnzeigenSchaltProgramm
				> _anzeigenSchaltungen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlAnzeigenSchaltProgramm
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Kommentar.
			*/
				public String
				 getKommentar() {
				return _kommentar;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _kommentar der neue Wert von Kommentar.
			*/
			public void setKommentar(String
			 _kommentar) {
				if (_kommentar.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._kommentar = _kommentar;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.benutzer.
			<p>
			
			</p>
			
			@return der Wert von Anleger.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
				 getAnleger() {
				return _anleger;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.benutzer.
			<p>
			
			</p>
			
			@param _anleger der neue Wert von Anleger.
			*/
			public void setAnleger(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 _anleger) {
				this._anleger = _anleger;
			}
		
			/**
			Zwischen BereichsAnfang und BereichsEnde wird das
									Programm geschaltet, wie in den nächsten drei Attributen
									vorgeschrieben.
			<p>
			
			</p>
			
			@return der Wert von BereichsAnfang.
			*/
				public 	Zeitstempel
				 getBereichsAnfang() {
				return _bereichsAnfang;
			}
		
			/**
			Zwischen BereichsAnfang und BereichsEnde wird das
									Programm geschaltet, wie in den nächsten drei Attributen
									vorgeschrieben.
			<p>
			
			</p>
			
			@param _bereichsAnfang der neue Wert von BereichsAnfang.
			*/
			public void setBereichsAnfang(	Zeitstempel
			 _bereichsAnfang) {
				this._bereichsAnfang = _bereichsAnfang;
			}
		
			/**
			Zwischen BereichsAnfang und BereichsEnde wird das
									Programm geschaltet, wie in den nächsten drei Attributen
									vorgeschrieben.
			<p>
			
			</p>
			
			@return der Wert von BereichsEnde.
			*/
				public 	Zeitstempel
				 getBereichsEnde() {
				return _bereichsEnde;
			}
		
			/**
			Zwischen BereichsAnfang und BereichsEnde wird das
									Programm geschaltet, wie in den nächsten drei Attributen
									vorgeschrieben.
			<p>
			
			</p>
			
			@param _bereichsEnde der neue Wert von BereichsEnde.
			*/
			public void setBereichsEnde(	Zeitstempel
			 _bereichsEnde) {
				this._bereichsEnde = _bereichsEnde;
			}
		
			/**
			Startzeit (Tageszeit, wenn ein Bereich angegeben
									ist).
			<p>
			
			</p>
			
			@return der Wert von StartZeit.
			*/
				public 	RelativerZeitstempel
				 getStartZeit() {
				return _startZeit;
			}
		
			/**
			Startzeit (Tageszeit, wenn ein Bereich angegeben
									ist).
			<p>
			
			</p>
			
			@param _startZeit der neue Wert von StartZeit.
			*/
			public void setStartZeit(	RelativerZeitstempel
			 _startZeit) {
				this._startZeit = _startZeit;
			}
		
			/**
			Endzeit (Tageszeit, wenn ein Bereich angegeben
									ist).
			<p>
			
			</p>
			
			@return der Wert von EndeZeit.
			*/
				public 	RelativerZeitstempel
				 getEndeZeit() {
				return _endeZeit;
			}
		
			/**
			Endzeit (Tageszeit, wenn ein Bereich angegeben
									ist).
			<p>
			
			</p>
			
			@param _endeZeit der neue Wert von EndeZeit.
			*/
			public void setEndeZeit(	RelativerZeitstempel
			 _endeZeit) {
				this._endeZeit = _endeZeit;
			}
		
			/**
			Bit0 = Montag, Bit1 = Dienstag, u.s.w.
			<p>
			
			</p>
			
			@return der Wert von Wochentage.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getWochentage() {
				return _wochentage;
			}
		
			/**
			Bit0 = Montag, Bit1 = Dienstag, u.s.w.
			<p>
			
			</p>
			
			@param _wochentage der neue Wert von Wochentage.
			*/
			public void setWochentage(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _wochentage) {
				this._wochentage = _wochentage;
			}
		
			/**
			Verweis auf ein Objekt vom Typ SchaltProgrammGruppe.
			<p>
			
			</p>
			
			@return der Wert von Gruppe.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
				 getGruppe() {
				return _gruppe;
			}
		
			/**
			Verweis auf ein Objekt vom Typ SchaltProgrammGruppe.
			<p>
			
			</p>
			
			@param _gruppe der neue Wert von Gruppe.
			*/
			public void setGruppe(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
			 _gruppe) {
				this._gruppe = _gruppe;
			}
		
			/**
			Info.
			<p>
			
			</p>
			
			@return der Wert von AnzeigenSchaltungen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlAnzeigenSchaltProgramm
				> getAnzeigenSchaltungen() {
				return _anzeigenSchaltungen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ZeichenkettenAttributTyp
					if (getKommentar() != null) {
						datum.getTextValue("Kommentar").setText(getKommentar());
					}
					// ObjektReferenzAttributTyp
						final Object soAnleger = getAnleger();
						final SystemObject tmpAnleger;
							if (soAnleger instanceof SystemObject) {
								tmpAnleger = (SystemObject)soAnleger;
							} else if(soAnleger instanceof SystemObjekt){
								tmpAnleger = ((SystemObjekt)soAnleger).getSystemObject();
							} else{
								tmpAnleger = null;
							}
						datum.getReferenceValue("Anleger").setSystemObject(tmpAnleger);
					// ZeitstempelAttributTyp
						datum.getTimeValue("BereichsAnfang").setMillis(getBereichsAnfang().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("BereichsEnde").setMillis(getBereichsEnde().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("StartZeit").setMillis(getStartZeit().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("EndeZeit").setMillis(getEndeZeit().getTime());
					// GanzzahlAttributTyp
					if (getWochentage() != null) {
		                if (getWochentage().isZustand()) {
		                    datum.getUnscaledValue("Wochentage").setText(getWochentage().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Wochentage").set(getWochentage().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soGruppe = getGruppe();
						final SystemObject tmpGruppe;
							if (soGruppe instanceof SystemObject) {
								tmpGruppe = (SystemObject)soGruppe;
							} else if(soGruppe instanceof SystemObjekt){
								tmpGruppe = ((SystemObjekt)soGruppe).getSystemObject();
							} else{
								tmpGruppe = null;
							}
						datum.getReferenceValue("Gruppe").setSystemObject(tmpGruppe);
					// AttributListenDefinition
						final Data.Array arrayAnzeigenSchaltungen = datum.getArray("AnzeigenSchaltungen");
						arrayAnzeigenSchaltungen.setLength(getAnzeigenSchaltungen().size());
						for (int i = 0; i < arrayAnzeigenSchaltungen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlAnzeigenSchaltProgramm
							 atl = getAnzeigenSchaltungen().get(i);
							atl.bean2Atl(arrayAnzeigenSchaltungen.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ZeichenkettenAttributTyp
						setKommentar(daten.getTextValue("Kommentar").getText());
					// ObjektReferenzAttributTyp
						final long idAnleger = daten.getReferenceValue("Anleger").getId();
						final SystemObjekt tmpAnleger;
						if (idAnleger == 0) {
							tmpAnleger = null;
						} else {
							final SystemObject soAnleger = factory.getDav().getDataModel().getObject(idAnleger);
							if (soAnleger == null) {
									tmpAnleger = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.BenutzerUngueltig(idAnleger);
							} else {
								tmpAnleger = factory.getModellobjekt(soAnleger);
							}
						}
						setAnleger((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
						) tmpAnleger);
					// ZeitstempelAttributTyp
						setBereichsAnfang(new
							Zeitstempel
							(daten.getTimeValue("BereichsAnfang").getMillis()));
					// ZeitstempelAttributTyp
						setBereichsEnde(new
							Zeitstempel
							(daten.getTimeValue("BereichsEnde").getMillis()));
					// ZeitstempelAttributTyp
						setStartZeit(new
							RelativerZeitstempel
							(daten.getTimeValue("StartZeit").getMillis()));
					// ZeitstempelAttributTyp
						setEndeZeit(new
							RelativerZeitstempel
							(daten.getTimeValue("EndeZeit").getMillis()));
					// GanzzahlAttributTyp
							setWochentage(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Wochentage").
									longValue
							()));
					// ObjektReferenzAttributTyp
						final long idGruppe = daten.getReferenceValue("Gruppe").getId();
						final SystemObjekt tmpGruppe;
						if (idGruppe == 0) {
							tmpGruppe = null;
						} else {
							final SystemObject soGruppe = factory.getDav().getDataModel().getObject(idGruppe);
							if (soGruppe == null) {
									tmpGruppe = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammGruppeUngueltig(idGruppe);
							} else {
								tmpGruppe = factory.getModellobjekt(soGruppe);
							}
						}
						setGruppe((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
						) tmpGruppe);
					// AttributListenDefinition
						final Data.Array arrayAnzeigenSchaltungen = daten.getArray("AnzeigenSchaltungen");
						for (int i = 0; i < arrayAnzeigenSchaltungen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlAnzeigenSchaltProgramm
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlAnzeigenSchaltProgramm
							 ();
							atl.atl2Bean(arrayAnzeigenSchaltungen.getItem(i), factory);
							getAnzeigenSchaltungen().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setName(getName());
							klon.setKommentar(getKommentar());
							klon.setAnleger(getAnleger());
							klon.setBereichsAnfang(getBereichsAnfang());
							klon.setBereichsEnde(getBereichsEnde());
							klon.setStartZeit(getStartZeit());
							klon.setEndeZeit(getEndeZeit());
							klon.setWochentage(getWochentage());
							klon.setGruppe(getGruppe());
						klon._anzeigenSchaltungen = getAnzeigenSchaltungen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.schaltProgramm";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdSchaltProgramm(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
