/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung eines Messwerttyps für Messwerte von
					Wetterstationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 34
 */
public class AtlEmpfaenger implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _schluessel
			= new String
			()
			;
			private String
			 _displayname
			= new String
			()
			;
			private String
			 _internername
			= new String
			()
			;
			private String
			 _telefonnummer
			= new String
			()
			;
			private String
			 _faxnummer
			= new String
			()
			;
			private String
			 _emailaddresse
			= new String
			()
			;
			private String
			 _erreichbarkeit
			= new String
			()
			;
			private 	Zeitstempel
			 _nichterreichbarvon
			;
			private 	Zeitstempel
			 _nichterreichbarbis
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Schluessel.
		*/
			public String
			 getSchluessel() {
			return _schluessel;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _schluessel der neue Wert von Schluessel.
		*/
		public void setSchluessel(String
		 _schluessel) {
			if (_schluessel.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._schluessel = _schluessel;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Displayname.
		*/
			public String
			 getDisplayname() {
			return _displayname;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _displayname der neue Wert von Displayname.
		*/
		public void setDisplayname(String
		 _displayname) {
			if (_displayname.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._displayname = _displayname;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Internername.
		*/
			public String
			 getInternername() {
			return _internername;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _internername der neue Wert von Internername.
		*/
		public void setInternername(String
		 _internername) {
			if (_internername.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._internername = _internername;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Telefonnummer.
		*/
			public String
			 getTelefonnummer() {
			return _telefonnummer;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _telefonnummer der neue Wert von Telefonnummer.
		*/
		public void setTelefonnummer(String
		 _telefonnummer) {
			if (_telefonnummer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._telefonnummer = _telefonnummer;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Faxnummer.
		*/
			public String
			 getFaxnummer() {
			return _faxnummer;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _faxnummer der neue Wert von Faxnummer.
		*/
		public void setFaxnummer(String
		 _faxnummer) {
			if (_faxnummer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._faxnummer = _faxnummer;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Emailaddresse.
		*/
			public String
			 getEmailaddresse() {
			return _emailaddresse;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _emailaddresse der neue Wert von Emailaddresse.
		*/
		public void setEmailaddresse(String
		 _emailaddresse) {
			if (_emailaddresse.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._emailaddresse = _emailaddresse;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Erreichbarkeit.
		*/
			public String
			 getErreichbarkeit() {
			return _erreichbarkeit;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _erreichbarkeit der neue Wert von Erreichbarkeit.
		*/
		public void setErreichbarkeit(String
		 _erreichbarkeit) {
			if (_erreichbarkeit.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._erreichbarkeit = _erreichbarkeit;
		}
	
		/**
		Angabe eines Zeitpunktes.
		<p>
		
		</p>
		
		@return der Wert von Nichterreichbarvon.
		*/
			public 	Zeitstempel
			 getNichterreichbarvon() {
			return _nichterreichbarvon;
		}
	
		/**
		Angabe eines Zeitpunktes.
		<p>
		
		</p>
		
		@param _nichterreichbarvon der neue Wert von Nichterreichbarvon.
		*/
		public void setNichterreichbarvon(	Zeitstempel
		 _nichterreichbarvon) {
			this._nichterreichbarvon = _nichterreichbarvon;
		}
	
		/**
		Angabe eines Zeitpunktes.
		<p>
		
		</p>
		
		@return der Wert von Nichterreichbarbis.
		*/
			public 	Zeitstempel
			 getNichterreichbarbis() {
			return _nichterreichbarbis;
		}
	
		/**
		Angabe eines Zeitpunktes.
		<p>
		
		</p>
		
		@param _nichterreichbarbis der neue Wert von Nichterreichbarbis.
		*/
		public void setNichterreichbarbis(	Zeitstempel
		 _nichterreichbarbis) {
			this._nichterreichbarbis = _nichterreichbarbis;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getSchluessel() != null) {
					datum.getTextValue("schluessel").setText(getSchluessel());
				}
				// ZeichenkettenAttributTyp
				if (getDisplayname() != null) {
					datum.getTextValue("displayname").setText(getDisplayname());
				}
				// ZeichenkettenAttributTyp
				if (getInternername() != null) {
					datum.getTextValue("internername").setText(getInternername());
				}
				// ZeichenkettenAttributTyp
				if (getTelefonnummer() != null) {
					datum.getTextValue("telefonnummer").setText(getTelefonnummer());
				}
				// ZeichenkettenAttributTyp
				if (getFaxnummer() != null) {
					datum.getTextValue("faxnummer").setText(getFaxnummer());
				}
				// ZeichenkettenAttributTyp
				if (getEmailaddresse() != null) {
					datum.getTextValue("emailaddresse").setText(getEmailaddresse());
				}
				// ZeichenkettenAttributTyp
				if (getErreichbarkeit() != null) {
					datum.getTextValue("erreichbarkeit").setText(getErreichbarkeit());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("nichterreichbarvon").setMillis(getNichterreichbarvon().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("nichterreichbarbis").setMillis(getNichterreichbarbis().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setSchluessel(daten.getTextValue("schluessel").getText());
				// ZeichenkettenAttributTyp
					setDisplayname(daten.getTextValue("displayname").getText());
				// ZeichenkettenAttributTyp
					setInternername(daten.getTextValue("internername").getText());
				// ZeichenkettenAttributTyp
					setTelefonnummer(daten.getTextValue("telefonnummer").getText());
				// ZeichenkettenAttributTyp
					setFaxnummer(daten.getTextValue("faxnummer").getText());
				// ZeichenkettenAttributTyp
					setEmailaddresse(daten.getTextValue("emailaddresse").getText());
				// ZeichenkettenAttributTyp
					setErreichbarkeit(daten.getTextValue("erreichbarkeit").getText());
				// ZeitstempelAttributTyp
					setNichterreichbarvon(new
						Zeitstempel
						(daten.getTimeValue("nichterreichbarvon").getMillis()));
				// ZeitstempelAttributTyp
					setNichterreichbarbis(new
						Zeitstempel
						(daten.getTimeValue("nichterreichbarbis").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlEmpfaenger clone() {
		AtlEmpfaenger klon = new AtlEmpfaenger();
		
						klon.setSchluessel(getSchluessel());
						klon.setDisplayname(getDisplayname());
						klon.setInternername(getInternername());
						klon.setTelefonnummer(getTelefonnummer());
						klon.setFaxnummer(getFaxnummer());
						klon.setEmailaddresse(getEmailaddresse());
						klon.setErreichbarkeit(getErreichbarkeit());
						klon.setNichterreichbarvon(getNichterreichbarvon());
						klon.setNichterreichbarbis(getNichterreichbarbis());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
