/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Stützstelle der Stützkurve, welche aus dem Restsalzgehalt die Gefriertemperatur ermittelt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 36
 */
public class AtlGtRsStuetzstelle implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "0 %")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
			 _rS
			;
			@Defaultwert(wert = "0 °C")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
			 _gT
			;
	
		/**
		Restsalz.
		<p>
		Sättigungsgrad des gelösten Salzes auf der Fahrbahn (bzw. auf der Fahrbahnsensorik). SR wird in Prozent (%) angegeben. Es wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von RS.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
			 getRS() {
			return _rS;
		}
	
		/**
		Restsalz.
		<p>
		Sättigungsgrad des gelösten Salzes auf der Fahrbahn (bzw. auf der Fahrbahnsensorik). SR wird in Prozent (%) angegeben. Es wird der IST-Wert übertragen.
		</p>
		
		@param _rS der neue Wert von RS.
		*/
		public void setRS(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
		 _rS) {
			this._rS = _rS;
		}
	
		/**
		Gefriertemperatur.
		<p>
		&lt;absatz&gt;
								Die Gefriertemperatur ist diejenige Temperatur in Grad Celsius, bei der die an der Oberfläche der Sonde vorhandene wässrige Taumittel-Lösung gefrieren (Übergang in den festen Aggregatszustand) könnte. Es wird der IST-Wert übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								0 °C Keine Gefriertemperatur-Erniedrigung bzw. keine Taumittelkonzentration messbar bzw. die Bedingungen lassen eine Bestimmung nicht zu. Wenn gleichzeitig auch ?Salzrest? (DE-Typ 52) übertragen wird ist auch dieser Wert zu betrachten (255 = nicht messbar).
							&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von GT.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
			 getGT() {
			return _gT;
		}
	
		/**
		Gefriertemperatur.
		<p>
		&lt;absatz&gt;
								Die Gefriertemperatur ist diejenige Temperatur in Grad Celsius, bei der die an der Oberfläche der Sonde vorhandene wässrige Taumittel-Lösung gefrieren (Übergang in den festen Aggregatszustand) könnte. Es wird der IST-Wert übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								0 °C Keine Gefriertemperatur-Erniedrigung bzw. keine Taumittelkonzentration messbar bzw. die Bedingungen lassen eine Bestimmung nicht zu. Wenn gleichzeitig auch ?Salzrest? (DE-Typ 52) übertragen wird ist auch dieser Wert zu betrachten (255 = nicht messbar).
							&lt;&#47;absatz&gt;
		</p>
		
		@param _gT der neue Wert von GT.
		*/
		public void setGT(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
		 _gT) {
			this._gT = _gT;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getRS() != null) {
	                if (getRS().isZustand()) {
	                    datum.getUnscaledValue("RS").setText(getRS().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("RS").set(getRS().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGT() != null) {
	                if (getGT().isZustand()) {
	                    datum.getUnscaledValue("GT").setText(getGT().toString());
	                } else {
						datum.
						getScaledValue
	                	("GT").set(getGT().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RS").isState()) {
							setRS(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
							.getZustand(daten.getScaledValue("RS").getText()));
						} else {
						setRS(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
						(daten.
							getUnscaledValue
						("RS").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GT").isState()) {
							setGT(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
							.getZustand(daten.getScaledValue("GT").getText()));
						} else {
						setGT(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsGefrierTemperatur
						(daten.
							getScaledValue
						("GT").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGtRsStuetzstelle clone() {
		AtlGtRsStuetzstelle klon = new AtlGtRsStuetzstelle();
		
						klon.setRS(getRS());
						klon.setGT(getGT());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
