/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung eines Messwerttyps für Messwerte von
					Wetterstationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 45
 */
public class AtlMesswertTyp implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _schluessel
			= new String
			()
			;
			private String
			 _kurzbezeichnung
			= new String
			()
			;
			private String
			 _kennungDWD
			= new String
			()
			;
			private String
			 _langbezeichnung
			= new String
			()
			;
			private String
			 _kennungExtern
			= new String
			()
			;
			private String
			 _masseinheit
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _istZustand
			;
			@Defaultwert(wert = "Ja")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _bodensensor
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _davSensorTyp
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlMesswertTypZustaende
			> _messwertTypZustaende = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlMesswertTypZustaende
			>(0, true);
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Schluessel.
		*/
			public String
			 getSchluessel() {
			return _schluessel;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _schluessel der neue Wert von Schluessel.
		*/
		public void setSchluessel(String
		 _schluessel) {
			if (_schluessel.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._schluessel = _schluessel;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Kurzbezeichnung.
		*/
			public String
			 getKurzbezeichnung() {
			return _kurzbezeichnung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _kurzbezeichnung der neue Wert von Kurzbezeichnung.
		*/
		public void setKurzbezeichnung(String
		 _kurzbezeichnung) {
			if (_kurzbezeichnung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._kurzbezeichnung = _kurzbezeichnung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von KennungDWD.
		*/
			public String
			 getKennungDWD() {
			return _kennungDWD;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _kennungDWD der neue Wert von KennungDWD.
		*/
		public void setKennungDWD(String
		 _kennungDWD) {
			if (_kennungDWD.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._kennungDWD = _kennungDWD;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Langbezeichnung.
		*/
			public String
			 getLangbezeichnung() {
			return _langbezeichnung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _langbezeichnung der neue Wert von Langbezeichnung.
		*/
		public void setLangbezeichnung(String
		 _langbezeichnung) {
			if (_langbezeichnung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._langbezeichnung = _langbezeichnung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von KennungExtern.
		*/
			public String
			 getKennungExtern() {
			return _kennungExtern;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _kennungExtern der neue Wert von KennungExtern.
		*/
		public void setKennungExtern(String
		 _kennungExtern) {
			if (_kennungExtern.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._kennungExtern = _kennungExtern;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Masseinheit.
		*/
			public String
			 getMasseinheit() {
			return _masseinheit;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _masseinheit der neue Wert von Masseinheit.
		*/
		public void setMasseinheit(String
		 _masseinheit) {
			if (_masseinheit.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._masseinheit = _masseinheit;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von IstZustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getIstZustand() {
			return _istZustand;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _istZustand der neue Wert von IstZustand.
		*/
		public void setIstZustand(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _istZustand) {
			this._istZustand = _istZustand;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Bodensensor.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getBodensensor() {
			return _bodensensor;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _bodensensor der neue Wert von Bodensensor.
		*/
		public void setBodensensor(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _bodensensor) {
			this._bodensensor = _bodensensor;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.typ (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@return der Wert von DavSensorTyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getDavSensorTyp() {
			return _davSensorTyp;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.typ (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@param _davSensorTyp der neue Wert von DavSensorTyp.
		*/
		public void setDavSensorTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _davSensorTyp) {
			this._davSensorTyp = _davSensorTyp;
		}
	
		/**
		Menge aller inneren Zustände, die ein Messwerttyp annhemen
							kann.
		<p>
		
		</p>
		
		@return der Wert von MesswertTypZustaende.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlMesswertTypZustaende
			> getMesswertTypZustaende() {
			return _messwertTypZustaende;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getSchluessel() != null) {
					datum.getTextValue("schluessel").setText(getSchluessel());
				}
				// ZeichenkettenAttributTyp
				if (getKurzbezeichnung() != null) {
					datum.getTextValue("kurzbezeichnung").setText(getKurzbezeichnung());
				}
				// ZeichenkettenAttributTyp
				if (getKennungDWD() != null) {
					datum.getTextValue("kennungDWD").setText(getKennungDWD());
				}
				// ZeichenkettenAttributTyp
				if (getLangbezeichnung() != null) {
					datum.getTextValue("langbezeichnung").setText(getLangbezeichnung());
				}
				// ZeichenkettenAttributTyp
				if (getKennungExtern() != null) {
					datum.getTextValue("kennungExtern").setText(getKennungExtern());
				}
				// ZeichenkettenAttributTyp
				if (getMasseinheit() != null) {
					datum.getTextValue("maßeinheit").setText(getMasseinheit());
				}
				// GanzzahlAttributTyp
				if (getIstZustand() != null) {
	                if (getIstZustand().isZustand()) {
	                    datum.getUnscaledValue("istZustand").setText(getIstZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("istZustand").set(getIstZustand().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBodensensor() != null) {
	                if (getBodensensor().isZustand()) {
	                    datum.getUnscaledValue("bodensensor").setText(getBodensensor().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("bodensensor").set(getBodensensor().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soDavSensorTyp = getDavSensorTyp();
					final SystemObject tmpDavSensorTyp;
						if (soDavSensorTyp instanceof SystemObject) {
							tmpDavSensorTyp = (SystemObject)soDavSensorTyp;
						} else if(soDavSensorTyp instanceof SystemObjekt){
							tmpDavSensorTyp = ((SystemObjekt)soDavSensorTyp).getSystemObject();
						} else{
							tmpDavSensorTyp = null;
						}
					datum.getReferenceValue("davSensorTyp").setSystemObject(tmpDavSensorTyp);
				// AttributListenDefinition
					final Data.Array arrayMesswertTypZustaende = datum.getArray("messwertTypZustaende");
					arrayMesswertTypZustaende.setLength(getMesswertTypZustaende().size());
					for (int i = 0; i < arrayMesswertTypZustaende.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlMesswertTypZustaende
						 atl = getMesswertTypZustaende().get(i);
						atl.bean2Atl(arrayMesswertTypZustaende.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setSchluessel(daten.getTextValue("schluessel").getText());
				// ZeichenkettenAttributTyp
					setKurzbezeichnung(daten.getTextValue("kurzbezeichnung").getText());
				// ZeichenkettenAttributTyp
					setKennungDWD(daten.getTextValue("kennungDWD").getText());
				// ZeichenkettenAttributTyp
					setLangbezeichnung(daten.getTextValue("langbezeichnung").getText());
				// ZeichenkettenAttributTyp
					setKennungExtern(daten.getTextValue("kennungExtern").getText());
				// ZeichenkettenAttributTyp
					setMasseinheit(daten.getTextValue("maßeinheit").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("istZustand").isState()) {
							setIstZustand(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("istZustand").getText()));
						} else {
						setIstZustand(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("istZustand").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("bodensensor").isState()) {
							setBodensensor(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("bodensensor").getText()));
						} else {
						setBodensensor(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("bodensensor").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idDavSensorTyp = daten.getReferenceValue("davSensorTyp").getId();
					final SystemObjekt tmpDavSensorTyp;
					if (idDavSensorTyp == 0) {
						tmpDavSensorTyp = null;
					} else {
						final SystemObject soDavSensorTyp = factory.getDav().getDataModel().getObject(idDavSensorTyp);
						if (soDavSensorTyp == null) {
								tmpDavSensorTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idDavSensorTyp);
						} else {
							tmpDavSensorTyp = factory.getModellobjekt(soDavSensorTyp);
						}
					}
					setDavSensorTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpDavSensorTyp);
				// AttributListenDefinition
					final Data.Array arrayMesswertTypZustaende = daten.getArray("messwertTypZustaende");
					for (int i = 0; i < arrayMesswertTypZustaende.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlMesswertTypZustaende
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlMesswertTypZustaende
						 ();
						atl.atl2Bean(arrayMesswertTypZustaende.getItem(i), factory);
						getMesswertTypZustaende().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlMesswertTyp clone() {
		AtlMesswertTyp klon = new AtlMesswertTyp();
		
						klon.setSchluessel(getSchluessel());
						klon.setKurzbezeichnung(getKurzbezeichnung());
						klon.setKennungDWD(getKennungDWD());
						klon.setLangbezeichnung(getLangbezeichnung());
						klon.setKennungExtern(getKennungExtern());
						klon.setMasseinheit(getMasseinheit());
						klon.setIstZustand(getIstZustand());
						klon.setBodensensor(getBodensensor());
						klon.setDavSensorTyp(getDavSensorTyp());
					klon._messwertTypZustaende = getMesswertTypZustaende().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
