/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Status für UFD Messwerte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class AttMesswertStatus extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttMesswertStatus ZUSTAND_0_ERFASST = new AttMesswertStatus("Erfasst", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttMesswertStatus ZUSTAND_1_ERSETZT = new AttMesswertStatus("Ersetzt", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttMesswertStatus ZUSTAND_2_FORTGESCHRIEBEN = new AttMesswertStatus("Fortgeschrieben", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttMesswertStatus ZUSTAND_3_ERRECHNET = new AttMesswertStatus("Errechnet", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttMesswertStatus ZUSTAND_4_FREI_DEFINIERT = new AttMesswertStatus("Frei Definiert", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttMesswertStatus ZUSTAND_1N_UNGUELTIG = new AttMesswertStatus("Ungültig", 		Byte
	.valueOf("-1"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttMesswertStatus getZustand(final 		Byte
	 value) {
		for (AttMesswertStatus e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttMesswertStatus getZustand(final String value) {
		for (AttMesswertStatus e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttMesswertStatus> getZustaende() {
		List<AttMesswertStatus> list = new ArrayList<AttMesswertStatus>();
		list.add(ZUSTAND_0_ERFASST);
		list.add(ZUSTAND_1_ERSETZT);
		list.add(ZUSTAND_2_FORTGESCHRIEBEN);
		list.add(ZUSTAND_3_ERRECHNET);
		list.add(ZUSTAND_4_FREI_DEFINIERT);
		list.add(ZUSTAND_1N_UNGUELTIG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut MesswertStatus.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttMesswertStatus(final 		Byte
	 value) {
		super(value);
	}
	
	private AttMesswertStatus(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
