/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt eine SWIS Rechnerzentrale.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public interface SwisRz extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.swis.rz"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Allgemeine Parameter einer SWIS Rechnerzentrale.
	<p>
	
	</p>
	@return der Datensatz ParameterSwisRz.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterSwisRz getPdParameterSwisRz();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Zu einer SWIS-RZ gehörende Meistereien.
	<p>
	
	</p>
	@return der Datensatz Meistereien.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdMeistereien getPdMeistereien();
	
	/**
	Parameter, der die letzte versandte Benachrichtigung
						enthält.
	<p>
	
	</p>
	@return der Datensatz ParameterLetzteBenachrichtigung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterLetzteBenachrichtigung getPdParameterLetzteBenachrichtigung();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Beschreibung aller Winterdienststatus, die eine, zu dieser
						SWIS RZ gehörende Meisterei
						einnehmen kann.
	<p>
	
	</p>
	@return der Datensatz ParameterMoeglicheWinterdienstStatus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterMoeglicheWinterdienstStatus getPdParameterMoeglicheWinterdienstStatus();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Liste aller Empfänger von SWIS Benachrichtigungen.
	<p>
	
	</p>
	@return der Datensatz ParameterListeDerEmpfaenger.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterListeDerEmpfaenger getPdParameterListeDerEmpfaenger();
	
	/**
	Beschreibung aller bekannten Messwerttypen inkl. Einheit,
						Abk. usw. für einen Messwert
						einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz ParameterMesswertTypen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterMesswertTypen getPdParameterMesswertTypen();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
