/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine SWIS Wetterstation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public interface Wetterstation extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.wetterstation"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der Atmosphärensensoren dieser Wetterstation.
<p>

</p>

@return die Menge AtmosphaerenSensoren oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getAtmosphaerenSensoren();

/**
Menge der Umfelddatensensoren an Sensor 2 dieser
					Wetterstation.
<p>

</p>

@return die Menge BodenSensoren2 oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getBodenSensoren2();

/**
Menge der Umfelddatensensoren an Sensor 1 dieser
					Wetterstation.
<p>

</p>

@return die Menge BodenSensoren1 oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getBodenSensoren1();

/**
Menge der Umfelddatensensoren an Sensor 3 dieser
					Wetterstation.
<p>

</p>

@return die Menge BodenSensoren3 oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getBodenSensoren3();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Parameter für Algorithmen, die mit Salzmenge&#47;Salzkonzentration und Restsalz arbeiten.
	<p>
	Die Parameter werden für die Prognose von Salzmengen, Gefriertemperatur und daraus resultierend
					zur Bewertung des Fahrbahnzustandes benutzt, außerdem bei der Errechnung bzw. Fortschreibung der Salzmenge
					im Rahmen der Datenaufbereitung.
	</p>
	@return der Datensatz ParameterSalzwerte.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterSalzwerte getPdParameterSalzwerte();
	
	/**
	Parameter mit diversen Grenzwerten bezüglich Feuchtigkeit auf der Fahrbahn.
	<p>
	&lt;absatz&gt;Dieser Parametersatz beinhaltet diverse Grenzwerte bezüglich Feuchtigkeit auf der Fahrbahn,
						die für die Prognose von Wasserfilmdicke und daraus resultierend des Fahrbahnzustandes
						benutzt werden.&lt;&#47;absatz&gt;
						&lt;absatz&gt;Sie finden aber auch bei der Datenaufbereitung UDE Verwendung, u.a. bei der
						Korrektur des Fahrbahnzustandes.&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ParameterWFDFBZ.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterWFDFBZ getPdParameterWFDFBZ();
	
	/**
	Parameter für die Messwertfortschreibung im Rahmen der Datenaufbereitung an einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz ParameterFortschreibung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterFortschreibung getPdParameterFortschreibung();
	
	/**
	Parameter für die Datenaufbereitung des Fahrbahnzustands an einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz ParameterDatenaufbereitungFBZ.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungFBZ getPdParameterDatenaufbereitungFBZ();
	
	/**
	Parameter einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz WetterstationParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdWetterstationParameter getPdWetterstationParameter();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Parameter für die Aufbereitung der Zeitreserve Glätte an einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz ParameterDatenaufbereitungZeitreserveGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungZeitreserveGlaette getPdParameterDatenaufbereitungZeitreserveGlaette();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter für die Datenaufbereitung der Niederschlagsart an einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz ParameterDatenaufbereitungNS.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungNS getPdParameterDatenaufbereitungNS();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Allgemeine Parameter für die Prognose, u.a. der Prognosehorizont.
	<p>
	
	</p>
	@return der Datensatz ParameterPrognoseAllgemein.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterPrognoseAllgemein getPdParameterPrognoseAllgemein();
	
	/**
	Liste aller aktuellen Warnungen und Alarme einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz WetterstationAlarmstatus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdWetterstationAlarmstatus getOdWetterstationAlarmstatus();
	
	/**
	Die Messwerte einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz Messwerte.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdMesswerte getOdMesswerte();
	
	/**
	Enthält die Parameter für die Glättewarnung und Alarmierung einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz ParameterGlaettewarnungUndAlarmierung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterGlaettewarnungUndAlarmierung getPdParameterGlaettewarnungUndAlarmierung();
	
	/**
	Parameter für die Gesamtprognose.
	<p>
	
	</p>
	@return der Datensatz ParameterGesamtprognose.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterGesamtprognose getPdParameterGesamtprognose();
	
	/**
	Status einer Wetterstation.
	<p>
	
	</p>
	@return der Datensatz Wetterstationstatus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdWetterstationstatus getOdWetterstationstatus();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
