/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine SWIS Wetterstation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class WetterstationImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.Wetterstation { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public WetterstationImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public WetterstationImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein Wetterstation.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> atmosphaerenSensoren;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getAtmosphaerenSensoren() {
		if (atmosphaerenSensoren == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("AtmosphaerenSensoren") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("AtmosphaerenSensoren").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor) getObjektFactory().getModellobjekt(so));
			}
			atmosphaerenSensoren = Collections.unmodifiableCollection(menge);
		}
		return atmosphaerenSensoren;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> bodenSensoren2;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getBodenSensoren2() {
		if (bodenSensoren2 == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("BodenSensoren2") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("BodenSensoren2").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor) getObjektFactory().getModellobjekt(so));
			}
			bodenSensoren2 = Collections.unmodifiableCollection(menge);
		}
		return bodenSensoren2;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> bodenSensoren1;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getBodenSensoren1() {
		if (bodenSensoren1 == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("BodenSensoren1") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("BodenSensoren1").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor) getObjektFactory().getModellobjekt(so));
			}
			bodenSensoren1 = Collections.unmodifiableCollection(menge);
		}
		return bodenSensoren1;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> bodenSensoren3;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> getBodenSensoren3() {
		if (bodenSensoren3 == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("BodenSensoren3") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("BodenSensoren3").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor) getObjektFactory().getModellobjekt(so));
			}
			bodenSensoren3 = Collections.unmodifiableCollection(menge);
		}
		return bodenSensoren3;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterSalzwerte getPdParameterSalzwerte() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterSalzwerte.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterWFDFBZ getPdParameterWFDFBZ() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterWFDFBZ.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterFortschreibung getPdParameterFortschreibung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterFortschreibung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungFBZ getPdParameterDatenaufbereitungFBZ() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungFBZ.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdWetterstationParameter getPdWetterstationParameter() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdWetterstationParameter.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungZeitreserveGlaette getPdParameterDatenaufbereitungZeitreserveGlaette() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungZeitreserveGlaette.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungNS getPdParameterDatenaufbereitungNS() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterDatenaufbereitungNS.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterPrognoseAllgemein getPdParameterPrognoseAllgemein() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterPrognoseAllgemein.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdWetterstationAlarmstatus getOdWetterstationAlarmstatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdWetterstationAlarmstatus.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdMesswerte getOdMesswerte() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdMesswerte.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterGlaettewarnungUndAlarmierung getPdParameterGlaettewarnungUndAlarmierung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterGlaettewarnungUndAlarmierung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterGesamtprognose getPdParameterGesamtprognose() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter.PdParameterGesamtprognose.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdWetterstationstatus getOdWetterstationstatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten.OdWetterstationstatus.class); 
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
