/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Status einer Wetterstation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 54
 */
public class OdWetterstationstatus extends AbstractOnlineDatensatz<OdWetterstationstatus.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Empfangen,
				};
			}
	
			/**
			 * Empfangene Daten.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Empfangen = new Aspekte("Empfangen", "asp.empfangen");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttStoerungsStatus
				 _stoerungsStatus
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlStoerungsMeldungen
				> _stoerungsMeldungen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlStoerungsMeldungen
				>(0, true);
		
			/**
			Störungsstatus einer Wetterstation.
			<p>
			
			</p>
			
			@return der Wert von StoerungsStatus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttStoerungsStatus
				 getStoerungsStatus() {
				return _stoerungsStatus;
			}
		
			/**
			Störungsstatus einer Wetterstation.
			<p>
			
			</p>
			
			@param _stoerungsStatus der neue Wert von StoerungsStatus.
			*/
			public void setStoerungsStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttStoerungsStatus
			 _stoerungsStatus) {
				this._stoerungsStatus = _stoerungsStatus;
			}
		
			/**
			List der Störungsmeldungen der Wetterstation (DE-Fehler).
			<p>
			
			</p>
			
			@return der Wert von StoerungsMeldungen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlStoerungsMeldungen
				> getStoerungsMeldungen() {
				return _stoerungsMeldungen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStoerungsStatus() != null) {
		                if (getStoerungsStatus().isZustand()) {
		                    datum.getUnscaledValue("stoerungsStatus").setText(getStoerungsStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("stoerungsStatus").set(getStoerungsStatus().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayStoerungsMeldungen = datum.getArray("stoerungsMeldungen");
						arrayStoerungsMeldungen.setLength(getStoerungsMeldungen().size());
						for (int i = 0; i < arrayStoerungsMeldungen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlStoerungsMeldungen
							 atl = getStoerungsMeldungen().get(i);
							atl.bean2Atl(arrayStoerungsMeldungen.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("stoerungsStatus").isState()) {
								setStoerungsStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttStoerungsStatus
								.getZustand(daten.getScaledValue("stoerungsStatus").getText()));
							} else {
							setStoerungsStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttStoerungsStatus
							(daten.
								getUnscaledValue
							("stoerungsStatus").
									byteValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayStoerungsMeldungen = daten.getArray("stoerungsMeldungen");
						for (int i = 0; i < arrayStoerungsMeldungen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlStoerungsMeldungen
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlStoerungsMeldungen
							 ();
							atl.atl2Bean(arrayStoerungsMeldungen.getItem(i), factory);
							getStoerungsMeldungen().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStoerungsStatus(getStoerungsStatus());
						klon._stoerungsMeldungen = getStoerungsMeldungen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.wetterstationstatus";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdWetterstationstatus(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
