/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die Datenaufbereitung des Fahrbahnzustands an einer Wetterstation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 37
 */
public class PdParameterDatenaufbereitungFBZ extends AbstractParameterDatensatz<PdParameterDatenaufbereitungFBZ.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 _untererSchwellwertWFD
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 _obererSchwellwertWFD
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
				 _schwellwertFBT
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@return der Wert von UntererSchwellwertWFD.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 getUntererSchwellwertWFD() {
				return _untererSchwellwertWFD;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@param _untererSchwellwertWFD der neue Wert von UntererSchwellwertWFD.
			*/
			public void setUntererSchwellwertWFD(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			 _untererSchwellwertWFD) {
				this._untererSchwellwertWFD = _untererSchwellwertWFD;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@return der Wert von ObererSchwellwertWFD.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 getObererSchwellwertWFD() {
				return _obererSchwellwertWFD;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@param _obererSchwellwertWFD der neue Wert von ObererSchwellwertWFD.
			*/
			public void setObererSchwellwertWFD(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			 _obererSchwellwertWFD) {
				this._obererSchwellwertWFD = _obererSchwellwertWFD;
			}
		
			/**
			Temperatur der Oberfläche der Fahrbahn.
			<p>
			Werden andere Zustände an der Oberfläche (z.B. Benetzung) erfasst, so muss die Oberflächentemperatur in örtlichen Bezug zu diesen Größen stehen. Die Fahrbahnoberflächentemperatur wird in Grad Celsius angegeben. Es wird der IST-Wert übertragen.
			</p>
			
			@return der Wert von SchwellwertFBT.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
				 getSchwellwertFBT() {
				return _schwellwertFBT;
			}
		
			/**
			Temperatur der Oberfläche der Fahrbahn.
			<p>
			Werden andere Zustände an der Oberfläche (z.B. Benetzung) erfasst, so muss die Oberflächentemperatur in örtlichen Bezug zu diesen Größen stehen. Die Fahrbahnoberflächentemperatur wird in Grad Celsius angegeben. Es wird der IST-Wert übertragen.
			</p>
			
			@param _schwellwertFBT der neue Wert von SchwellwertFBT.
			*/
			public void setSchwellwertFBT(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
			 _schwellwertFBT) {
				this._schwellwertFBT = _schwellwertFBT;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getUntererSchwellwertWFD() != null) {
		                if (getUntererSchwellwertWFD().isZustand()) {
		                    datum.getUnscaledValue("UntererSchwellwertWFD").setText(getUntererSchwellwertWFD().toString());
		                } else {
							datum.
							getScaledValue
		                	("UntererSchwellwertWFD").set(getUntererSchwellwertWFD().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getObererSchwellwertWFD() != null) {
		                if (getObererSchwellwertWFD().isZustand()) {
		                    datum.getUnscaledValue("ObererSchwellwertWFD").setText(getObererSchwellwertWFD().toString());
		                } else {
							datum.
							getScaledValue
		                	("ObererSchwellwertWFD").set(getObererSchwellwertWFD().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSchwellwertFBT() != null) {
		                if (getSchwellwertFBT().isZustand()) {
		                    datum.getUnscaledValue("SchwellwertFBT").setText(getSchwellwertFBT().toString());
		                } else {
							datum.
							getScaledValue
		                	("SchwellwertFBT").set(getSchwellwertFBT().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("UntererSchwellwertWFD").isState()) {
								setUntererSchwellwertWFD(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
								.getZustand(daten.getScaledValue("UntererSchwellwertWFD").getText()));
							} else {
							setUntererSchwellwertWFD(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
							(daten.
								getScaledValue
							("UntererSchwellwertWFD").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ObererSchwellwertWFD").isState()) {
								setObererSchwellwertWFD(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
								.getZustand(daten.getScaledValue("ObererSchwellwertWFD").getText()));
							} else {
							setObererSchwellwertWFD(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
							(daten.
								getScaledValue
							("ObererSchwellwertWFD").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchwellwertFBT").isState()) {
								setSchwellwertFBT(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
								.getZustand(daten.getScaledValue("SchwellwertFBT").getText()));
							} else {
							setSchwellwertFBT(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsFahrBahnOberFlaechenTemperatur
							(daten.
								getScaledValue
							("SchwellwertFBT").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setUntererSchwellwertWFD(getUntererSchwellwertWFD());
							klon.setObererSchwellwertWFD(getObererSchwellwertWFD());
							klon.setSchwellwertFBT(getSchwellwertFBT());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parameterDatenaufbereitungFBZ";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdParameterDatenaufbereitungFBZ(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
