/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für Algorithmen, die mit Salzmenge&#47;Salzkonzentration und Restsalz arbeiten.
<p>
Die Parameter werden für die Prognose von Salzmengen, Gefriertemperatur und daraus resultierend
				zur Bewertung des Fahrbahnzustandes benutzt, außerdem bei der Errechnung bzw. Fortschreibung der Salzmenge
				im Rahmen der Datenaufbereitung.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 37
 */
public class PdParameterSalzwerte extends AbstractParameterDatensatz<PdParameterSalzwerte.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				@Defaultwert(wert = "22,36")
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
				 _sKmax
				;
				@Defaultwert(wert = "998")
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _dW0
				;
				@Defaultwert(wert = "1173")
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _dW23
				;
				@Defaultwert(wert = "0,005")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
				 _rueckgangsFaktorSM
				;
				@Defaultwert(wert = "2 %")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
				 _abbruchKonzentration
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlGtRsStuetzstelle
				> _gTRSStuetzkurve = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlGtRsStuetzstelle
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Positve Zahl mit 2 Nachkommastellen (z.B. für Parameter).
			<p>
			
			</p>
			
			@return der Wert von SKmax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
				 getSKmax() {
				return _sKmax;
			}
		
			/**
			Positve Zahl mit 2 Nachkommastellen (z.B. für Parameter).
			<p>
			
			</p>
			
			@param _sKmax der neue Wert von SKmax.
			*/
			public void setSKmax(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _sKmax) {
				this._sKmax = _sKmax;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von DW0.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getDW0() {
				return _dW0;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _dW0 der neue Wert von DW0.
			*/
			public void setDW0(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _dW0) {
				this._dW0 = _dW0;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von DW23.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getDW23() {
				return _dW23;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _dW23 der neue Wert von DW23.
			*/
			public void setDW23(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _dW23) {
				this._dW23 = _dW23;
			}
		
			/**
			Positve oder negative Zahl mit 4 Nachkommastellen.
			<p>
			
			</p>
			
			@return der Wert von RueckgangsFaktorSM.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
				 getRueckgangsFaktorSM() {
				return _rueckgangsFaktorSM;
			}
		
			/**
			Positve oder negative Zahl mit 4 Nachkommastellen.
			<p>
			
			</p>
			
			@param _rueckgangsFaktorSM der neue Wert von RueckgangsFaktorSM.
			*/
			public void setRueckgangsFaktorSM(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
			 _rueckgangsFaktorSM) {
				this._rueckgangsFaktorSM = _rueckgangsFaktorSM;
			}
		
			/**
			Restsalz.
			<p>
			Sättigungsgrad des gelösten Salzes auf der Fahrbahn (bzw. auf der Fahrbahnsensorik). SR wird in Prozent (%) angegeben. Es wird der IST-Wert übertragen.
			</p>
			
			@return der Wert von AbbruchKonzentration.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
				 getAbbruchKonzentration() {
				return _abbruchKonzentration;
			}
		
			/**
			Restsalz.
			<p>
			Sättigungsgrad des gelösten Salzes auf der Fahrbahn (bzw. auf der Fahrbahnsensorik). SR wird in Prozent (%) angegeben. Es wird der IST-Wert übertragen.
			</p>
			
			@param _abbruchKonzentration der neue Wert von AbbruchKonzentration.
			*/
			public void setAbbruchKonzentration(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
			 _abbruchKonzentration) {
				this._abbruchKonzentration = _abbruchKonzentration;
			}
		
			/**
			Stützstelle der Stützkurve, welche aus dem Restsalzgehalt die Gefriertemperatur ermittelt.
			<p>
			
			</p>
			
			@return der Wert von GTRSStuetzkurve.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlGtRsStuetzstelle
				> getGTRSStuetzkurve() {
				return _gTRSStuetzkurve;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getSKmax() != null) {
		                if (getSKmax().isZustand()) {
		                    datum.getUnscaledValue("SKmax").setText(getSKmax().toString());
		                } else {
							datum.
							getScaledValue
		                	("SKmax").set(getSKmax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDW0() != null) {
		                if (getDW0().isZustand()) {
		                    datum.getUnscaledValue("dW0").setText(getDW0().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("dW0").set(getDW0().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDW23() != null) {
		                if (getDW23().isZustand()) {
		                    datum.getUnscaledValue("dW23").setText(getDW23().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("dW23").set(getDW23().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRueckgangsFaktorSM() != null) {
		                if (getRueckgangsFaktorSM().isZustand()) {
		                    datum.getUnscaledValue("RückgangsFaktorSM").setText(getRueckgangsFaktorSM().toString());
		                } else {
							datum.
							getScaledValue
		                	("RückgangsFaktorSM").set(getRueckgangsFaktorSM().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbbruchKonzentration() != null) {
		                if (getAbbruchKonzentration().isZustand()) {
		                    datum.getUnscaledValue("AbbruchKonzentration").setText(getAbbruchKonzentration().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbbruchKonzentration").set(getAbbruchKonzentration().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayGTRSStuetzkurve = datum.getArray("GT_RS_Stützkurve");
						arrayGTRSStuetzkurve.setLength(getGTRSStuetzkurve().size());
						for (int i = 0; i < arrayGTRSStuetzkurve.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlGtRsStuetzstelle
							 atl = getGTRSStuetzkurve().get(i);
							atl.bean2Atl(arrayGTRSStuetzkurve.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							setSKmax(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
							(daten.
								getScaledValue
							("SKmax").
								doubleValue
							()));
					// GanzzahlAttributTyp
							setDW0(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("dW0").
									longValue
							()));
					// GanzzahlAttributTyp
							setDW23(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("dW23").
									longValue
							()));
					// GanzzahlAttributTyp
							setRueckgangsFaktorSM(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
							(daten.
								getScaledValue
							("RückgangsFaktorSM").
								doubleValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AbbruchKonzentration").isState()) {
								setAbbruchKonzentration(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
								.getZustand(daten.getScaledValue("AbbruchKonzentration").getText()));
							} else {
							setAbbruchKonzentration(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRestSalz
							(daten.
								getUnscaledValue
							("AbbruchKonzentration").
									shortValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayGTRSStuetzkurve = daten.getArray("GT_RS_Stützkurve");
						for (int i = 0; i < arrayGTRSStuetzkurve.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlGtRsStuetzstelle
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlGtRsStuetzstelle
							 ();
							atl.atl2Bean(arrayGTRSStuetzkurve.getItem(i), factory);
							getGTRSStuetzkurve().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setSKmax(getSKmax());
							klon.setDW0(getDW0());
							klon.setDW23(getDW23());
							klon.setRueckgangsFaktorSM(getRueckgangsFaktorSM());
							klon.setAbbruchKonzentration(getAbbruchKonzentration());
						klon._gTRSStuetzkurve = getGTRSStuetzkurve().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parameterSalzwerte";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdParameterSalzwerte(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
