/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter mit diversen Grenzwerten bezüglich Feuchtigkeit auf der Fahrbahn.
<p>
&lt;absatz&gt;Dieser Parametersatz beinhaltet diverse Grenzwerte bezüglich Feuchtigkeit auf der Fahrbahn,
					die für die Prognose von Wasserfilmdicke und daraus resultierend des Fahrbahnzustandes
					benutzt werden.&lt;&#47;absatz&gt;
					&lt;absatz&gt;Sie finden aber auch bei der Datenaufbereitung UDE Verwendung, u.a. bei der
					Korrektur des Fahrbahnzustandes.&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 48
 */
public class PdParameterWFDFBZ extends AbstractParameterDatensatz<PdParameterWFDFBZ.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				@Defaultwert(wert = "0,5 mm")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 _schwellwertpNM
				;
				@Defaultwert(wert = "1 mm/h")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
				 _schwellwertNI
				;
				@Defaultwert(wert = "95 %rF")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 _schwellwertRLF
				;
				@Defaultwert(wert = "0,005")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
				 _rueckgangsFaktorWFD
				;
				@Defaultwert(wert = "0,03 mm")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 _schwellwertWFDTrockenFeucht
				;
				@Defaultwert(wert = "0,1 mm")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 _schwellwertWFDFeuchtNass
				;
				@Defaultwert(wert = "0,05 mm")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 _schwellenwertWFDGlaettegefahrGlaette
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@return der Wert von SchwellwertpNM.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 getSchwellwertpNM() {
				return _schwellwertpNM;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@param _schwellwertpNM der neue Wert von SchwellwertpNM.
			*/
			public void setSchwellwertpNM(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			 _schwellwertpNM) {
				this._schwellwertpNM = _schwellwertpNM;
			}
		
			/**
			Niederschlagsart Regen&#47;Schnee (alte Anlagen).
			<p>
			
			</p>
			
			@return der Wert von SchwellwertNI.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
				 getSchwellwertNI() {
				return _schwellwertNI;
			}
		
			/**
			Niederschlagsart Regen&#47;Schnee (alte Anlagen).
			<p>
			
			</p>
			
			@param _schwellwertNI der neue Wert von SchwellwertNI.
			*/
			public void setSchwellwertNI(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
			 _schwellwertNI) {
				this._schwellwertNI = _schwellwertNI;
			}
		
			/**
			Relative Luftfeuchte der in Nähe der Fahrbahnmessstelle befindlichen Umgebungsluft.
			<p>
			Relative Luftfeuchte der in Nähe der Fahrbahnmessstelle befindlichen Umgebungsluft. Messung muss weitgehend unbeeinflusst von direkter Sonneneinstrahlung und Windeinwirkung sein. Die Rel. Feuchte sollte immer an der gleichen Stelle gemessen werden wie die Lufttemperatur (DE-Typ 48). Es wird der IST-Wert übertragen.
			</p>
			
			@return der Wert von SchwellwertRLF.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 getSchwellwertRLF() {
				return _schwellwertRLF;
			}
		
			/**
			Relative Luftfeuchte der in Nähe der Fahrbahnmessstelle befindlichen Umgebungsluft.
			<p>
			Relative Luftfeuchte der in Nähe der Fahrbahnmessstelle befindlichen Umgebungsluft. Messung muss weitgehend unbeeinflusst von direkter Sonneneinstrahlung und Windeinwirkung sein. Die Rel. Feuchte sollte immer an der gleichen Stelle gemessen werden wie die Lufttemperatur (DE-Typ 48). Es wird der IST-Wert übertragen.
			</p>
			
			@param _schwellwertRLF der neue Wert von SchwellwertRLF.
			*/
			public void setSchwellwertRLF(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
			 _schwellwertRLF) {
				this._schwellwertRLF = _schwellwertRLF;
			}
		
			/**
			Positve oder negative Zahl mit 4 Nachkommastellen.
			<p>
			
			</p>
			
			@return der Wert von RueckgangsFaktorWFD.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
				 getRueckgangsFaktorWFD() {
				return _rueckgangsFaktorWFD;
			}
		
			/**
			Positve oder negative Zahl mit 4 Nachkommastellen.
			<p>
			
			</p>
			
			@param _rueckgangsFaktorWFD der neue Wert von RueckgangsFaktorWFD.
			*/
			public void setRueckgangsFaktorWFD(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
			 _rueckgangsFaktorWFD) {
				this._rueckgangsFaktorWFD = _rueckgangsFaktorWFD;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@return der Wert von SchwellwertWFDTrockenFeucht.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 getSchwellwertWFDTrockenFeucht() {
				return _schwellwertWFDTrockenFeucht;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@param _schwellwertWFDTrockenFeucht der neue Wert von SchwellwertWFDTrockenFeucht.
			*/
			public void setSchwellwertWFDTrockenFeucht(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			 _schwellwertWFDTrockenFeucht) {
				this._schwellwertWFDTrockenFeucht = _schwellwertWFDTrockenFeucht;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@return der Wert von SchwellwertWFDFeuchtNass.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 getSchwellwertWFDFeuchtNass() {
				return _schwellwertWFDFeuchtNass;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@param _schwellwertWFDFeuchtNass der neue Wert von SchwellwertWFDFeuchtNass.
			*/
			public void setSchwellwertWFDFeuchtNass(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			 _schwellwertWFDFeuchtNass) {
				this._schwellwertWFDFeuchtNass = _schwellwertWFDFeuchtNass;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@return der Wert von SchwellenwertWFDGlaettegefahrGlaette.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
				 getSchwellenwertWFDGlaettegefahrGlaette() {
				return _schwellenwertWFDGlaettegefahrGlaette;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD oberhalb 2 mm liegt die Messgenauigkeit in der Regel im mm Bereich. Die rechnerische Wasserfilmdicke gibt die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser oder wässriger Lösung (Salzgemisch) an, welche sich am Messort bzw. auf der in der Fahrbahn eingelassenen Sonde befindet. Die Wasserfilmdicke ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@param _schwellenwertWFDGlaettegefahrGlaette der neue Wert von SchwellenwertWFDGlaettegefahrGlaette.
			*/
			public void setSchwellenwertWFDGlaettegefahrGlaette(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
			 _schwellenwertWFDGlaettegefahrGlaette) {
				this._schwellenwertWFDGlaettegefahrGlaette = _schwellenwertWFDGlaettegefahrGlaette;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getSchwellwertpNM() != null) {
		                if (getSchwellwertpNM().isZustand()) {
		                    datum.getUnscaledValue("SchwellwertpNM").setText(getSchwellwertpNM().toString());
		                } else {
							datum.
							getScaledValue
		                	("SchwellwertpNM").set(getSchwellwertpNM().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSchwellwertNI() != null) {
		                if (getSchwellwertNI().isZustand()) {
		                    datum.getUnscaledValue("SchwellwertNI").setText(getSchwellwertNI().toString());
		                } else {
							datum.
							getScaledValue
		                	("SchwellwertNI").set(getSchwellwertNI().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSchwellwertRLF() != null) {
		                if (getSchwellwertRLF().isZustand()) {
		                    datum.getUnscaledValue("SchwellwertRLF").setText(getSchwellwertRLF().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SchwellwertRLF").set(getSchwellwertRLF().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRueckgangsFaktorWFD() != null) {
		                if (getRueckgangsFaktorWFD().isZustand()) {
		                    datum.getUnscaledValue("RückgangsFaktorWFD").setText(getRueckgangsFaktorWFD().toString());
		                } else {
							datum.
							getScaledValue
		                	("RückgangsFaktorWFD").set(getRueckgangsFaktorWFD().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSchwellwertWFDTrockenFeucht() != null) {
		                if (getSchwellwertWFDTrockenFeucht().isZustand()) {
		                    datum.getUnscaledValue("SchwellwertWFDTrockenFeucht").setText(getSchwellwertWFDTrockenFeucht().toString());
		                } else {
							datum.
							getScaledValue
		                	("SchwellwertWFDTrockenFeucht").set(getSchwellwertWFDTrockenFeucht().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSchwellwertWFDFeuchtNass() != null) {
		                if (getSchwellwertWFDFeuchtNass().isZustand()) {
		                    datum.getUnscaledValue("SchwellwertWFDFeuchtNass").setText(getSchwellwertWFDFeuchtNass().toString());
		                } else {
							datum.
							getScaledValue
		                	("SchwellwertWFDFeuchtNass").set(getSchwellwertWFDFeuchtNass().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSchwellenwertWFDGlaettegefahrGlaette() != null) {
		                if (getSchwellenwertWFDGlaettegefahrGlaette().isZustand()) {
		                    datum.getUnscaledValue("SchwellenwertWFDGlättegefahrGlätte").setText(getSchwellenwertWFDGlaettegefahrGlaette().toString());
		                } else {
							datum.
							getScaledValue
		                	("SchwellenwertWFDGlättegefahrGlätte").set(getSchwellenwertWFDGlaettegefahrGlaette().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchwellwertpNM").isState()) {
								setSchwellwertpNM(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
								.getZustand(daten.getScaledValue("SchwellwertpNM").getText()));
							} else {
							setSchwellwertpNM(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
							(daten.
								getScaledValue
							("SchwellwertpNM").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchwellwertNI").isState()) {
								setSchwellwertNI(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
								.getZustand(daten.getScaledValue("SchwellwertNI").getText()));
							} else {
							setSchwellwertNI(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
							(daten.
								getScaledValue
							("SchwellwertNI").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchwellwertRLF").isState()) {
								setSchwellwertRLF(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
								.getZustand(daten.getScaledValue("SchwellwertRLF").getText()));
							} else {
							setSchwellwertRLF(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
							(daten.
								getUnscaledValue
							("SchwellwertRLF").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setRueckgangsFaktorWFD(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
							(daten.
								getScaledValue
							("RückgangsFaktorWFD").
								doubleValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchwellwertWFDTrockenFeucht").isState()) {
								setSchwellwertWFDTrockenFeucht(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
								.getZustand(daten.getScaledValue("SchwellwertWFDTrockenFeucht").getText()));
							} else {
							setSchwellwertWFDTrockenFeucht(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
							(daten.
								getScaledValue
							("SchwellwertWFDTrockenFeucht").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchwellwertWFDFeuchtNass").isState()) {
								setSchwellwertWFDFeuchtNass(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
								.getZustand(daten.getScaledValue("SchwellwertWFDFeuchtNass").getText()));
							} else {
							setSchwellwertWFDFeuchtNass(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
							(daten.
								getScaledValue
							("SchwellwertWFDFeuchtNass").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchwellenwertWFDGlättegefahrGlätte").isState()) {
								setSchwellenwertWFDGlaettegefahrGlaette(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
								.getZustand(daten.getScaledValue("SchwellenwertWFDGlättegefahrGlätte").getText()));
							} else {
							setSchwellenwertWFDGlaettegefahrGlaette(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWasserFilmDicke
							(daten.
								getScaledValue
							("SchwellenwertWFDGlättegefahrGlätte").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setSchwellwertpNM(getSchwellwertpNM());
							klon.setSchwellwertNI(getSchwellwertNI());
							klon.setSchwellwertRLF(getSchwellwertRLF());
							klon.setRueckgangsFaktorWFD(getRueckgangsFaktorWFD());
							klon.setSchwellwertWFDTrockenFeucht(getSchwellwertWFDTrockenFeucht());
							klon.setSchwellwertWFDFeuchtNass(getSchwellwertWFDFeuchtNass());
							klon.setSchwellenwertWFDGlaettegefahrGlaette(getSchwellenwertWFDGlaettegefahrGlaette());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parameterWFDFBZ";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdParameterWFDFBZ(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
