/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter einer Wetterstation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 53
 */
public class PdWetterstationParameter extends AbstractParameterDatensatz<PdWetterstationParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _name
				= new String
				()
				;
				private String
				 _hersteller
				= new String
				()
				;
				private String
				 _verwaltungskennung
				= new String
				()
				;
				private String
				 _dwdKennung
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
				 _x
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
				 _y
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
				 _orientierung
				;
				private String
				 _fahrtRichtungBodensensor1
				= new String
				()
				;
				private String
				 _fahrtRichtungBodensensor2
				= new String
				()
				;
				private String
				 _fahrtRichtungBodensensor3
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlWetterstationBestandsdatum
				> _bestandsparameter = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlWetterstationBestandsdatum
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Hersteller.
			*/
				public String
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(String
			 _hersteller) {
				if (_hersteller.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._hersteller = _hersteller;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Verwaltungskennung.
			*/
				public String
				 getVerwaltungskennung() {
				return _verwaltungskennung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _verwaltungskennung der neue Wert von Verwaltungskennung.
			*/
			public void setVerwaltungskennung(String
			 _verwaltungskennung) {
				if (_verwaltungskennung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._verwaltungskennung = _verwaltungskennung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von DwdKennung.
			*/
				public String
				 getDwdKennung() {
				return _dwdKennung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _dwdKennung der neue Wert von DwdKennung.
			*/
			public void setDwdKennung(String
			 _dwdKennung) {
				if (_dwdKennung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._dwdKennung = _dwdKennung;
			}
		
			/**
			Längenangabe gemäß WGS84.
			<p>
			Für die Koordinatenangabe ist festgelegt: Für einen Punkt sind die WGS 84 Länge und Breite des (approximativen) Mittelpunktes des Ortes anzugeben (M), und zwar in Dezimalgraden mit einer Auflösung von 1 Mikro-grad, mit einem Pluszeichen (+) für östliche Länge und nördliche Breite und mit einem Minuszeichen (-) für westliche Länge und südliche Breite. Längengrade werden dreistellig (falls erforderlich mit führenden Nullen), Breitengrade zweistellig (falls erforderlich mit führenden Nullen) angegeben. Beispiel +004354551 +50839402 bedeutet 4°. 354551 O 50°. 839402 N
			</p>
			
			@return der Wert von X.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
				 getX() {
				return _x;
			}
		
			/**
			Längenangabe gemäß WGS84.
			<p>
			Für die Koordinatenangabe ist festgelegt: Für einen Punkt sind die WGS 84 Länge und Breite des (approximativen) Mittelpunktes des Ortes anzugeben (M), und zwar in Dezimalgraden mit einer Auflösung von 1 Mikro-grad, mit einem Pluszeichen (+) für östliche Länge und nördliche Breite und mit einem Minuszeichen (-) für westliche Länge und südliche Breite. Längengrade werden dreistellig (falls erforderlich mit führenden Nullen), Breitengrade zweistellig (falls erforderlich mit führenden Nullen) angegeben. Beispiel +004354551 +50839402 bedeutet 4°. 354551 O 50°. 839402 N
			</p>
			
			@param _x der neue Wert von X.
			*/
			public void setX(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
			 _x) {
				this._x = _x;
			}
		
			/**
			Breitenangabe gemäß WGS84.
			<p>
			Für die Koordinatenangabe ist festgelegt: Für einen Punkt sind die WGS 84 Länge und Breite des (approximativen) Mittelpunktes des Ortes anzugeben (M), und zwar in Dezimalgraden mit einer Auflösung von 1 Mikro-grad, mit einem Pluszeichen (+) für östliche Länge und nördliche Breite und mit einem Minuszeichen (-) für westliche Länge und südliche Breite. Längengrade werden dreistellig (falls erforderlich mit führenden Nullen), Breitengrade zweistellig (falls erforderlich mit führenden Nullen) angegeben. Beispiel +004354551 +50839402 bedeutet 4°. 354551 O 50°. 839402 N
			</p>
			
			@return der Wert von Y.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
				 getY() {
				return _y;
			}
		
			/**
			Breitenangabe gemäß WGS84.
			<p>
			Für die Koordinatenangabe ist festgelegt: Für einen Punkt sind die WGS 84 Länge und Breite des (approximativen) Mittelpunktes des Ortes anzugeben (M), und zwar in Dezimalgraden mit einer Auflösung von 1 Mikro-grad, mit einem Pluszeichen (+) für östliche Länge und nördliche Breite und mit einem Minuszeichen (-) für westliche Länge und südliche Breite. Längengrade werden dreistellig (falls erforderlich mit führenden Nullen), Breitengrade zweistellig (falls erforderlich mit führenden Nullen) angegeben. Beispiel +004354551 +50839402 bedeutet 4°. 354551 O 50°. 839402 N
			</p>
			
			@param _y der neue Wert von Y.
			*/
			public void setY(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
			 _y) {
				this._y = _y;
			}
		
			/**
			Positve oder negative Zahl mit 4 Nachkommastellen.
			<p>
			
			</p>
			
			@return der Wert von Orientierung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
				 getOrientierung() {
				return _orientierung;
			}
		
			/**
			Positve oder negative Zahl mit 4 Nachkommastellen.
			<p>
			
			</p>
			
			@param _orientierung der neue Wert von Orientierung.
			*/
			public void setOrientierung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
			 _orientierung) {
				this._orientierung = _orientierung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von FahrtRichtungBodensensor1.
			*/
				public String
				 getFahrtRichtungBodensensor1() {
				return _fahrtRichtungBodensensor1;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _fahrtRichtungBodensensor1 der neue Wert von FahrtRichtungBodensensor1.
			*/
			public void setFahrtRichtungBodensensor1(String
			 _fahrtRichtungBodensensor1) {
				if (_fahrtRichtungBodensensor1.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._fahrtRichtungBodensensor1 = _fahrtRichtungBodensensor1;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von FahrtRichtungBodensensor2.
			*/
				public String
				 getFahrtRichtungBodensensor2() {
				return _fahrtRichtungBodensensor2;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _fahrtRichtungBodensensor2 der neue Wert von FahrtRichtungBodensensor2.
			*/
			public void setFahrtRichtungBodensensor2(String
			 _fahrtRichtungBodensensor2) {
				if (_fahrtRichtungBodensensor2.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._fahrtRichtungBodensensor2 = _fahrtRichtungBodensensor2;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von FahrtRichtungBodensensor3.
			*/
				public String
				 getFahrtRichtungBodensensor3() {
				return _fahrtRichtungBodensensor3;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _fahrtRichtungBodensensor3 der neue Wert von FahrtRichtungBodensensor3.
			*/
			public void setFahrtRichtungBodensensor3(String
			 _fahrtRichtungBodensensor3) {
				if (_fahrtRichtungBodensensor3.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._fahrtRichtungBodensensor3 = _fahrtRichtungBodensensor3;
			}
		
			/**
			.
			<p>
			
			</p>
			
			@return der Wert von Bestandsparameter.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlWetterstationBestandsdatum
				> getBestandsparameter() {
				return _bestandsparameter;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("name").setText(getName());
					}
					// ZeichenkettenAttributTyp
					if (getHersteller() != null) {
						datum.getTextValue("hersteller").setText(getHersteller());
					}
					// ZeichenkettenAttributTyp
					if (getVerwaltungskennung() != null) {
						datum.getTextValue("verwaltungskennung").setText(getVerwaltungskennung());
					}
					// ZeichenkettenAttributTyp
					if (getDwdKennung() != null) {
						datum.getTextValue("dwdKennung").setText(getDwdKennung());
					}
					// GanzzahlAttributTyp
					if (getX() != null) {
		                if (getX().isZustand()) {
		                    datum.getUnscaledValue("x").setText(getX().toString());
		                } else {
							datum.
							getScaledValue
		                	("x").set(getX().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getY() != null) {
		                if (getY().isZustand()) {
		                    datum.getUnscaledValue("y").setText(getY().toString());
		                } else {
							datum.
							getScaledValue
		                	("y").set(getY().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getOrientierung() != null) {
		                if (getOrientierung().isZustand()) {
		                    datum.getUnscaledValue("orientierung").setText(getOrientierung().toString());
		                } else {
							datum.
							getScaledValue
		                	("orientierung").set(getOrientierung().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getFahrtRichtungBodensensor1() != null) {
						datum.getTextValue("fahrtRichtungBodensensor1").setText(getFahrtRichtungBodensensor1());
					}
					// ZeichenkettenAttributTyp
					if (getFahrtRichtungBodensensor2() != null) {
						datum.getTextValue("fahrtRichtungBodensensor2").setText(getFahrtRichtungBodensensor2());
					}
					// ZeichenkettenAttributTyp
					if (getFahrtRichtungBodensensor3() != null) {
						datum.getTextValue("fahrtRichtungBodensensor3").setText(getFahrtRichtungBodensensor3());
					}
					// AttributListenDefinition
						final Data.Array arrayBestandsparameter = datum.getArray("Bestandsparameter");
						arrayBestandsparameter.setLength(getBestandsparameter().size());
						for (int i = 0; i < arrayBestandsparameter.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlWetterstationBestandsdatum
							 atl = getBestandsparameter().get(i);
							atl.bean2Atl(arrayBestandsparameter.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("name").getText());
					// ZeichenkettenAttributTyp
						setHersteller(daten.getTextValue("hersteller").getText());
					// ZeichenkettenAttributTyp
						setVerwaltungskennung(daten.getTextValue("verwaltungskennung").getText());
					// ZeichenkettenAttributTyp
						setDwdKennung(daten.getTextValue("dwdKennung").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("x").isState()) {
								setX(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
								.getZustand(daten.getScaledValue("x").getText()));
							} else {
							setX(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
							(daten.
								getScaledValue
							("x").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("y").isState()) {
								setY(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
								.getZustand(daten.getScaledValue("y").getText()));
							} else {
							setY(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
							(daten.
								getScaledValue
							("y").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							setOrientierung(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
							(daten.
								getScaledValue
							("orientierung").
								doubleValue
							()));
					// ZeichenkettenAttributTyp
						setFahrtRichtungBodensensor1(daten.getTextValue("fahrtRichtungBodensensor1").getText());
					// ZeichenkettenAttributTyp
						setFahrtRichtungBodensensor2(daten.getTextValue("fahrtRichtungBodensensor2").getText());
					// ZeichenkettenAttributTyp
						setFahrtRichtungBodensensor3(daten.getTextValue("fahrtRichtungBodensensor3").getText());
					// AttributListenDefinition
						final Data.Array arrayBestandsparameter = daten.getArray("Bestandsparameter");
						for (int i = 0; i < arrayBestandsparameter.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlWetterstationBestandsdatum
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AtlWetterstationBestandsdatum
							 ();
							atl.atl2Bean(arrayBestandsparameter.getItem(i), factory);
							getBestandsparameter().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setName(getName());
							klon.setHersteller(getHersteller());
							klon.setVerwaltungskennung(getVerwaltungskennung());
							klon.setDwdKennung(getDwdKennung());
							klon.setX(getX());
							klon.setY(getY());
							klon.setOrientierung(getOrientierung());
							klon.setFahrtRichtungBodensensor1(getFahrtRichtungBodensensor1());
							klon.setFahrtRichtungBodensensor2(getFahrtRichtungBodensensor2());
							klon.setFahrtRichtungBodensensor3(getFahrtRichtungBodensensor3());
						klon._bestandsparameter = getBestandsparameter().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.wetterstationParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdWetterstationParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
