/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisbufr.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametrierung der zu exportierenden Wetterstationen und
					Messwerttypen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdAllgemeineBUFRExportParameter extends AbstractParameterDatensatz<PdAllgemeineBUFRExportParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _zielverzeichnis
				= new String
				()
				;
				private String
				 _cron
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisbufr.attribute.AtlBUFRExportWetterstation
				> _wetterstationen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisbufr.attribute.AtlBUFRExportWetterstation
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Zielverzeichnis.
			*/
				public String
				 getZielverzeichnis() {
				return _zielverzeichnis;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _zielverzeichnis der neue Wert von Zielverzeichnis.
			*/
			public void setZielverzeichnis(String
			 _zielverzeichnis) {
				if (_zielverzeichnis.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._zielverzeichnis = _zielverzeichnis;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Cron.
			*/
				public String
				 getCron() {
				return _cron;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _cron der neue Wert von Cron.
			*/
			public void setCron(String
			 _cron) {
				if (_cron.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._cron = _cron;
			}
		
			/**
			Beschreibt die MesswertTypen, die für einen Wetterstation
								exportiert werden sollen.
			<p>
			
			</p>
			
			@return der Wert von Wetterstationen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisbufr.attribute.AtlBUFRExportWetterstation
				> getWetterstationen() {
				return _wetterstationen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getZielverzeichnis() != null) {
						datum.getTextValue("zielverzeichnis").setText(getZielverzeichnis());
					}
					// ZeichenkettenAttributTyp
					if (getCron() != null) {
						datum.getTextValue("cron").setText(getCron());
					}
					// AttributListenDefinition
						final Data.Array arrayWetterstationen = datum.getArray("Wetterstationen");
						arrayWetterstationen.setLength(getWetterstationen().size());
						for (int i = 0; i < arrayWetterstationen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisbufr.attribute.AtlBUFRExportWetterstation
							 atl = getWetterstationen().get(i);
							atl.bean2Atl(arrayWetterstationen.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setZielverzeichnis(daten.getTextValue("zielverzeichnis").getText());
					// ZeichenkettenAttributTyp
						setCron(daten.getTextValue("cron").getText());
					// AttributListenDefinition
						final Data.Array arrayWetterstationen = daten.getArray("Wetterstationen");
						for (int i = 0; i < arrayWetterstationen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisbufr.attribute.AtlBUFRExportWetterstation
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisbufr.attribute.AtlBUFRExportWetterstation
							 ();
							atl.atl2Bean(arrayWetterstationen.getItem(i), factory);
							getWetterstationen().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setZielverzeichnis(getZielverzeichnis());
							klon.setCron(getCron());
						klon._wetterstationen = getWetterstationen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.allgemeineBUFRExportParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdAllgemeineBUFRExportParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
