/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Aktueller Download&#47;Upload- und Kommunikationszustand.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTransferZustand extends AbstractOnlineDatensatz<OdTransferZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Empfangen,
				};
			}
	
			/**
			 * Empfangene Daten.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Empfangen = new Aspekte("Empfangen", "asp.empfangen");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttKommunikationsZustand
				 _kommunikationsZustand
				;
				private String
				 _meldungstext
				= new String
				()
				;
		
			/**
			Mögliche Zustände einer Kommunikation.
			<p>
			
			</p>
			
			@return der Wert von KommunikationsZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttKommunikationsZustand
				 getKommunikationsZustand() {
				return _kommunikationsZustand;
			}
		
			/**
			Mögliche Zustände einer Kommunikation.
			<p>
			
			</p>
			
			@param _kommunikationsZustand der neue Wert von KommunikationsZustand.
			*/
			public void setKommunikationsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttKommunikationsZustand
			 _kommunikationsZustand) {
				this._kommunikationsZustand = _kommunikationsZustand;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Meldungstext.
			*/
				public String
				 getMeldungstext() {
				return _meldungstext;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _meldungstext der neue Wert von Meldungstext.
			*/
			public void setMeldungstext(String
			 _meldungstext) {
				if (_meldungstext.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._meldungstext = _meldungstext;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getKommunikationsZustand() != null) {
		                if (getKommunikationsZustand().isZustand()) {
		                    datum.getUnscaledValue("kommunikationsZustand").setText(getKommunikationsZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("kommunikationsZustand").set(getKommunikationsZustand().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getMeldungstext() != null) {
						datum.getTextValue("meldungstext").setText(getMeldungstext());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("kommunikationsZustand").isState()) {
								setKommunikationsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttKommunikationsZustand
								.getZustand(daten.getScaledValue("kommunikationsZustand").getText()));
							} else {
							setKommunikationsZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttKommunikationsZustand
							(daten.
								getUnscaledValue
							("kommunikationsZustand").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setMeldungstext(daten.getTextValue("meldungstext").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setKommunikationsZustand(getKommunikationsZustand());
							klon.setMeldungstext(getMeldungstext());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.transferZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTransferZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
