/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kombiniert einen Meß- bzw. Berechnungswert, der eine
					Anzahl belegter bzw. freier Stellplätze angibt, mit zusätzlichen
					Status- und Güteinformationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTurAnzahlStellplaetze implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _wert
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
			 _art
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
			 _korrektur
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatus
			 _status
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatus
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 _guete
			= new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			()
			;
	
		/**
		Definiert einen 32-Bit-Integertyp zur Darstellung der
							Anzahl von Stellplätzen.
		<p>
		Die Definition läßt bewußt negative Werte zu, da die
							Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
							negativ werden können. In Pilotprojekten und zur Verfeinerung der
							Parametrierung der Anlage müssen diese Werte auch archiviert und in
							Protokollen betrachtet werden können.
		</p>
		
		@return der Wert von Wert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 getWert() {
			return _wert;
		}
	
		/**
		Definiert einen 32-Bit-Integertyp zur Darstellung der
							Anzahl von Stellplätzen.
		<p>
		Die Definition läßt bewußt negative Werte zu, da die
							Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
							negativ werden können. In Pilotprojekten und zur Verfeinerung der
							Parametrierung der Anlage müssen diese Werte auch archiviert und in
							Protokollen betrachtet werden können.
		</p>
		
		@param _wert der neue Wert von Wert.
		*/
		public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
		 _wert) {
			this._wert = _wert;
		}
	
		/**
		Definiert, ob die verfügbaren oder die belegten
							Stellplätze einer Anlage gezählt &#47; errechnet &#47; gezeigt wurden bzw.
							werden.
		<p>
		Der Bediener soll so schnell, sicher und genau die Möglichkeit
							haben, die Anzahl verfügbarer Stellplätze in das System einzugeben.
							Deshalb werden grundsätzlich zwei Möglichkeiten vorgesehen:
							&lt;liste zeichen="punkt"&gt;
								&lt;listenPunkt&gt;
									&lt;wichtig&gt;Belegte Stellplätze:&lt;&#47;wichtig&gt;
									Bei geringer bzw. mittlerer Stellplatzauslastung ist es
									einfacher, die im Parkbereich befindlichen (wenigen) Fahrzeuge zu
									zählen.
								&lt;&#47;listenPunkt&gt;
								&lt;listenPunkt&gt;
									&lt;wichtig&gt;Freie Stellplätze:&lt;&#47;wichtig&gt;
									Bei hoher Stellplatzauslastung ist es einfacher, die (wenigen)
									freien Stellplätze zu zählen.
								&lt;&#47;listenPunkt&gt;
							&lt;&#47;liste&gt;
		</p>
		
		@return der Wert von Art.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
			 getArt() {
			return _art;
		}
	
		/**
		Definiert, ob die verfügbaren oder die belegten
							Stellplätze einer Anlage gezählt &#47; errechnet &#47; gezeigt wurden bzw.
							werden.
		<p>
		Der Bediener soll so schnell, sicher und genau die Möglichkeit
							haben, die Anzahl verfügbarer Stellplätze in das System einzugeben.
							Deshalb werden grundsätzlich zwei Möglichkeiten vorgesehen:
							&lt;liste zeichen="punkt"&gt;
								&lt;listenPunkt&gt;
									&lt;wichtig&gt;Belegte Stellplätze:&lt;&#47;wichtig&gt;
									Bei geringer bzw. mittlerer Stellplatzauslastung ist es
									einfacher, die im Parkbereich befindlichen (wenigen) Fahrzeuge zu
									zählen.
								&lt;&#47;listenPunkt&gt;
								&lt;listenPunkt&gt;
									&lt;wichtig&gt;Freie Stellplätze:&lt;&#47;wichtig&gt;
									Bei hoher Stellplatzauslastung ist es einfacher, die (wenigen)
									freien Stellplätze zu zählen.
								&lt;&#47;listenPunkt&gt;
							&lt;&#47;liste&gt;
		</p>
		
		@param _art der neue Wert von Art.
		*/
		public void setArt(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
		 _art) {
			this._art = _art;
		}
	
		/**
		Bestimmt, ob bei einer Korrektur über die Angabe freier
							Stellplätze der zugrunde liegende Zählwert oder die logische Anzahl
							freier Stellplätze angepasst werden soll bzw. wurde.
		<p>
		Der Bediener soll die Möglichkeit haben, Korrekturwerte anhand der
							konkreten Situation qualifizieren zu können.
							&lt;liste zeichen="punkt"&gt;
								&lt;listenPunkt&gt;
									&lt;wichtig&gt;Gezählt:&lt;&#47;wichtig&gt;
									Der Versand des Korrekturwertes soll eine Anpassung des aktuellen
									Rechenwertes der Auslastung zur Folge haben. Diese Option wählt
									der Bediener, wenn die Anzahl von Fahrzeugen aufgrund von
									Messungenauigkeiten der zugrunde liegenden Erfassungstechnik
									falsch bestimmt wurde oder ein Neustart der Anlage erfolgte.
								&lt;&#47;listenPunkt&gt;
								&lt;listenPunkt&gt;
									&lt;wichtig&gt;Logisch ermittelt:&lt;&#47;wichtig&gt;
									Der Versand des Korrekturwertes soll eine Anpassung des Wertes
									'Logische Kapazität' aus dem Parametersatz atg.turParameterAnlage
									am Anlagenobjekt zur Folge haben. Diese Option wählt der
									Bediener, wenn die Anzahl von Fahrzeugen im Parkbereich korrekt
									ist, die abgeleitete Anzahl verfügbarer Stellplätze aber trotzdem
									verkehrt ist. Dies kann der Fall sein, wenn:
									&lt;liste zeichen="punkt"&gt;
										&lt;listenPunkt&gt;Ein Lkw mehrere Parkbuchten benutzt (z.B. schräg
											steht)
										&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;Sich mehrere kleine Fahrzeuge (z.B. Sprinter) eine
											Parkbucht teilen
										&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;Sich eine der oben beschriebenen Situationen
											auflöst.
										&lt;&#47;listenPunkt&gt;
									&lt;&#47;liste&gt;
								&lt;&#47;listenPunkt&gt;
							&lt;&#47;liste&gt;
		</p>
		
		@return der Wert von Korrektur.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
			 getKorrektur() {
			return _korrektur;
		}
	
		/**
		Bestimmt, ob bei einer Korrektur über die Angabe freier
							Stellplätze der zugrunde liegende Zählwert oder die logische Anzahl
							freier Stellplätze angepasst werden soll bzw. wurde.
		<p>
		Der Bediener soll die Möglichkeit haben, Korrekturwerte anhand der
							konkreten Situation qualifizieren zu können.
							&lt;liste zeichen="punkt"&gt;
								&lt;listenPunkt&gt;
									&lt;wichtig&gt;Gezählt:&lt;&#47;wichtig&gt;
									Der Versand des Korrekturwertes soll eine Anpassung des aktuellen
									Rechenwertes der Auslastung zur Folge haben. Diese Option wählt
									der Bediener, wenn die Anzahl von Fahrzeugen aufgrund von
									Messungenauigkeiten der zugrunde liegenden Erfassungstechnik
									falsch bestimmt wurde oder ein Neustart der Anlage erfolgte.
								&lt;&#47;listenPunkt&gt;
								&lt;listenPunkt&gt;
									&lt;wichtig&gt;Logisch ermittelt:&lt;&#47;wichtig&gt;
									Der Versand des Korrekturwertes soll eine Anpassung des Wertes
									'Logische Kapazität' aus dem Parametersatz atg.turParameterAnlage
									am Anlagenobjekt zur Folge haben. Diese Option wählt der
									Bediener, wenn die Anzahl von Fahrzeugen im Parkbereich korrekt
									ist, die abgeleitete Anzahl verfügbarer Stellplätze aber trotzdem
									verkehrt ist. Dies kann der Fall sein, wenn:
									&lt;liste zeichen="punkt"&gt;
										&lt;listenPunkt&gt;Ein Lkw mehrere Parkbuchten benutzt (z.B. schräg
											steht)
										&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;Sich mehrere kleine Fahrzeuge (z.B. Sprinter) eine
											Parkbucht teilen
										&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;Sich eine der oben beschriebenen Situationen
											auflöst.
										&lt;&#47;listenPunkt&gt;
									&lt;&#47;liste&gt;
								&lt;&#47;listenPunkt&gt;
							&lt;&#47;liste&gt;
		</p>
		
		@param _korrektur der neue Wert von Korrektur.
		*/
		public void setKorrektur(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
		 _korrektur) {
			this._korrektur = _korrektur;
		}
	
		/**
		Statusinformationen zum Wert, der sich aus
								unterschiedlichen Zwischenberechnungen ergibt.
		<p>
		
		</p>
		
		@return der Wert von Status.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatus
			 getStatus() {
			return _status;
		}
	
		/**
		Statusinformationen zum Wert, der sich aus
								unterschiedlichen Zwischenberechnungen ergibt.
		<p>
		
		</p>
		
		@param _status der neue Wert von Status.
		*/
		public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlStatus
		 _status) {
			this._status = _status;
		}
	
		/**
		Güteinformationen zum Wert (Güte und Verfahren, welches
								zur Güteermittlung verwendet wurde).
		<p>
		
		</p>
		
		@return der Wert von Guete.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 getGuete() {
			return _guete;
		}
	
		/**
		Güteinformationen zum Wert (Güte und Verfahren, welches
								zur Güteermittlung verwendet wurde).
		<p>
		
		</p>
		
		@param _guete der neue Wert von Guete.
		*/
		public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
		 _guete) {
			this._guete = _guete;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getWert() != null) {
	                if (getWert().isZustand()) {
	                    datum.getUnscaledValue("Wert").setText(getWert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Wert").set(getWert().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getArt() != null) {
	                if (getArt().isZustand()) {
	                    datum.getUnscaledValue("Art").setText(getArt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Art").set(getArt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKorrektur() != null) {
	                if (getKorrektur().isZustand()) {
	                    datum.getUnscaledValue("Korrektur").setText(getKorrektur().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Korrektur").set(getKorrektur().getValue());
	                }
				}
				// AttributListenDefinition
					getStatus().bean2Atl(datum.getItem("Status"), factory);
				// AttributListenDefinition
					getGuete().bean2Atl(datum.getItem("Güte"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Wert").isState()) {
							setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							.getZustand(daten.getScaledValue("Wert").getText()));
						} else {
						setWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
						(daten.
							getUnscaledValue
						("Wert").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Art").isState()) {
							setArt(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
							.getZustand(daten.getScaledValue("Art").getText()));
						} else {
						setArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
						(daten.
							getUnscaledValue
						("Art").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Korrektur").isState()) {
							setKorrektur(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
							.getZustand(daten.getScaledValue("Korrektur").getText()));
						} else {
						setKorrektur(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
						(daten.
							getUnscaledValue
						("Korrektur").
								byteValue
						()));
						}
				// AttributListenDefinition
					getStatus().atl2Bean(daten.getItem("Status"), factory);
				// AttributListenDefinition
					getGuete().atl2Bean(daten.getItem("Güte"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTurAnzahlStellplaetze clone() {
		AtlTurAnzahlStellplaetze klon = new AtlTurAnzahlStellplaetze();
		
						klon.setWert(getWert());
						klon.setArt(getArt());
						klon.setKorrektur(getKorrektur());
						klon._status = getStatus().clone();
						klon._guete = getGuete().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
