/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert den Belegtzustand eines Parkbereiches, also
					letztlich eine Abbildung der numerischen, kontinuierlichen Anzahl
					belegter Parkstände auf eine Menge diskreter Zustände.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Defaultwert(wert = "Undefiniert")
public class AttTurBelegtZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTurBelegtZustand ZUSTAND_1N_UNDEFINIERT = new AttTurBelegtZustand("Undefiniert", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTurBelegtZustand ZUSTAND_0_FREI = new AttTurBelegtZustand("frei", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTurBelegtZustand ZUSTAND_1_NORMAL = new AttTurBelegtZustand("normal", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTurBelegtZustand ZUSTAND_2_HOHE_AUSLASTUNG = new AttTurBelegtZustand("hohe Auslastung", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTurBelegtZustand ZUSTAND_3_VOLL_BELEGT = new AttTurBelegtZustand("Voll belegt", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTurBelegtZustand ZUSTAND_4_UEBERBELEGT = new AttTurBelegtZustand("überbelegt", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTurBelegtZustand getZustand(final 		Byte
	 value) {
		for (AttTurBelegtZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTurBelegtZustand getZustand(final String value) {
		for (AttTurBelegtZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTurBelegtZustand> getZustaende() {
		List<AttTurBelegtZustand> list = new ArrayList<AttTurBelegtZustand>();
		list.add(ZUSTAND_1N_UNDEFINIERT);
		list.add(ZUSTAND_0_FREI);
		list.add(ZUSTAND_1_NORMAL);
		list.add(ZUSTAND_2_HOHE_AUSLASTUNG);
		list.add(ZUSTAND_3_VOLL_BELEGT);
		list.add(ZUSTAND_4_UEBERBELEGT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TuR Belegtzustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTurBelegtZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTurBelegtZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
