/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert einen dedizierten Bereich, für den die Anzahl
					verfügbarer Stellplätze verfolgt werden soll.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface TurAnlage extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.turAnlage"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Referenz auf ein Linienobjekt mit Offsetangabe vom Begin der Linie. Darüber läßt sich dessen Koordinate ermitteln. Liegen mehrer Objekte auf einem Linienobjekt, läßt sich über die Offsets die Topologie ermitteln.
	<p>
	
	</p>
	@return der Datensatz PunktLiegtAufLinienObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt();
	
	/**
	Online-Attributgruppe zum Publizieren der aktuell
						verletzten Regeln. Leere Liste heißt: Alles in Ordnung.
	<p>
	
	</p>
	@return der Datensatz PloVerletzteRegeln.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlplausibilisierungobjektuebergreifend.onlinedaten.OdPloVerletzteRegeln getOdPloVerletzteRegeln();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Enthält die Parameter für eine TuR Anlage.
	<p>
	
	</p>
	@return der Datensatz TurParameterAnlage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.parameter.PdTurParameterAnlage getPdTurParameterAnlage();
	
	/**
	Der Betriebsmodus, in dem die TuR Anlage betrieben werden
						soll.
	<p>
	
	</p>
	@return der Datensatz TurBetriebsmodus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.parameter.PdTurBetriebsmodus getPdTurBetriebsmodus();
	
	/**
	Beschreibt die aktuell ermittelten Werte für die freien
						bzw. belegten Stellplätze, also letztlich das entscheidende
						Ergebnis der ganzen Berechnungen.
	<p>
	
	</p>
	@return der Datensatz TurErmittelteAnzahlStellplaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.onlinedaten.OdTurErmittelteAnzahlStellplaetze getOdTurErmittelteAnzahlStellplaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter zur Messwertersetzung.
	<p>
	
	</p>
	@return der Datensatz TurMessWertErsetzung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.parameter.PdTurMessWertErsetzung getPdTurMessWertErsetzung();
	
	/**
	Zur Laufzeit änderbare Menge von Zählmethoden.
	<p>
	
	</p>
	@return der Datensatz TurZaehlMethodenListe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.parameter.PdTurZaehlMethodenListe getPdTurZaehlMethodenListe();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	/**
	Möglichkeit zur Definition einer zur Laufzeit änderbaren Menge von Regeln.
	<p>
	
	</p>
	@return der Datensatz PloRegelReferenzListe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlplausibilisierungobjektuebergreifend.parameter.PdPloRegelReferenzListe getPdPloRegelReferenzListe();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
