/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt die aktuell ermittelten Werte für die freien
					bzw. belegten Stellplätze, also letztlich das entscheidende
					Ergebnis der ganzen Berechnungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTurErmittelteAnzahlStellplaetze extends AbstractOnlineDatensatz<OdTurErmittelteAnzahlStellplaetze.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.MessWertErsetzung,
					Aspekte.Analyse,
				};
			}
	
			/**
			 * Attributgruppe nach Modifikation durch die Messwertersetzung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessWertErsetzung = new Aspekte("MessWertErsetzung", "asp.messWertErsetzung");
			
			/**
			 * Analysewerte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Analyse = new Aspekte("Analyse", "asp.analyse");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBelegtZustand
				 _belegtZustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AtlTurAnzahlStellplaetze
				 _anzahlStellplaetze
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AtlTurAnzahlStellplaetze
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
				 _zaehlMethode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
				 _betriebsZustand
				;
		
			/**
			Angabe einer Zeitdauer.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Angabe einer Zeitdauer.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Definiert den Belegtzustand eines Parkbereiches, also
								letztlich eine Abbildung der numerischen, kontinuierlichen Anzahl
								belegter Parkstände auf eine Menge diskreter Zustände.
			<p>
			
			</p>
			
			@return der Wert von BelegtZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBelegtZustand
				 getBelegtZustand() {
				return _belegtZustand;
			}
		
			/**
			Definiert den Belegtzustand eines Parkbereiches, also
								letztlich eine Abbildung der numerischen, kontinuierlichen Anzahl
								belegter Parkstände auf eine Menge diskreter Zustände.
			<p>
			
			</p>
			
			@param _belegtZustand der neue Wert von BelegtZustand.
			*/
			public void setBelegtZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBelegtZustand
			 _belegtZustand) {
				this._belegtZustand = _belegtZustand;
			}
		
			/**
			Kombiniert einen Meß- bzw. Berechnungswert, der eine
								Anzahl belegter bzw. freier Stellplätze angibt, mit zusätzlichen
								Status- und Güteinformationen.
			<p>
			
			</p>
			
			@return der Wert von AnzahlStellplaetze.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AtlTurAnzahlStellplaetze
				 getAnzahlStellplaetze() {
				return _anzahlStellplaetze;
			}
		
			/**
			Kombiniert einen Meß- bzw. Berechnungswert, der eine
								Anzahl belegter bzw. freier Stellplätze angibt, mit zusätzlichen
								Status- und Güteinformationen.
			<p>
			
			</p>
			
			@param _anzahlStellplaetze der neue Wert von AnzahlStellplaetze.
			*/
			public void setAnzahlStellplaetze(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AtlTurAnzahlStellplaetze
			 _anzahlStellplaetze) {
				this._anzahlStellplaetze = _anzahlStellplaetze;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.turZaehlMethode.
			<p>
			
			</p>
			
			@return der Wert von ZaehlMethode.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
				 getZaehlMethode() {
				return _zaehlMethode;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.turZaehlMethode.
			<p>
			
			</p>
			
			@param _zaehlMethode der neue Wert von ZaehlMethode.
			*/
			public void setZaehlMethode(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
			 _zaehlMethode) {
				this._zaehlMethode = _zaehlMethode;
			}
		
			/**
			Definiert den Betriebszustand einer Anlage zur dynamischen
								Ermittlung und Anzeige freier (LKW-)Parkstände.
			<p>
			
			</p>
			
			@return der Wert von BetriebsZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
				 getBetriebsZustand() {
				return _betriebsZustand;
			}
		
			/**
			Definiert den Betriebszustand einer Anlage zur dynamischen
								Ermittlung und Anzeige freier (LKW-)Parkstände.
			<p>
			
			</p>
			
			@param _betriebsZustand der neue Wert von BetriebsZustand.
			*/
			public void setBetriebsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
			 _betriebsZustand) {
				this._betriebsZustand = _betriebsZustand;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// GanzzahlAttributTyp
					if (getBelegtZustand() != null) {
		                if (getBelegtZustand().isZustand()) {
		                    datum.getUnscaledValue("BelegtZustand").setText(getBelegtZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BelegtZustand").set(getBelegtZustand().getValue());
		                }
					}
					// AttributListenDefinition
						getAnzahlStellplaetze().bean2Atl(datum.getItem("AnzahlStellplaetze"), factory);
					// ObjektReferenzAttributTyp
						final Object soZaehlMethode = getZaehlMethode();
						final SystemObject tmpZaehlMethode;
							if (soZaehlMethode instanceof SystemObject) {
								tmpZaehlMethode = (SystemObject)soZaehlMethode;
							} else if(soZaehlMethode instanceof SystemObjekt){
								tmpZaehlMethode = ((SystemObjekt)soZaehlMethode).getSystemObject();
							} else{
								tmpZaehlMethode = null;
							}
						datum.getReferenceValue("ZaehlMethode").setSystemObject(tmpZaehlMethode);
					// GanzzahlAttributTyp
					if (getBetriebsZustand() != null) {
		                if (getBetriebsZustand().isZustand()) {
		                    datum.getUnscaledValue("BetriebsZustand").setText(getBetriebsZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BetriebsZustand").set(getBetriebsZustand().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BelegtZustand").isState()) {
								setBelegtZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBelegtZustand
								.getZustand(daten.getScaledValue("BelegtZustand").getText()));
							} else {
							setBelegtZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBelegtZustand
							(daten.
								getUnscaledValue
							("BelegtZustand").
									byteValue
							()));
							}
					// AttributListenDefinition
						getAnzahlStellplaetze().atl2Bean(daten.getItem("AnzahlStellplaetze"), factory);
					// ObjektReferenzAttributTyp
						final long idZaehlMethode = daten.getReferenceValue("ZaehlMethode").getId();
						final SystemObjekt tmpZaehlMethode;
						if (idZaehlMethode == 0) {
							tmpZaehlMethode = null;
						} else {
							final SystemObject soZaehlMethode = factory.getDav().getDataModel().getObject(idZaehlMethode);
							if (soZaehlMethode == null) {
									tmpZaehlMethode = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.impl.TurZaehlMethodeUngueltig(idZaehlMethode);
							} else {
								tmpZaehlMethode = factory.getModellobjekt(soZaehlMethode);
							}
						}
						setZaehlMethode((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
						) tmpZaehlMethode);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BetriebsZustand").isState()) {
								setBetriebsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
								.getZustand(daten.getScaledValue("BetriebsZustand").getText()));
							} else {
							setBetriebsZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
							(daten.
								getUnscaledValue
							("BetriebsZustand").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon.setBelegtZustand(getBelegtZustand());
							klon._anzahlStellplaetze = getAnzahlStellplaetze().clone();
							klon.setZaehlMethode(getZaehlMethode());
							klon.setBetriebsZustand(getBetriebsZustand());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.turErmittelteAnzahlStellplaetze";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTurErmittelteAnzahlStellplaetze(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
