/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlturschaltung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Spezifiziert eine Anzeige, auf der die noch verfügbaren
					Stellplätze angezeigt werden, zusammen mit assoziierten Daten wie
					zugeordnete MQs oder anteilige Fahrzeuge.
<p>
&lt;absatz&gt; Die Attributliste soll ermöglichen, auch Anzeigen, die
						weit (&gt; 1km) vor dem Parkbereich stehen, zu bedienen. Hier muss
						nämlich der anzuzeigende Wert korrigiert werden. Wenn z.B. aktuell
						starker Zulauf auf den Parkplatz ist (also z.B. 19 - 21 Uhr), so
						wird der Anzeigewert einer weit weg stehenden Anzeige i.d.R.
						kleiner sein als der aktuell ermittelte, weil zwischen dem
						Zeitpunkt, zu dem ein Kraftfahrer das weit weg stehende Schild
						passiert, und dem Zeitpunkt, zu dem er den Parkplatz erreicht,
						eine gewisse Zeit verstreicht, in welcher etliche Plätze belegt
						sind.&lt;&#47;absatz&gt;
					&lt;absatz&gt;Es sind verschiedene Steuermechanismen denkbar:&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Die Differenz wird durch Auswertung historischer
							Ganglinien bestimmt. Hierfür bietet das Modell allerdings keine
							Unterstützung.&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Über einen MQ in unmittelbarer Nähe zum weit weg
							stehenden Schild wird die Verkehrsstärke und Geschwindigkeit
							erhoben. Über den Abstand des Schildes zum Parkplatz kann die
							Fahrzeit bestimmt werden. Durch Annahme eines Anteils kann
							bestimmt werden, wieviele Fahrzeuge den Parkplatz aufsuchen
							werden. Daraus bestimmt sich der Korrekturwert. Für diesen Fall
							dienen die Mitglieder dieser Attributliste.&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTurAnzeigeSpezifikation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 _anzeige
			;
			@Defaultwert(wert = "350 m")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _abstand
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _mQ
			;
			@Defaultwert(wert = "15 %")
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _anteil
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.anzeige.
		<p>
		
		</p>
		
		@return der Wert von Anzeige.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			 getAnzeige() {
			return _anzeige;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.anzeige.
		<p>
		
		</p>
		
		@param _anzeige der neue Wert von Anzeige.
		*/
		public void setAnzeige(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
		 _anzeige) {
			this._anzeige = _anzeige;
		}
	
		/**
		Abstand der Anzeige vom Parkplatz.
		<p>
		
		</p>
		
		@return der Wert von Abstand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 getAbstand() {
			return _abstand;
		}
	
		/**
		Abstand der Anzeige vom Parkplatz.
		<p>
		
		</p>
		
		@param _abstand der neue Wert von Abstand.
		*/
		public void setAbstand(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
		 _abstand) {
			this._abstand = _abstand;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.messQuerschnitt (Optionale Referenzierung
							erlaubt).
		<p>
		
		</p>
		
		@return der Wert von MQ.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 getMQ() {
			return _mQ;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.messQuerschnitt (Optionale Referenzierung
							erlaubt).
		<p>
		
		</p>
		
		@param _mQ der neue Wert von MQ.
		*/
		public void setMQ(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
		 _mQ) {
			this._mQ = _mQ;
		}
	
		/**
		Prozentwert.
		<p>
		
		</p>
		
		@return der Wert von Anteil.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getAnteil() {
			return _anteil;
		}
	
		/**
		Prozentwert.
		<p>
		
		</p>
		
		@param _anteil der neue Wert von Anteil.
		*/
		public void setAnteil(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _anteil) {
			this._anteil = _anteil;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnzeige = getAnzeige();
					final SystemObject tmpAnzeige;
						if (soAnzeige instanceof SystemObject) {
							tmpAnzeige = (SystemObject)soAnzeige;
						} else if(soAnzeige instanceof SystemObjekt){
							tmpAnzeige = ((SystemObjekt)soAnzeige).getSystemObject();
						} else{
							tmpAnzeige = null;
						}
					datum.getReferenceValue("Anzeige").setSystemObject(tmpAnzeige);
				// GanzzahlAttributTyp
				if (getAbstand() != null) {
	                if (getAbstand().isZustand()) {
	                    datum.getUnscaledValue("Abstand").setText(getAbstand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Abstand").set(getAbstand().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soMQ = getMQ();
					final SystemObject tmpMQ;
						if (soMQ instanceof SystemObject) {
							tmpMQ = (SystemObject)soMQ;
						} else if(soMQ instanceof SystemObjekt){
							tmpMQ = ((SystemObjekt)soMQ).getSystemObject();
						} else{
							tmpMQ = null;
						}
					datum.getReferenceValue("MQ").setSystemObject(tmpMQ);
				// GanzzahlAttributTyp
				if (getAnteil() != null) {
	                if (getAnteil().isZustand()) {
	                    datum.getUnscaledValue("Anteil").setText(getAnteil().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Anteil").set(getAnteil().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnzeige = daten.getReferenceValue("Anzeige").getId();
					final SystemObjekt tmpAnzeige;
					if (idAnzeige == 0) {
						tmpAnzeige = null;
					} else {
						final SystemObject soAnzeige = factory.getDav().getDataModel().getObject(idAnzeige);
						if (soAnzeige == null) {
								tmpAnzeige = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeige);
						} else {
							tmpAnzeige = factory.getModellobjekt(soAnzeige);
						}
					}
					setAnzeige((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
					) tmpAnzeige);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Abstand").isState()) {
							setAbstand(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							.getZustand(daten.getScaledValue("Abstand").getText()));
						} else {
						setAbstand(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
						(daten.
							getUnscaledValue
						("Abstand").
								intValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idMQ = daten.getReferenceValue("MQ").getId();
					final SystemObjekt tmpMQ;
					if (idMQ == 0) {
						tmpMQ = null;
					} else {
						final SystemObject soMQ = factory.getDav().getDataModel().getObject(idMQ);
						if (soMQ == null) {
								tmpMQ = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMQ);
						} else {
							tmpMQ = factory.getModellobjekt(soMQ);
						}
					}
					setMQ((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
					) tmpMQ);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Anteil").isState()) {
							setAnteil(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("Anteil").getText()));
						} else {
						setAnteil(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("Anteil").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTurAnzeigeSpezifikation clone() {
		AtlTurAnzeigeSpezifikation klon = new AtlTurAnzeigeSpezifikation();
		
						klon.setAnzeige(getAnzeige());
						klon.setAbstand(getAbstand());
						klon.setMQ(getMQ());
						klon.setAnteil(getAnteil());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
