/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition für die Attribute der Anzeige eines
					Objektes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcDisplayFarbenUndSchriften implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _farbe
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _hintergrund
			;
			private String
			 _schriftart
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			 _schriftgrad
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _fett
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _italic
			;
	
		/**
		Zeichenfarbe.
		<p>
		
		</p>
		
		@return der Wert von Farbe.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getFarbe() {
			return _farbe;
		}
	
		/**
		Zeichenfarbe.
		<p>
		
		</p>
		
		@param _farbe der neue Wert von Farbe.
		*/
		public void setFarbe(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _farbe) {
			this._farbe = _farbe;
		}
	
		/**
		Hintergrundfarbe.
		<p>
		
		</p>
		
		@return der Wert von Hintergrund.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getHintergrund() {
			return _hintergrund;
		}
	
		/**
		Hintergrundfarbe.
		<p>
		
		</p>
		
		@param _hintergrund der neue Wert von Hintergrund.
		*/
		public void setHintergrund(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _hintergrund) {
			this._hintergrund = _hintergrund;
		}
	
		/**
		Schriftart.
		<p>
		
		</p>
		
		@return der Wert von Schriftart.
		*/
			public String
			 getSchriftart() {
			return _schriftart;
		}
	
		/**
		Schriftart.
		<p>
		
		</p>
		
		@param _schriftart der neue Wert von Schriftart.
		*/
		public void setSchriftart(String
		 _schriftart) {
			if (_schriftart.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._schriftart = _schriftart;
		}
	
		/**
		Schriftgrad.
		<p>
		
		</p>
		
		@return der Wert von Schriftgrad.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			 getSchriftgrad() {
			return _schriftgrad;
		}
	
		/**
		Schriftgrad.
		<p>
		
		</p>
		
		@param _schriftgrad der neue Wert von Schriftgrad.
		*/
		public void setSchriftgrad(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		 _schriftgrad) {
			this._schriftgrad = _schriftgrad;
		}
	
		/**
		Fettschrift oder nicht.
		<p>
		
		</p>
		
		@return der Wert von Fett.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getFett() {
			return _fett;
		}
	
		/**
		Fettschrift oder nicht.
		<p>
		
		</p>
		
		@param _fett der neue Wert von Fett.
		*/
		public void setFett(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _fett) {
			this._fett = _fett;
		}
	
		/**
		Kursivschrift oder nicht.
		<p>
		
		</p>
		
		@return der Wert von Italic.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getItalic() {
			return _italic;
		}
	
		/**
		Kursivschrift oder nicht.
		<p>
		
		</p>
		
		@param _italic der neue Wert von Italic.
		*/
		public void setItalic(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _italic) {
			this._italic = _italic;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFarbe() != null) {
	                if (getFarbe().isZustand()) {
	                    datum.getUnscaledValue("Farbe").setText(getFarbe().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Farbe").set(getFarbe().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getHintergrund() != null) {
	                if (getHintergrund().isZustand()) {
	                    datum.getUnscaledValue("Hintergrund").setText(getHintergrund().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Hintergrund").set(getHintergrund().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getSchriftart() != null) {
					datum.getTextValue("Schriftart").setText(getSchriftart());
				}
				// GanzzahlAttributTyp
				if (getSchriftgrad() != null) {
	                if (getSchriftgrad().isZustand()) {
	                    datum.getUnscaledValue("Schriftgrad").setText(getSchriftgrad().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Schriftgrad").set(getSchriftgrad().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFett() != null) {
	                if (getFett().isZustand()) {
	                    datum.getUnscaledValue("Fett").setText(getFett().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Fett").set(getFett().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getItalic() != null) {
	                if (getItalic().isZustand()) {
	                    datum.getUnscaledValue("Italic").setText(getItalic().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Italic").set(getItalic().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setFarbe(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Farbe").
								longValue
						()));
				// GanzzahlAttributTyp
						setHintergrund(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Hintergrund").
								longValue
						()));
				// ZeichenkettenAttributTyp
					setSchriftart(daten.getTextValue("Schriftart").getText());
				// GanzzahlAttributTyp
						setSchriftgrad(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
						(daten.
							getUnscaledValue
						("Schriftgrad").
								byteValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Fett").isState()) {
							setFett(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Fett").getText()));
						} else {
						setFett(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Fett").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Italic").isState()) {
							setItalic(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Italic").getText()));
						} else {
						setItalic(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Italic").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcDisplayFarbenUndSchriften clone() {
		AtlBcDisplayFarbenUndSchriften klon = new AtlBcDisplayFarbenUndSchriften();
		
						klon.setFarbe(getFarbe());
						klon.setHintergrund(getHintergrund());
						klon.setSchriftart(getSchriftart());
						klon.setSchriftgrad(getSchriftgrad());
						klon.setFett(getFett());
						klon.setItalic(getItalic());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
