/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine absolute Verriegelungs- bzw. Abgleichregel.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlVerriegelungsRegelAbsolut implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			> _wenn = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			> _dann = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttRegelAuswertung
			 _auswertung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ueberschreibbar
			;
			private String
			 _kommentar
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			> _ersetzung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			>(0, true);
	
		/**
		Anzeigenelement-Anzeigezustand-Kombinationen.
		<p>
		
		</p>
		
		@return der Wert von Wenn.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			> getWenn() {
			return _wenn;
		}
	
	
		/**
		Anzeigenelement-Anzeigezustand-Kombinationen.
		<p>
		
		</p>
		
		@return der Wert von Dann.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			> getDann() {
			return _dann;
		}
	
	
		/**
		Der Wert dieses Attributs gibt an, wie die Liste
							'TestZustände'
							einer Regel ausgewertet werden soll.
		<p>
		
		</p>
		
		@return der Wert von Auswertung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttRegelAuswertung
			 getAuswertung() {
			return _auswertung;
		}
	
		/**
		Der Wert dieses Attributs gibt an, wie die Liste
							'TestZustände'
							einer Regel ausgewertet werden soll.
		<p>
		
		</p>
		
		@param _auswertung der neue Wert von Auswertung.
		*/
		public void setAuswertung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttRegelAuswertung
		 _auswertung) {
			this._auswertung = _auswertung;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Ueberschreibbar.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getUeberschreibbar() {
			return _ueberschreibbar;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _ueberschreibbar der neue Wert von Ueberschreibbar.
		*/
		public void setUeberschreibbar(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _ueberschreibbar) {
			this._ueberschreibbar = _ueberschreibbar;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Kommentar.
		*/
			public String
			 getKommentar() {
			return _kommentar;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _kommentar der neue Wert von Kommentar.
		*/
		public void setKommentar(String
		 _kommentar) {
			if (_kommentar.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._kommentar = _kommentar;
		}
	
		/**
		Wenn in dieser Liste etwas steht, so wird eine erkannte
								Verletzung der
								Verriegelung durch diese
								Anzeigenelement-Anzeigezustand-Kombinationen
								im
								Programm abgeglichen
								bzw. ersetzt.
		<p>
		
		</p>
		
		@return der Wert von Ersetzung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
			> getErsetzung() {
			return _ersetzung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayWenn = datum.getArray("Wenn");
					arrayWenn.setLength(getWenn().size());
					for (int i = 0; i < arrayWenn.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 atl = getWenn().get(i);
						atl.bean2Atl(arrayWenn.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayDann = datum.getArray("Dann");
					arrayDann.setLength(getDann().size());
					for (int i = 0; i < arrayDann.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 atl = getDann().get(i);
						atl.bean2Atl(arrayDann.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getAuswertung() != null) {
	                if (getAuswertung().isZustand()) {
	                    datum.getUnscaledValue("Auswertung").setText(getAuswertung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Auswertung").set(getAuswertung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getUeberschreibbar() != null) {
	                if (getUeberschreibbar().isZustand()) {
	                    datum.getUnscaledValue("Überschreibbar").setText(getUeberschreibbar().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Überschreibbar").set(getUeberschreibbar().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getKommentar() != null) {
					datum.getTextValue("Kommentar").setText(getKommentar());
				}
				// AttributListenDefinition
					final Data.Array arrayErsetzung = datum.getArray("Ersetzung");
					arrayErsetzung.setLength(getErsetzung().size());
					for (int i = 0; i < arrayErsetzung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 atl = getErsetzung().get(i);
						atl.bean2Atl(arrayErsetzung.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayWenn = daten.getArray("Wenn");
					for (int i = 0; i < arrayWenn.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 ();
						atl.atl2Bean(arrayWenn.getItem(i), factory);
						getWenn().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayDann = daten.getArray("Dann");
					for (int i = 0; i < arrayDann.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 ();
						atl.atl2Bean(arrayDann.getItem(i), factory);
						getDann().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Auswertung").isState()) {
							setAuswertung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttRegelAuswertung
							.getZustand(daten.getScaledValue("Auswertung").getText()));
						} else {
						setAuswertung(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttRegelAuswertung
						(daten.
							getUnscaledValue
						("Auswertung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Überschreibbar").isState()) {
							setUeberschreibbar(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Überschreibbar").getText()));
						} else {
						setUeberschreibbar(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Überschreibbar").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setKommentar(daten.getTextValue("Kommentar").getText());
				// AttributListenDefinition
					final Data.Array arrayErsetzung = daten.getArray("Ersetzung");
					for (int i = 0; i < arrayErsetzung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AtlVerriegelungsZustandAbsolut
						 ();
						atl.atl2Bean(arrayErsetzung.getItem(i), factory);
						getErsetzung().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVerriegelungsRegelAbsolut clone() {
		AtlVerriegelungsRegelAbsolut klon = new AtlVerriegelungsRegelAbsolut();
		
					klon._wenn = getWenn().clone();
					klon._dann = getDann().clone();
						klon.setAuswertung(getAuswertung());
						klon.setUeberschreibbar(getUeberschreibbar());
						klon.setKommentar(getKommentar());
					klon._ersetzung = getErsetzung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
