/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Repräsentiert einen relativen Verriegelungszustand wie
					folgt:
					Ein Schild X auf Fahrspur 'FahrSpur' und AnzeigeQuerschnitt
					'AQRelativReferenz'
					zeigt in Richtung 'SchildZeigeRichtung'. Es hat
					den Inhalt 'SchildZustand'.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlVerriegelungsZustandRelativ implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			> _aQRelativReferenz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			> _fahrSpurRelativReferenz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			>(1, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
			 _schildZeigeRichtung
			;
			private 	Object
			 _schildZustand
			;
			private 	Object
			 _schildZustandNach
			;
	
		/**
		Diese Liste kann maximal ein Element enthalten. Sollte
								sie leer sein, so wird
								standardmäßig der Zustand '0 - selber
								Anzeigequerschnitt' angenommen.
								...
								-2 -
								vorvorheriger
								Anzeigequerschnitt in Richtung,
								-1 - vorheriger
								Anzeigequerschnitt
								in Richtung,
								0 - selber Anzeigequerschnitt,
								1 - nächster
								Anzeigequerschnitt in Richtung,
								2 - übernächster Anzeigequerschnitt
								in Richtung,
								...
		<p>
		
		</p>
		
		@return der Wert von AQRelativReferenz.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			> getAQRelativReferenz() {
			return _aQRelativReferenz;
		}
	
	
		/**
		Gibt ggf. die Fahrspur an, auf der sich das Schild
								befindet. Diese
								Liste
								kann maximal ein Element enthalten. Sollte sie
								leer sein, so
								wird
								standardmäßig der Zustand '0 - selbe Fahrspur'
								angenommen.
								...
								-1 - rechts
								angrenzende Fahrspur in Richtung,
								0 -
								selbe Fahrspur,
								1 - links angrenzende Fahrspur in Richtung,
								...
		<p>
		
		</p>
		
		@return der Wert von FahrSpurRelativReferenz.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			> getFahrSpurRelativReferenz() {
			return _fahrSpurRelativReferenz;
		}
	
	
		/**
		Gibt an, ob ein Schild in oder gegen die Fahrrichtung
								zeigt.
								Dabei geht auch '?' für 'unbekannt'.
		<p>
		
		</p>
		
		@return der Wert von SchildZeigeRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
			 getSchildZeigeRichtung() {
			return _schildZeigeRichtung;
		}
	
		/**
		Gibt an, ob ein Schild in oder gegen die Fahrrichtung
								zeigt.
								Dabei geht auch '?' für 'unbekannt'.
		<p>
		
		</p>
		
		@param _schildZeigeRichtung der neue Wert von SchildZeigeRichtung.
		*/
		public void setSchildZeigeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
		 _schildZeigeRichtung) {
			this._schildZeigeRichtung = _schildZeigeRichtung;
		}
	
		/**
		Gibt den aktuellen Schildzustand (i.A. vom
								typ.wvzInhaltGrafik) des
								Schildes an, das überprüft werden soll.
		<p>
		
		</p>
		
		@return der Wert von SchildZustand.
		*/
			public 	Object
			 getSchildZustand() {
			return _schildZustand;
		}
	
		/**
		Gibt den aktuellen Schildzustand (i.A. vom
								typ.wvzInhaltGrafik) des
								Schildes an, das überprüft werden soll.
		<p>
		
		</p>
		
		@param _schildZustand der neue Wert von SchildZustand.
		*/
		public void setSchildZustand(	Object
		 _schildZustand) {
			this._schildZustand = _schildZustand;
		}
	
		/**
		Sollte dieser Schildzustand ungleich NULL sein, so
								bedeuted
								das, dass es sich um eine Uebergangsregel handelt.
		<p>
		
		</p>
		
		@return der Wert von SchildZustandNach.
		*/
			public 	Object
			 getSchildZustandNach() {
			return _schildZustandNach;
		}
	
		/**
		Sollte dieser Schildzustand ungleich NULL sein, so
								bedeuted
								das, dass es sich um eine Uebergangsregel handelt.
		<p>
		
		</p>
		
		@param _schildZustandNach der neue Wert von SchildZustandNach.
		*/
		public void setSchildZustandNach(	Object
		 _schildZustandNach) {
			this._schildZustandNach = _schildZustandNach;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAQRelativReferenz() != null) {
					final Data.NumberArray arrayAQRelativReferenz = datum.
						getUnscaledArray
						("AQRelativReferenz");
					arrayAQRelativReferenz.setLength(getAQRelativReferenz().size());
					for (int i = 0; i < arrayAQRelativReferenz.getLength(); ++i) {
						arrayAQRelativReferenz.getValue(i).set(getAQRelativReferenz().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getFahrSpurRelativReferenz() != null) {
					final Data.NumberArray arrayFahrSpurRelativReferenz = datum.
						getUnscaledArray
						("FahrSpurRelativReferenz");
					arrayFahrSpurRelativReferenz.setLength(getFahrSpurRelativReferenz().size());
					for (int i = 0; i < arrayFahrSpurRelativReferenz.getLength(); ++i) {
						arrayFahrSpurRelativReferenz.getValue(i).set(getFahrSpurRelativReferenz().get(i).getValue());
					}
				}
				// GanzzahlAttributTyp
				if (getSchildZeigeRichtung() != null) {
	                if (getSchildZeigeRichtung().isZustand()) {
	                    datum.getUnscaledValue("SchildZeigeRichtung").setText(getSchildZeigeRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SchildZeigeRichtung").set(getSchildZeigeRichtung().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soSchildZustand = getSchildZustand();
					final SystemObject tmpSchildZustand;
						if (soSchildZustand instanceof SystemObject) {
							tmpSchildZustand = (SystemObject)soSchildZustand;
						} else if(soSchildZustand instanceof SystemObjekt){
							tmpSchildZustand = ((SystemObjekt)soSchildZustand).getSystemObject();
						} else{
							tmpSchildZustand = null;
						}
					datum.getReferenceValue("SchildZustand").setSystemObject(tmpSchildZustand);
				// ObjektReferenzAttributTyp
					final Object soSchildZustandNach = getSchildZustandNach();
					final SystemObject tmpSchildZustandNach;
						if (soSchildZustandNach instanceof SystemObject) {
							tmpSchildZustandNach = (SystemObject)soSchildZustandNach;
						} else if(soSchildZustandNach instanceof SystemObjekt){
							tmpSchildZustandNach = ((SystemObjekt)soSchildZustandNach).getSystemObject();
						} else{
							tmpSchildZustandNach = null;
						}
					datum.getReferenceValue("SchildZustandNach").setSystemObject(tmpSchildZustandNach);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
					final Data.NumberArray arrayAQRelativReferenz = daten.
						getUnscaledArray
					("AQRelativReferenz");
	
					for (int i = 0; i < arrayAQRelativReferenz.getLength(); ++i) {
	                    getAQRelativReferenz().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
	                    (arrayAQRelativReferenz.
	                    		longValue
	                    (i)));
	                }
				// GanzzahlAttributTyp
					final Data.NumberArray arrayFahrSpurRelativReferenz = daten.
						getUnscaledArray
					("FahrSpurRelativReferenz");
	
					for (int i = 0; i < arrayFahrSpurRelativReferenz.getLength(); ++i) {
	                    getFahrSpurRelativReferenz().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
	                    (arrayFahrSpurRelativReferenz.
	                    		longValue
	                    (i)));
	                }
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SchildZeigeRichtung").isState()) {
							setSchildZeigeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
							.getZustand(daten.getScaledValue("SchildZeigeRichtung").getText()));
						} else {
						setSchildZeigeRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
						(daten.
							getUnscaledValue
						("SchildZeigeRichtung").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idSchildZustand = daten.getReferenceValue("SchildZustand").getId();
					final SystemObjekt tmpSchildZustand;
					if (idSchildZustand == 0) {
						tmpSchildZustand = null;
					} else {
						final SystemObject soSchildZustand = factory.getDav().getDataModel().getObject(idSchildZustand);
						if (soSchildZustand == null) {
								tmpSchildZustand = new BaseUngueltigesSystemObjekt(idSchildZustand);
						} else {
							tmpSchildZustand = factory.getModellobjekt(soSchildZustand);
						}
					}
					setSchildZustand((	Object
					) tmpSchildZustand);
				// ObjektReferenzAttributTyp
					final long idSchildZustandNach = daten.getReferenceValue("SchildZustandNach").getId();
					final SystemObjekt tmpSchildZustandNach;
					if (idSchildZustandNach == 0) {
						tmpSchildZustandNach = null;
					} else {
						final SystemObject soSchildZustandNach = factory.getDav().getDataModel().getObject(idSchildZustandNach);
						if (soSchildZustandNach == null) {
								tmpSchildZustandNach = new BaseUngueltigesSystemObjekt(idSchildZustandNach);
						} else {
							tmpSchildZustandNach = factory.getModellobjekt(soSchildZustandNach);
						}
					}
					setSchildZustandNach((	Object
					) tmpSchildZustandNach);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVerriegelungsZustandRelativ clone() {
		AtlVerriegelungsZustandRelativ klon = new AtlVerriegelungsZustandRelativ();
		
					klon._aQRelativReferenz = getAQRelativReferenz().clone();
					klon._fahrSpurRelativReferenz = getFahrSpurRelativReferenz().clone();
						klon.setSchildZeigeRichtung(getSchildZeigeRichtung());
						klon.setSchildZustand(getSchildZustand());
						klon.setSchildZustandNach(getSchildZustandNach());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
