/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Der Wert dieses Attributs gibt an, wie die Liste
					'TestZustände'
					einer Regel ausgewertet werden soll.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttRegelAuswertung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Die in der Liste 'TestZustände' aufgeführten
								Anzeigenelement-Anzeigezustand-
								Kombinationen dürfen nicht
								gleichzeigitg in einem Programm vorkommen.
	<p>
	
	</p>
	*/
	public static final AttRegelAuswertung ZUSTAND_0_VERBOTEN = new AttRegelAuswertung("Verboten", 		Byte
	.valueOf("0"));

	/**
	Wenn eine in der Liste 'TestZustände' stehende
								Anzeigenelement-Anzeigezustand-
								Kombinationen im Programm
								vorkommt, so müssen alle anderen auch vorkommen.
	<p>
	
	</p>
	*/
	public static final AttRegelAuswertung ZUSTAND_1_VORGESCHRIEBEN = new AttRegelAuswertung("Vorgeschrieben", 		Byte
	.valueOf("1"));

	/**
	Wenn in einer Regel fuer alle unter 'Dann' aufgelisteten
								Zustaende gilt,
								der Zustand kommt entweder im aktuellen oder im
								geprueften Programm vor,
								dann gilt diese Regel als verletzt.
	<p>
	
	</p>
	*/
	public static final AttRegelAuswertung ZUSTAND_2_HARDWARE = new AttRegelAuswertung("Hardware", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRegelAuswertung getZustand(final 		Byte
	 value) {
		for (AttRegelAuswertung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRegelAuswertung getZustand(final String value) {
		for (AttRegelAuswertung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRegelAuswertung> getZustaende() {
		List<AttRegelAuswertung> list = new ArrayList<AttRegelAuswertung>();
		list.add(ZUSTAND_0_VERBOTEN);
		list.add(ZUSTAND_1_VORGESCHRIEBEN);
		list.add(ZUSTAND_2_HARDWARE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut RegelAuswertung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRegelAuswertung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttRegelAuswertung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
