/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Hier wird eine Menge von Verriegelungs- bzw.
					Abgleichregeln referenziert, die
					in Fahrtrichtung über den
					übergebenen Fahrspuren und Anzeigequerschnitten relativ
					arbeiten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdVerriegelungsReglementRelativ extends AbstractParameterDatensatz<PdVerriegelungsReglementRelativ.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _kommentar
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 _fahrtrichtung
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
				> _fahrSpurenVonRechtsNachLinks = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				> _querschnitteInFahrtrichtung = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.objekte.VerriegelungsRegelListe
				> _regelListen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.objekte.VerriegelungsRegelListe
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Kommentar.
			*/
				public String
				 getKommentar() {
				return _kommentar;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _kommentar der neue Wert von Kommentar.
			*/
			public void setKommentar(String
			 _kommentar) {
				if (_kommentar.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._kommentar = _kommentar;
			}
		
			/**
			Fahrtrichtung, die für dieses Reglement gilt. Auf diese
									Richtung beziehen sich auch die folgenden Listen.
			<p>
			
			</p>
			
			@return der Wert von Fahrtrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
				 getFahrtrichtung() {
				return _fahrtrichtung;
			}
		
			/**
			Fahrtrichtung, die für dieses Reglement gilt. Auf diese
									Richtung beziehen sich auch die folgenden Listen.
			<p>
			
			</p>
			
			@param _fahrtrichtung der neue Wert von Fahrtrichtung.
			*/
			public void setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
			 _fahrtrichtung) {
				this._fahrtrichtung = _fahrtrichtung;
			}
		
			/**
			Diese Liste definiert eine Ordnung in Fahrtrichtung, auf
									die sich die Verriegelungs- bzw.
									Abgleichregeln beziehen. Innerhalb
									einer solchen Regel erfolgt bspw. eine Verriegelung
									eines
									Anzeigeelements gegen ein Anzeigeelement auf einer anderen
									Fahrspur. Diese kann so
									relativ zur aktuellen Fahrspur angegeben
									werden kann (0 = gleiche Fahrspur, -1 = in
									Fahrtrichtung rechts
									angrenzende Fahrspur usw.).
			<p>
			
			</p>
			
			@return der Wert von FahrSpurenVonRechtsNachLinks.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
				> getFahrSpurenVonRechtsNachLinks() {
				return _fahrSpurenVonRechtsNachLinks;
			}
		
		
			/**
			Eine Liste mit in Fahrtrichtung geordneten
									Anzeigequerschnitten. Wird in Regel wie
									die Fahrspurreferenz
									aufgelöst.
			<p>
			
			</p>
			
			@return der Wert von QuerschnitteInFahrtrichtung.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				> getQuerschnitteInFahrtrichtung() {
				return _querschnitteInFahrtrichtung;
			}
		
		
			/**
			Eine Liste mit Mengen von Verriegelungs- bzw.
									Abgleichregeln. Die darin enthaltenen
									Regeln arbeiten über einer
									Vorgänger-Nachfolger-Relation für Anzeigequerschnitte. Diese
									Relationen sind über die Ordnung innerhalb der hier definierten
									Menge von
									Anzeigequerschnitten gegeben.
			<p>
			
			</p>
			
			@return der Wert von RegelListen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.objekte.VerriegelungsRegelListe
				> getRegelListen() {
				return _regelListen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getKommentar() != null) {
						datum.getTextValue("Kommentar").setText(getKommentar());
					}
					// GanzzahlAttributTyp
					if (getFahrtrichtung() != null) {
		                if (getFahrtrichtung().isZustand()) {
		                    datum.getUnscaledValue("Fahrtrichtung").setText(getFahrtrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fahrtrichtung").set(getFahrtrichtung().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFahrSpurenVonRechtsNachLinks = datum.getReferenceArray("FahrSpurenVonRechtsNachLinks");
						arrayFahrSpurenVonRechtsNachLinks.setLength(getFahrSpurenVonRechtsNachLinks().size());
						for (int i = 0; i < arrayFahrSpurenVonRechtsNachLinks.getLength(); ++i) {
							final Object soFahrSpurenVonRechtsNachLinks = getFahrSpurenVonRechtsNachLinks().get(i);
							final SystemObject tmpFahrSpurenVonRechtsNachLinks;
							if (soFahrSpurenVonRechtsNachLinks instanceof SystemObject) {
								tmpFahrSpurenVonRechtsNachLinks = (SystemObject)soFahrSpurenVonRechtsNachLinks;
							} else if(soFahrSpurenVonRechtsNachLinks instanceof SystemObjekt){
								tmpFahrSpurenVonRechtsNachLinks = ((SystemObjekt)soFahrSpurenVonRechtsNachLinks).getSystemObject();
							} else{
								tmpFahrSpurenVonRechtsNachLinks = null;
							}
							arrayFahrSpurenVonRechtsNachLinks.getReferenceValue(i).setSystemObject(tmpFahrSpurenVonRechtsNachLinks);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayQuerschnitteInFahrtrichtung = datum.getReferenceArray("QuerschnitteInFahrtrichtung");
						arrayQuerschnitteInFahrtrichtung.setLength(getQuerschnitteInFahrtrichtung().size());
						for (int i = 0; i < arrayQuerschnitteInFahrtrichtung.getLength(); ++i) {
							final Object soQuerschnitteInFahrtrichtung = getQuerschnitteInFahrtrichtung().get(i);
							final SystemObject tmpQuerschnitteInFahrtrichtung;
							if (soQuerschnitteInFahrtrichtung instanceof SystemObject) {
								tmpQuerschnitteInFahrtrichtung = (SystemObject)soQuerschnitteInFahrtrichtung;
							} else if(soQuerschnitteInFahrtrichtung instanceof SystemObjekt){
								tmpQuerschnitteInFahrtrichtung = ((SystemObjekt)soQuerschnitteInFahrtrichtung).getSystemObject();
							} else{
								tmpQuerschnitteInFahrtrichtung = null;
							}
							arrayQuerschnitteInFahrtrichtung.getReferenceValue(i).setSystemObject(tmpQuerschnitteInFahrtrichtung);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRegelListen = datum.getReferenceArray("RegelListen");
						arrayRegelListen.setLength(getRegelListen().size());
						for (int i = 0; i < arrayRegelListen.getLength(); ++i) {
							final Object soRegelListen = getRegelListen().get(i);
							final SystemObject tmpRegelListen;
							if (soRegelListen instanceof SystemObject) {
								tmpRegelListen = (SystemObject)soRegelListen;
							} else if(soRegelListen instanceof SystemObjekt){
								tmpRegelListen = ((SystemObjekt)soRegelListen).getSystemObject();
							} else{
								tmpRegelListen = null;
							}
							arrayRegelListen.getReferenceValue(i).setSystemObject(tmpRegelListen);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setKommentar(daten.getTextValue("Kommentar").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Fahrtrichtung").isState()) {
								setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
								.getZustand(daten.getScaledValue("Fahrtrichtung").getText()));
							} else {
							setFahrtrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttHimmelsRichtung
							(daten.
								getUnscaledValue
							("Fahrtrichtung").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFahrSpurenVonRechtsNachLinks = daten.getReferenceArray("FahrSpurenVonRechtsNachLinks");
						for (int i = 0; i < arrayFahrSpurenVonRechtsNachLinks.getLength(); ++i) {
							final long idFahrSpurenVonRechtsNachLinks = daten.getReferenceArray("FahrSpurenVonRechtsNachLinks").getReferenceValue(i).getId();
							final SystemObjekt tmpFahrSpurenVonRechtsNachLinks;
							if (idFahrSpurenVonRechtsNachLinks == 0) {
								tmpFahrSpurenVonRechtsNachLinks = null;
							} else {
								final SystemObject soFahrSpurenVonRechtsNachLinks = factory.getDav().getDataModel().getObject(idFahrSpurenVonRechtsNachLinks);
								if (soFahrSpurenVonRechtsNachLinks == null) {
										tmpFahrSpurenVonRechtsNachLinks = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.impl.FahrSpurUngueltig(idFahrSpurenVonRechtsNachLinks);
								} else {
									tmpFahrSpurenVonRechtsNachLinks = factory.getModellobjekt(soFahrSpurenVonRechtsNachLinks);
								}
							}
								getFahrSpurenVonRechtsNachLinks().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
								) tmpFahrSpurenVonRechtsNachLinks);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayQuerschnitteInFahrtrichtung = daten.getReferenceArray("QuerschnitteInFahrtrichtung");
						for (int i = 0; i < arrayQuerschnitteInFahrtrichtung.getLength(); ++i) {
							final long idQuerschnitteInFahrtrichtung = daten.getReferenceArray("QuerschnitteInFahrtrichtung").getReferenceValue(i).getId();
							final SystemObjekt tmpQuerschnitteInFahrtrichtung;
							if (idQuerschnitteInFahrtrichtung == 0) {
								tmpQuerschnitteInFahrtrichtung = null;
							} else {
								final SystemObject soQuerschnitteInFahrtrichtung = factory.getDav().getDataModel().getObject(idQuerschnitteInFahrtrichtung);
								if (soQuerschnitteInFahrtrichtung == null) {
										tmpQuerschnitteInFahrtrichtung = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeQuerschnittUngueltig(idQuerschnitteInFahrtrichtung);
								} else {
									tmpQuerschnitteInFahrtrichtung = factory.getModellobjekt(soQuerschnitteInFahrtrichtung);
								}
							}
								getQuerschnitteInFahrtrichtung().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
								) tmpQuerschnitteInFahrtrichtung);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRegelListen = daten.getReferenceArray("RegelListen");
						for (int i = 0; i < arrayRegelListen.getLength(); ++i) {
							final long idRegelListen = daten.getReferenceArray("RegelListen").getReferenceValue(i).getId();
							final SystemObjekt tmpRegelListen;
							if (idRegelListen == 0) {
								tmpRegelListen = null;
							} else {
								final SystemObject soRegelListen = factory.getDav().getDataModel().getObject(idRegelListen);
								if (soRegelListen == null) {
										tmpRegelListen = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.objekte.impl.VerriegelungsRegelListeUngueltig(idRegelListen);
								} else {
									tmpRegelListen = factory.getModellobjekt(soRegelListen);
								}
							}
								getRegelListen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.objekte.VerriegelungsRegelListe
								) tmpRegelListen);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setKommentar(getKommentar());
							klon.setFahrtrichtung(getFahrtrichtung());
						klon._fahrSpurenVonRechtsNachLinks = getFahrSpurenVonRechtsNachLinks().clone();
						klon._querschnitteInFahrtrichtung = getQuerschnitteInFahrtrichtung().clone();
						klon._regelListen = getRegelListen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verriegelungsReglementRelativ";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVerriegelungsReglementRelativ(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
