/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein Configuration Kommando des TPortAgenten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcTPortAgentConfigKommando implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _applikationsID
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anfrageID
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _konfiguration
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AttBcTPortAgentEventAntwortTyp
			 _eventAntwortTyp
			;
			private String
			 _verursacher
			= new String
			()
			;
			private String
			 _nachricht
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.ViptModul
			 _detektor
			;
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von ApplikationsID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getApplikationsID() {
			return _applikationsID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _applikationsID der neue Wert von ApplikationsID.
		*/
		public void setApplikationsID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _applikationsID) {
			this._applikationsID = _applikationsID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von AnfrageID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getAnfrageID() {
			return _anfrageID;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _anfrageID der neue Wert von AnfrageID.
		*/
		public void setAnfrageID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _anfrageID) {
			this._anfrageID = _anfrageID;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@return der Wert von Konfiguration.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getKonfiguration() {
			return _konfiguration;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@param _konfiguration der neue Wert von Konfiguration.
		*/
		public void setKonfiguration(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _konfiguration) {
			this._konfiguration = _konfiguration;
		}
	
		/**
		Typ einer Antwort vom TPort-Agenten.
		<p>
		
		</p>
		
		@return der Wert von EventAntwortTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AttBcTPortAgentEventAntwortTyp
			 getEventAntwortTyp() {
			return _eventAntwortTyp;
		}
	
		/**
		Typ einer Antwort vom TPort-Agenten.
		<p>
		
		</p>
		
		@param _eventAntwortTyp der neue Wert von EventAntwortTyp.
		*/
		public void setEventAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AttBcTPortAgentEventAntwortTyp
		 _eventAntwortTyp) {
			this._eventAntwortTyp = _eventAntwortTyp;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Verursacher.
		*/
			public String
			 getVerursacher() {
			return _verursacher;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _verursacher der neue Wert von Verursacher.
		*/
		public void setVerursacher(String
		 _verursacher) {
			if (_verursacher.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._verursacher = _verursacher;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Nachricht.
		*/
			public String
			 getNachricht() {
			return _nachricht;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _nachricht der neue Wert von Nachricht.
		*/
		public void setNachricht(String
		 _nachricht) {
			if (_nachricht.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._nachricht = _nachricht;
		}
	
		/**
		Referenz auf ein Objekt vom Typ "typ.viptModul".
		<p>
		
		</p>
		
		@return der Wert von Detektor.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.ViptModul
			 getDetektor() {
			return _detektor;
		}
	
		/**
		Referenz auf ein Objekt vom Typ "typ.viptModul".
		<p>
		
		</p>
		
		@param _detektor der neue Wert von Detektor.
		*/
		public void setDetektor(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.ViptModul
		 _detektor) {
			this._detektor = _detektor;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getApplikationsID() != null) {
	                if (getApplikationsID().isZustand()) {
	                    datum.getUnscaledValue("ApplikationsID").setText(getApplikationsID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ApplikationsID").set(getApplikationsID().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnfrageID() != null) {
	                if (getAnfrageID().isZustand()) {
	                    datum.getUnscaledValue("AnfrageID").setText(getAnfrageID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnfrageID").set(getAnfrageID().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKonfiguration() != null) {
	                if (getKonfiguration().isZustand()) {
	                    datum.getUnscaledValue("Konfiguration").setText(getKonfiguration().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Konfiguration").set(getKonfiguration().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEventAntwortTyp() != null) {
	                if (getEventAntwortTyp().isZustand()) {
	                    datum.getUnscaledValue("EventAntwortTyp").setText(getEventAntwortTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EventAntwortTyp").set(getEventAntwortTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getVerursacher() != null) {
					datum.getTextValue("Verursacher").setText(getVerursacher());
				}
				// ZeichenkettenAttributTyp
				if (getNachricht() != null) {
					datum.getTextValue("Nachricht").setText(getNachricht());
				}
				// ObjektReferenzAttributTyp
					final Object soDetektor = getDetektor();
					final SystemObject tmpDetektor;
						if (soDetektor instanceof SystemObject) {
							tmpDetektor = (SystemObject)soDetektor;
						} else if(soDetektor instanceof SystemObjekt){
							tmpDetektor = ((SystemObjekt)soDetektor).getSystemObject();
						} else{
							tmpDetektor = null;
						}
					datum.getReferenceValue("Detektor").setSystemObject(tmpDetektor);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setApplikationsID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("ApplikationsID").
								longValue
						()));
				// GanzzahlAttributTyp
						setAnfrageID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("AnfrageID").
								longValue
						()));
				// GanzzahlAttributTyp
						setKonfiguration(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("Konfiguration").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EventAntwortTyp").isState()) {
							setEventAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AttBcTPortAgentEventAntwortTyp
							.getZustand(daten.getScaledValue("EventAntwortTyp").getText()));
						} else {
						setEventAntwortTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AttBcTPortAgentEventAntwortTyp
						(daten.
							getUnscaledValue
						("EventAntwortTyp").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setVerursacher(daten.getTextValue("Verursacher").getText());
				// ZeichenkettenAttributTyp
					setNachricht(daten.getTextValue("Nachricht").getText());
				// ObjektReferenzAttributTyp
					final long idDetektor = daten.getReferenceValue("Detektor").getId();
					final SystemObjekt tmpDetektor;
					if (idDetektor == 0) {
						tmpDetektor = null;
					} else {
						final SystemObject soDetektor = factory.getDav().getDataModel().getObject(idDetektor);
						if (soDetektor == null) {
								tmpDetektor = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.impl.ViptModulUngueltig(idDetektor);
						} else {
							tmpDetektor = factory.getModellobjekt(soDetektor);
						}
					}
					setDetektor((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.ViptModul
					) tmpDetektor);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcTPortAgentConfigKommando clone() {
		AtlBcTPortAgentConfigKommando klon = new AtlBcTPortAgentConfigKommando();
		
						klon.setApplikationsID(getApplikationsID());
						klon.setAnfrageID(getAnfrageID());
						klon.setKonfiguration(getKonfiguration());
						klon.setEventAntwortTyp(getEventAntwortTyp());
						klon.setVerursacher(getVerursacher());
						klon.setNachricht(getNachricht());
						klon.setDetektor(getDetektor());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
