/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt die Konfiguration der Vip-T Module pro Programm.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcTPortKonfigurationNachProgramm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _schaltProgram
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
			 _konfigurationsID
			;
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von SchaltProgram.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getSchaltProgram() {
			return _schaltProgram;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _schaltProgram der neue Wert von SchaltProgram.
		*/
		public void setSchaltProgram(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _schaltProgram) {
			this._schaltProgram = _schaltProgram;
		}
	
		/**
		Positive ganze Zahl mit 16 Bits, also im Bereich 0 bis
							65535.
		<p>
		
		</p>
		
		@return der Wert von KonfigurationsID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
			 getKonfigurationsID() {
			return _konfigurationsID;
		}
	
		/**
		Positive ganze Zahl mit 16 Bits, also im Bereich 0 bis
							65535.
		<p>
		
		</p>
		
		@param _konfigurationsID der neue Wert von KonfigurationsID.
		*/
		public void setKonfigurationsID(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
		 _konfigurationsID) {
			this._konfigurationsID = _konfigurationsID;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soSchaltProgram = getSchaltProgram();
					final SystemObject tmpSchaltProgram;
						if (soSchaltProgram instanceof SystemObject) {
							tmpSchaltProgram = (SystemObject)soSchaltProgram;
						} else if(soSchaltProgram instanceof SystemObjekt){
							tmpSchaltProgram = ((SystemObjekt)soSchaltProgram).getSystemObject();
						} else{
							tmpSchaltProgram = null;
						}
					datum.getReferenceValue("SchaltProgram").setSystemObject(tmpSchaltProgram);
				// GanzzahlAttributTyp
				if (getKonfigurationsID() != null) {
	                if (getKonfigurationsID().isZustand()) {
	                    datum.getUnscaledValue("KonfigurationsID").setText(getKonfigurationsID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("KonfigurationsID").set(getKonfigurationsID().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idSchaltProgram = daten.getReferenceValue("SchaltProgram").getId();
					final SystemObjekt tmpSchaltProgram;
					if (idSchaltProgram == 0) {
						tmpSchaltProgram = null;
					} else {
						final SystemObject soSchaltProgram = factory.getDav().getDataModel().getObject(idSchaltProgram);
						if (soSchaltProgram == null) {
								tmpSchaltProgram = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idSchaltProgram);
						} else {
							tmpSchaltProgram = factory.getModellobjekt(soSchaltProgram);
						}
					}
					setSchaltProgram((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpSchaltProgram);
				// GanzzahlAttributTyp
						setKonfigurationsID(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
						(daten.
							getUnscaledValue
						("KonfigurationsID").
								intValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcTPortKonfigurationNachProgramm clone() {
		AtlBcTPortKonfigurationNachProgramm klon = new AtlBcTPortKonfigurationNachProgramm();
		
						klon.setSchaltProgram(getSchaltProgram());
						klon.setKonfigurationsID(getKonfigurationsID());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
