/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste mit Referenzen auf alle Detektor Zonen , die im Blickfeld der Kamera liegen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlDetektorZonen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.DetektorZone
			 _detektorZonenReferenz
			;
	
		/**
		Referenz auf eine Detektor Zone.
		<p>
		
		</p>
		
		@return der Wert von DetektorZonenReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.DetektorZone
			 getDetektorZonenReferenz() {
			return _detektorZonenReferenz;
		}
	
		/**
		Referenz auf eine Detektor Zone.
		<p>
		
		</p>
		
		@param _detektorZonenReferenz der neue Wert von DetektorZonenReferenz.
		*/
		public void setDetektorZonenReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.DetektorZone
		 _detektorZonenReferenz) {
			this._detektorZonenReferenz = _detektorZonenReferenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soDetektorZonenReferenz = getDetektorZonenReferenz();
					final SystemObject tmpDetektorZonenReferenz;
						if (soDetektorZonenReferenz instanceof SystemObject) {
							tmpDetektorZonenReferenz = (SystemObject)soDetektorZonenReferenz;
						} else if(soDetektorZonenReferenz instanceof SystemObjekt){
							tmpDetektorZonenReferenz = ((SystemObjekt)soDetektorZonenReferenz).getSystemObject();
						} else{
							tmpDetektorZonenReferenz = null;
						}
					datum.getReferenceValue("DetektorZonenReferenz").setSystemObject(tmpDetektorZonenReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idDetektorZonenReferenz = daten.getReferenceValue("DetektorZonenReferenz").getId();
					final SystemObjekt tmpDetektorZonenReferenz;
					if (idDetektorZonenReferenz == 0) {
						tmpDetektorZonenReferenz = null;
					} else {
						final SystemObject soDetektorZonenReferenz = factory.getDav().getDataModel().getObject(idDetektorZonenReferenz);
						if (soDetektorZonenReferenz == null) {
								tmpDetektorZonenReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.impl.DetektorZoneUngueltig(idDetektorZonenReferenz);
						} else {
							tmpDetektorZonenReferenz = factory.getModellobjekt(soDetektorZonenReferenz);
						}
					}
					setDetektorZonenReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.DetektorZone
					) tmpDetektorZonenReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDetektorZonen clone() {
		AtlDetektorZonen klon = new AtlDetektorZonen();
		
						klon.setDetektorZonenReferenz(getDetektorZonenReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
