/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Die Parameter zur Beschreibung einer Quelle fuer DTVLink.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdDtvLinkSource extends AbstractKonfigurationsDatensatz<KdDtvLinkSource.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _description
				= new String
				()
				;
				private String
				 _sourceUrl
				= new String
				()
				;
				private String
				 _receiverType
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _autostart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _selfHealing
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _cycle
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _enableAudio
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _enableVideo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _tryToConnectAD
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _tryToConnectVD
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _enableConsole
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _veryVerbose
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _recoding
				;
				private String
				 _filename
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _limitVolume
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _limitDuration
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Description.
			*/
				public String
				 getDescription() {
				return _description;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _description der neue Wert von Description.
			*/
			public void setDescription(String
			 _description) {
				if (_description.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._description = _description;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von SourceUrl.
			*/
				public String
				 getSourceUrl() {
				return _sourceUrl;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _sourceUrl der neue Wert von SourceUrl.
			*/
			public void setSourceUrl(String
			 _sourceUrl) {
				if (_sourceUrl.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._sourceUrl = _sourceUrl;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von ReceiverType.
			*/
				public String
				 getReceiverType() {
				return _receiverType;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _receiverType der neue Wert von ReceiverType.
			*/
			public void setReceiverType(String
			 _receiverType) {
				if (_receiverType.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._receiverType = _receiverType;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Autostart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAutostart() {
				return _autostart;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _autostart der neue Wert von Autostart.
			*/
			public void setAutostart(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _autostart) {
				this._autostart = _autostart;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von SelfHealing.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSelfHealing() {
				return _selfHealing;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _selfHealing der neue Wert von SelfHealing.
			*/
			public void setSelfHealing(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _selfHealing) {
				this._selfHealing = _selfHealing;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von Cycle.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getCycle() {
				return _cycle;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _cycle der neue Wert von Cycle.
			*/
			public void setCycle(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _cycle) {
				this._cycle = _cycle;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von EnableAudio.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEnableAudio() {
				return _enableAudio;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _enableAudio der neue Wert von EnableAudio.
			*/
			public void setEnableAudio(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _enableAudio) {
				this._enableAudio = _enableAudio;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von EnableVideo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEnableVideo() {
				return _enableVideo;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _enableVideo der neue Wert von EnableVideo.
			*/
			public void setEnableVideo(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _enableVideo) {
				this._enableVideo = _enableVideo;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von TryToConnectAD.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getTryToConnectAD() {
				return _tryToConnectAD;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _tryToConnectAD der neue Wert von TryToConnectAD.
			*/
			public void setTryToConnectAD(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _tryToConnectAD) {
				this._tryToConnectAD = _tryToConnectAD;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von TryToConnectVD.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getTryToConnectVD() {
				return _tryToConnectVD;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _tryToConnectVD der neue Wert von TryToConnectVD.
			*/
			public void setTryToConnectVD(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _tryToConnectVD) {
				this._tryToConnectVD = _tryToConnectVD;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von EnableConsole.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEnableConsole() {
				return _enableConsole;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _enableConsole der neue Wert von EnableConsole.
			*/
			public void setEnableConsole(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _enableConsole) {
				this._enableConsole = _enableConsole;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von VeryVerbose.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getVeryVerbose() {
				return _veryVerbose;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _veryVerbose der neue Wert von VeryVerbose.
			*/
			public void setVeryVerbose(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _veryVerbose) {
				this._veryVerbose = _veryVerbose;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Recoding.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getRecoding() {
				return _recoding;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _recoding der neue Wert von Recoding.
			*/
			public void setRecoding(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _recoding) {
				this._recoding = _recoding;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Filename.
			*/
				public String
				 getFilename() {
				return _filename;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _filename der neue Wert von Filename.
			*/
			public void setFilename(String
			 _filename) {
				if (_filename.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._filename = _filename;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von LimitVolume.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getLimitVolume() {
				return _limitVolume;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _limitVolume der neue Wert von LimitVolume.
			*/
			public void setLimitVolume(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _limitVolume) {
				this._limitVolume = _limitVolume;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von LimitDuration.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getLimitDuration() {
				return _limitDuration;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _limitDuration der neue Wert von LimitDuration.
			*/
			public void setLimitDuration(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _limitDuration) {
				this._limitDuration = _limitDuration;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getDescription() != null) {
						datum.getTextValue("Description").setText(getDescription());
					}
					// ZeichenkettenAttributTyp
					if (getSourceUrl() != null) {
						datum.getTextValue("SourceUrl").setText(getSourceUrl());
					}
					// ZeichenkettenAttributTyp
					if (getReceiverType() != null) {
						datum.getTextValue("ReceiverType").setText(getReceiverType());
					}
					// GanzzahlAttributTyp
					if (getAutostart() != null) {
		                if (getAutostart().isZustand()) {
		                    datum.getUnscaledValue("Autostart").setText(getAutostart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Autostart").set(getAutostart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSelfHealing() != null) {
		                if (getSelfHealing().isZustand()) {
		                    datum.getUnscaledValue("SelfHealing").setText(getSelfHealing().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SelfHealing").set(getSelfHealing().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getCycle() != null) {
		                if (getCycle().isZustand()) {
		                    datum.getUnscaledValue("Cycle").setText(getCycle().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Cycle").set(getCycle().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEnableAudio() != null) {
		                if (getEnableAudio().isZustand()) {
		                    datum.getUnscaledValue("EnableAudio").setText(getEnableAudio().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EnableAudio").set(getEnableAudio().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEnableVideo() != null) {
		                if (getEnableVideo().isZustand()) {
		                    datum.getUnscaledValue("EnableVideo").setText(getEnableVideo().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EnableVideo").set(getEnableVideo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTryToConnectAD() != null) {
		                if (getTryToConnectAD().isZustand()) {
		                    datum.getUnscaledValue("TryToConnectAD").setText(getTryToConnectAD().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TryToConnectAD").set(getTryToConnectAD().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTryToConnectVD() != null) {
		                if (getTryToConnectVD().isZustand()) {
		                    datum.getUnscaledValue("TryToConnectVD").setText(getTryToConnectVD().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TryToConnectVD").set(getTryToConnectVD().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEnableConsole() != null) {
		                if (getEnableConsole().isZustand()) {
		                    datum.getUnscaledValue("EnableConsole").setText(getEnableConsole().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EnableConsole").set(getEnableConsole().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVeryVerbose() != null) {
		                if (getVeryVerbose().isZustand()) {
		                    datum.getUnscaledValue("VeryVerbose").setText(getVeryVerbose().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VeryVerbose").set(getVeryVerbose().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRecoding() != null) {
		                if (getRecoding().isZustand()) {
		                    datum.getUnscaledValue("Recoding").setText(getRecoding().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Recoding").set(getRecoding().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getFilename() != null) {
						datum.getTextValue("Filename").setText(getFilename());
					}
					// GanzzahlAttributTyp
					if (getLimitVolume() != null) {
		                if (getLimitVolume().isZustand()) {
		                    datum.getUnscaledValue("LimitVolume").setText(getLimitVolume().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LimitVolume").set(getLimitVolume().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLimitDuration() != null) {
		                if (getLimitDuration().isZustand()) {
		                    datum.getUnscaledValue("LimitDuration").setText(getLimitDuration().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LimitDuration").set(getLimitDuration().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setDescription(daten.getTextValue("Description").getText());
					// ZeichenkettenAttributTyp
						setSourceUrl(daten.getTextValue("SourceUrl").getText());
					// ZeichenkettenAttributTyp
						setReceiverType(daten.getTextValue("ReceiverType").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Autostart").isState()) {
								setAutostart(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Autostart").getText()));
							} else {
							setAutostart(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Autostart").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SelfHealing").isState()) {
								setSelfHealing(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("SelfHealing").getText()));
							} else {
							setSelfHealing(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("SelfHealing").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setCycle(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("Cycle").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EnableAudio").isState()) {
								setEnableAudio(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EnableAudio").getText()));
							} else {
							setEnableAudio(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EnableAudio").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EnableVideo").isState()) {
								setEnableVideo(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EnableVideo").getText()));
							} else {
							setEnableVideo(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EnableVideo").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TryToConnectAD").isState()) {
								setTryToConnectAD(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("TryToConnectAD").getText()));
							} else {
							setTryToConnectAD(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("TryToConnectAD").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TryToConnectVD").isState()) {
								setTryToConnectVD(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("TryToConnectVD").getText()));
							} else {
							setTryToConnectVD(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("TryToConnectVD").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EnableConsole").isState()) {
								setEnableConsole(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EnableConsole").getText()));
							} else {
							setEnableConsole(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EnableConsole").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VeryVerbose").isState()) {
								setVeryVerbose(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("VeryVerbose").getText()));
							} else {
							setVeryVerbose(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("VeryVerbose").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Recoding").isState()) {
								setRecoding(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Recoding").getText()));
							} else {
							setRecoding(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Recoding").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setFilename(daten.getTextValue("Filename").getText());
					// GanzzahlAttributTyp
							setLimitVolume(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("LimitVolume").
									longValue
							()));
					// GanzzahlAttributTyp
							setLimitDuration(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("LimitDuration").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setDescription(getDescription());
							klon.setSourceUrl(getSourceUrl());
							klon.setReceiverType(getReceiverType());
							klon.setAutostart(getAutostart());
							klon.setSelfHealing(getSelfHealing());
							klon.setCycle(getCycle());
							klon.setEnableAudio(getEnableAudio());
							klon.setEnableVideo(getEnableVideo());
							klon.setTryToConnectAD(getTryToConnectAD());
							klon.setTryToConnectVD(getTryToConnectVD());
							klon.setEnableConsole(getEnableConsole());
							klon.setVeryVerbose(getVeryVerbose());
							klon.setRecoding(getRecoding());
							klon.setFilename(getFilename());
							klon.setLimitVolume(getLimitVolume());
							klon.setLimitDuration(getLimitDuration());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.dtvLinkSource";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDtvLinkSource(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
