/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Die Parameter des Vss Servers.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdVssServerParameter extends AbstractKonfigurationsDatensatz<KdVssServerParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _user
				= new String
				()
				;
				private String
				 _password
				= new String
				()
				;
				private String
				 _urlServerTemplate
				= new String
				()
				;
				private String
				 _urlSourceTemplate
				= new String
				()
				;
				private String
				 _urlTargetTemplate
				= new String
				()
				;
				private String
				 _urlConfiguration
				= new String
				()
				;
				private String
				 _urlResetVSSServer
				= new String
				()
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von User.
			*/
				public String
				 getUser() {
				return _user;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _user der neue Wert von User.
			*/
			public void setUser(String
			 _user) {
				if (_user.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._user = _user;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Password.
			*/
				public String
				 getPassword() {
				return _password;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _password der neue Wert von Password.
			*/
			public void setPassword(String
			 _password) {
				if (_password.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._password = _password;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von UrlServerTemplate.
			*/
				public String
				 getUrlServerTemplate() {
				return _urlServerTemplate;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _urlServerTemplate der neue Wert von UrlServerTemplate.
			*/
			public void setUrlServerTemplate(String
			 _urlServerTemplate) {
				if (_urlServerTemplate.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._urlServerTemplate = _urlServerTemplate;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von UrlSourceTemplate.
			*/
				public String
				 getUrlSourceTemplate() {
				return _urlSourceTemplate;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _urlSourceTemplate der neue Wert von UrlSourceTemplate.
			*/
			public void setUrlSourceTemplate(String
			 _urlSourceTemplate) {
				if (_urlSourceTemplate.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._urlSourceTemplate = _urlSourceTemplate;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von UrlTargetTemplate.
			*/
				public String
				 getUrlTargetTemplate() {
				return _urlTargetTemplate;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _urlTargetTemplate der neue Wert von UrlTargetTemplate.
			*/
			public void setUrlTargetTemplate(String
			 _urlTargetTemplate) {
				if (_urlTargetTemplate.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._urlTargetTemplate = _urlTargetTemplate;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von UrlConfiguration.
			*/
				public String
				 getUrlConfiguration() {
				return _urlConfiguration;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _urlConfiguration der neue Wert von UrlConfiguration.
			*/
			public void setUrlConfiguration(String
			 _urlConfiguration) {
				if (_urlConfiguration.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._urlConfiguration = _urlConfiguration;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von UrlResetVSSServer.
			*/
				public String
				 getUrlResetVSSServer() {
				return _urlResetVSSServer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _urlResetVSSServer der neue Wert von UrlResetVSSServer.
			*/
			public void setUrlResetVSSServer(String
			 _urlResetVSSServer) {
				if (_urlResetVSSServer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._urlResetVSSServer = _urlResetVSSServer;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getUser() != null) {
						datum.getTextValue("User").setText(getUser());
					}
					// ZeichenkettenAttributTyp
					if (getPassword() != null) {
						datum.getTextValue("Password").setText(getPassword());
					}
					// ZeichenkettenAttributTyp
					if (getUrlServerTemplate() != null) {
						datum.getTextValue("UrlServerTemplate").setText(getUrlServerTemplate());
					}
					// ZeichenkettenAttributTyp
					if (getUrlSourceTemplate() != null) {
						datum.getTextValue("UrlSourceTemplate").setText(getUrlSourceTemplate());
					}
					// ZeichenkettenAttributTyp
					if (getUrlTargetTemplate() != null) {
						datum.getTextValue("UrlTargetTemplate").setText(getUrlTargetTemplate());
					}
					// ZeichenkettenAttributTyp
					if (getUrlConfiguration() != null) {
						datum.getTextValue("UrlConfiguration").setText(getUrlConfiguration());
					}
					// ZeichenkettenAttributTyp
					if (getUrlResetVSSServer() != null) {
						datum.getTextValue("UrlResetVSSServer").setText(getUrlResetVSSServer());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setUser(daten.getTextValue("User").getText());
					// ZeichenkettenAttributTyp
						setPassword(daten.getTextValue("Password").getText());
					// ZeichenkettenAttributTyp
						setUrlServerTemplate(daten.getTextValue("UrlServerTemplate").getText());
					// ZeichenkettenAttributTyp
						setUrlSourceTemplate(daten.getTextValue("UrlSourceTemplate").getText());
					// ZeichenkettenAttributTyp
						setUrlTargetTemplate(daten.getTextValue("UrlTargetTemplate").getText());
					// ZeichenkettenAttributTyp
						setUrlConfiguration(daten.getTextValue("UrlConfiguration").getText());
					// ZeichenkettenAttributTyp
						setUrlResetVSSServer(daten.getTextValue("UrlResetVSSServer").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setUser(getUser());
							klon.setPassword(getPassword());
							klon.setUrlServerTemplate(getUrlServerTemplate());
							klon.setUrlSourceTemplate(getUrlSourceTemplate());
							klon.setUrlTargetTemplate(getUrlTargetTemplate());
							klon.setUrlConfiguration(getUrlConfiguration());
							klon.setUrlResetVSSServer(getUrlResetVSSServer());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.vssServerParameter";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdVssServerParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
