/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein Event, dass durch ein Vip-T Modul erzeugt wird.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface VbaEventVipt extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.vbaEvent.vipt"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe, um Konfigurationsobjekten
						im Nachhinein
						zusätzliche Eigenschaften geben zu können.
	<p>
	
	</p>
	@return der Datensatz FlexiblesObjektParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.parameter.PdFlexiblesObjektParameter getPdFlexiblesObjektParameter();
	
	/**
	Kennzeichnet den aktuellen Zustand des Events.
	<p>
	
	</p>
	@return der Datensatz VbaEventZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.onlinedaten.OdVbaEventZustand getOdVbaEventZustand();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Kennzeichnet Parameter des Events.
	<p>
	
	</p>
	@return der Datensatz VbaEventParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.parameter.PdVbaEventParameter getPdVbaEventParameter();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Eigenschaften eines Events.
	<p>
	
	</p>
	@return der Datensatz VbaEventEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.konfigurationsdaten.KdVbaEventEigenschaften getKdVbaEventEigenschaften();
	
	/**
	Attributgruppe, um Konfigurationsobjekten
						im Nachhinein
						zusätzliche Online-Attribute geben zu können.
	<p>
	
	</p>
	@return der Datensatz FlexiblesObjektOnline.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.onlinedaten.OdFlexiblesObjektOnline getOdFlexiblesObjektOnline();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Eigenschaften eines Vipt Events.
	<p>
	
	</p>
	@return der Datensatz VbaEventVipt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.konfigurationsdaten.KdVbaEventVipt getKdVbaEventVipt();
	
	/**
	beschreibt die Klassen, in die ein Event entsprechend des
						Gefahrenpotenzials
						eingeteilt werden kann.
	<p>
	
	</p>
	@return der Datensatz VbaEventKlassenParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.parameter.PdVbaEventKlassenParameter getPdVbaEventKlassenParameter();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
